/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Playable;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class WAVEDataType
extends BuiltIn
implements Dynamic {
    public static byte[] MAGIC = new byte[]{82, 73, 70, 70, 0, 0, 0, 0, 87, 65, 86, 69, 102, 109, 116};
    public static byte[] MAGIC_MASK = new byte[]{-1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1};

    public WAVEDataType() {
        this(null);
    }

    public WAVEDataType(DataTypeManager dtm) {
        super(null, "WAVE-Sound", dtm);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public int getLength(MemBuffer buf, int maxLength) {
        try {
            if (!this.checkMagic(buf)) {
                return -1;
            }
            return buf.getInt(4) + 8;
        }
        catch (Exception e) {
            Msg.debug((Object)this, (Object)("Invalid WAV data at " + buf.getAddress()));
            return -1;
        }
    }

    private boolean checkMagic(MemBuffer buf) throws MemoryAccessException {
        for (int i = 0; i < MAGIC.length; ++i) {
            if (MAGIC[i] == (buf.getByte(i) & MAGIC_MASK[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canSpecifyLength() {
        return false;
    }

    @Override
    public boolean isDynamicallySized() {
        return true;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new WAVEDataType(dtm);
    }

    @Override
    public String getDescription() {
        return "WAVE sound stored within program";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "WAV";
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "<WAVE-Resource>";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        byte[] data = new byte[length];
        if (buf.getBytes(data, 0) != length) {
            Msg.error((Object)this, (Object)"WAVE-Sound error: Not enough bytes!");
            return null;
        }
        WAVEData waveData = new WAVEData(data);
        return waveData;
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return WAVEData.class;
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return "WAVE";
    }

    @Override
    public DataType getReplacementBaseType() {
        return ByteDataType.dataType;
    }

    private static class WAVEData
    implements Playable {
        private static final ImageIcon AUDIO_ICON = ResourceManager.loadImage((String)"images/audio-volume-medium.png");
        private byte[] bytes;

        public WAVEData(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public void clicked(MouseEvent event) {
            try {
                Clip clip = AudioSystem.getClip();
                AudioInputStream ais = AudioSystem.getAudioInputStream(new ByteArrayInputStream(this.bytes));
                clip.open(ais);
                clip.start();
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                Msg.debug((Object)this, (Object)"Unable to play audio", (Throwable)e);
            }
        }

        @Override
        public ImageIcon getImageIcon() {
            return AUDIO_ICON;
        }
    }
}

