/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.classfinder.ClassTranslator;

public class ShiftedAddressDataType
extends BuiltIn {
    public static final ShiftedAddressDataType dataType;
    private static SettingsDefinition[] SETTINGS_DEFS;

    public ShiftedAddressDataType() {
        this(null);
    }

    public ShiftedAddressDataType(DataTypeManager dtm) {
        super(null, "ShiftedAddress", dtm);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "addr";
    }

    @Override
    public int getLength() {
        return this.getDataOrganization().getPointerSize();
    }

    @Override
    public boolean isDynamicallySized() {
        return true;
    }

    @Override
    public String getDescription() {
        return "shifted address (as specified by compiler spec)";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        DataOrganization dataOrg = this.getDataOrganization();
        return ShiftedAddressDataType.getAddressValue(buf, dataOrg.getPointerSize(), dataOrg.getPointerShift(), buf.getAddress().getAddressSpace());
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Address.class;
    }

    public static Address getAddressValue(MemBuffer buf, int size, int shift, AddressSpace targetSpace) {
        if (size <= 0 || size > 8) {
            return null;
        }
        if (buf.getAddress() instanceof SegmentedAddress) {
            return null;
        }
        byte[] bytes = new byte[size];
        if (buf.getBytes(bytes, 0) != size) {
            return null;
        }
        boolean isBigEndian = buf.isBigEndian();
        if (!isBigEndian) {
            byte[] flipped = new byte[size];
            for (int i = 0; i < size; ++i) {
                flipped[i] = bytes[size - i - 1];
            }
            bytes = flipped;
        }
        long val = 0L;
        for (byte b : bytes) {
            val = (val << 8) + ((long)b & 0xFFL);
        }
        val <<= shift;
        try {
            return targetSpace.getAddress(val, true);
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    protected String getString(MemBuffer buf, Settings settings) {
        Address addr = (Address)this.getValue(buf, settings, this.getLength());
        if (addr != null) {
            return addr.toString();
        }
        return "??";
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return this.getString(buf, settings);
    }

    @Override
    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return SETTINGS_DEFS;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new ShiftedAddressDataType(dtm);
    }

    static {
        ClassTranslator.put((String)"ghidra.program.model.data.Addr32shft", (String)ShiftedAddressDataType.class.getName());
        ClassTranslator.put((String)"ghidra.program.model.data.Addr32shftDataType", (String)ShiftedAddressDataType.class.getName());
        dataType = new ShiftedAddressDataType();
        SETTINGS_DEFS = new SettingsDefinition[0];
    }
}

