/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import db.DBHandle;
import db.Record;
import db.Table;
import db.util.ErrorHandler;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressKeyAddressIterator;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.references.FromAdapter;
import ghidra.program.database.references.RecordAdapter;
import ghidra.program.database.references.RefList;
import ghidra.program.database.references.RefListV0;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class FromAdapterV0
extends FromAdapter {
    private Table table;
    private AddressMap addrMap;
    private ErrorHandler errHandler;

    FromAdapterV0(DBHandle handle, boolean create, AddressMap addrMap, ErrorHandler errHandler) throws IOException, VersionException {
        this.addrMap = addrMap;
        this.errHandler = errHandler;
        if (create) {
            this.table = handle.createTable("FROM REFS", FROM_REFS_SCHEMA);
        } else {
            this.table = handle.getTable("FROM REFS");
            if (this.table == null) {
                throw new VersionException("Missing Table: FROM REFS");
            }
            if (this.table.getSchema().getVersion() != 0) {
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    public RefList createRefList(ProgramDB program, DBObjectCache<RefList> cache, Address from) throws IOException {
        return new RefListV0(from, (RecordAdapter)this, this.addrMap, program, cache, true);
    }

    @Override
    public RefList getRefList(ProgramDB program, DBObjectCache<RefList> cache, Address from, long fromAddr) throws IOException {
        Record rec = this.table.getRecord(fromAddr);
        if (rec != null) {
            return new RefListV0(rec, (RecordAdapter)this, this.addrMap, program, cache, true);
        }
        return null;
    }

    @Override
    boolean hasRefFrom(long fromAddr) throws IOException {
        return this.table.hasRecord(fromAddr);
    }

    @Override
    public Record createRecord(long key, int numRefs, byte refLevel, byte[] refData) throws IOException {
        Record rec = FROM_REFS_SCHEMA.createRecord(key);
        rec.setIntValue(0, numRefs);
        rec.setBinaryData(1, refData);
        this.table.putRecord(rec);
        return rec;
    }

    @Override
    public Record getRecord(long key) throws IOException {
        return this.table.getRecord(key);
    }

    @Override
    public void putRecord(Record record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    public void removeRecord(long key) throws IOException {
        this.table.deleteRecord(key);
    }

    @Override
    AddressIterator getFromIterator(boolean forward) throws IOException {
        return new AddressKeyAddressIterator(new AddressKeyIterator(this.table, this.addrMap, forward), forward, this.addrMap, this.errHandler);
    }

    @Override
    AddressIterator getFromIterator(Address startAddr, boolean forward) throws IOException {
        return new AddressKeyAddressIterator(new AddressKeyIterator(this.table, this.addrMap, startAddr, forward), forward, this.addrMap, this.errHandler);
    }

    @Override
    AddressIterator getFromIterator(AddressSetView set, boolean forward) throws IOException {
        return new AddressKeyAddressIterator(new AddressKeyIterator(this.table, this.addrMap, set, set.getMinAddress(), forward), forward, this.addrMap, this.errHandler);
    }

    @Override
    int getRecordCount() {
        return this.table.getRecordCount();
    }
}

