/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.Record;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.SourceArchiveAdapter;
import ghidra.program.model.data.ArchiveType;
import ghidra.util.Lock;
import ghidra.util.UniversalID;
import java.io.IOException;

public class SourceArchiveDB
extends DatabaseObject
implements SourceArchive {
    private UniversalID sourceID;
    private Record record;
    private final SourceArchiveAdapter adapter;
    private final DataTypeManagerDB dtMgr;
    private Lock lock;

    public SourceArchiveDB(DataTypeManagerDB dtMgr, DBObjectCache<SourceArchiveDB> cache, SourceArchiveAdapter adapter, Record record) {
        super(cache, record.getKey());
        this.dtMgr = dtMgr;
        this.adapter = adapter;
        this.record = record;
        this.sourceID = new UniversalID(record.getKey());
        this.lock = dtMgr.lock;
    }

    @Override
    public UniversalID getSourceArchiveID() {
        UniversalID universalID;
        if (this.isLocal() && (universalID = this.dtMgr.getUniversalID()) != null) {
            return universalID;
        }
        return this.sourceID;
    }

    private boolean isLocal() {
        return this.record.getKey() == 0L;
    }

    @Override
    public String getDomainFileID() {
        if (this.isLocal()) {
            return this.dtMgr.getDomainFileID();
        }
        return this.record.getString(0);
    }

    @Override
    public ArchiveType getArchiveType() {
        if (this.isLocal()) {
            return this.dtMgr.getType();
        }
        byte byteValue = this.record.getByteValue(2);
        return ArchiveType.values()[byteValue];
    }

    @Override
    public String getName() {
        if (this.isLocal()) {
            return this.dtMgr.getName();
        }
        return this.record.getString(1);
    }

    @Override
    protected boolean refresh() {
        try {
            Record rec = this.adapter.getRecord(this.key);
            if (rec != null) {
                this.record = rec;
                return true;
            }
        }
        catch (IOException e) {
            this.dtMgr.dbError(e);
        }
        return false;
    }

    @Override
    public long getLastSyncTime() {
        return this.record.getLongValue(3);
    }

    @Override
    public boolean isDirty() {
        return this.record.getBooleanValue(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastSyncTime(long syncTime) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.record.setLongValue(3, syncTime);
            this.adapter.updateRecord(this.record);
            this.dtMgr.sourceArchiveChanged(this.getSourceArchiveID());
        }
        catch (IOException e) {
            this.dtMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setDirtyFlag(boolean isDirty) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.record.setBooleanValue(4, isDirty);
            this.adapter.updateRecord(this.record);
            this.dtMgr.sourceArchiveChanged(this.getSourceArchiveID());
        }
        catch (IOException e) {
            this.dtMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setName(String newName) {
        if (this.getName().equals(newName)) {
            return;
        }
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.record.setString(1, newName);
            this.adapter.updateRecord(this.record);
            this.dtMgr.sourceArchiveChanged(this.getSourceArchiveID());
        }
        catch (IOException e) {
            this.dtMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    public String toString() {
        return this.getName();
    }
}

