/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.Field;
import db.LongField;
import db.Record;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.EnumValueDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class EnumValueDBAdapterV0
extends EnumValueDBAdapter {
    static final int VERSION = 0;
    static final int V0_ENUMVAL_NAME_COL = 0;
    static final int V0_ENUMVAL_VALUE_COL = 1;
    static final int V0_ENUMVAL_ID_COL = 2;
    static final Schema V0_ENUM_VALUE_SCHEMA = new Schema(0, "Enum Value ID", new Class[]{StringField.class, LongField.class, LongField.class}, new String[]{"Name", "Value", "Enum ID"});
    private Table valueTable;

    public EnumValueDBAdapterV0(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.valueTable = handle.createTable("Enumeration Values", V0_ENUM_VALUE_SCHEMA, new int[]{2});
        } else {
            this.valueTable = handle.getTable("Enumeration Values");
            if (this.valueTable == null) {
                throw new VersionException("Missing Table: Enumeration Values");
            }
            int version = this.valueTable.getSchema().getVersion();
            if (version != 0) {
                String msg = "Expected version 0 for table Enumeration Values but got " + this.valueTable.getSchema().getVersion();
                if (version < 0) {
                    throw new VersionException(msg, 1, true);
                }
                throw new VersionException(msg, 2, false);
            }
        }
    }

    @Override
    public void createRecord(long enumID, String name, long value) throws IOException {
        Record record = V0_ENUM_VALUE_SCHEMA.createRecord(this.valueTable.getKey());
        record.setLongValue(2, enumID);
        record.setString(0, name);
        record.setLongValue(1, value);
        this.valueTable.putRecord(record);
    }

    @Override
    public Record getRecord(long valueID) throws IOException {
        return this.valueTable.getRecord(valueID);
    }

    @Override
    public void removeRecord(long valueID) throws IOException {
        this.valueTable.deleteRecord(valueID);
    }

    @Override
    public void updateRecord(Record record) throws IOException {
        this.valueTable.putRecord(record);
    }

    @Override
    public long[] getValueIdsInEnum(long enumID) throws IOException {
        return this.valueTable.findRecords((Field)new LongField(enumID), 2);
    }
}

