/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.Record;
import db.Schema;
import ghidra.program.database.data.EnumValueDBAdapterNoTable;
import ghidra.program.database.data.EnumValueDBAdapterV0;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class EnumValueDBAdapter {
    static final String ENUM_VALUE_TABLE_NAME = "Enumeration Values";
    static final Schema ENUM_VALUE_SCHEMA = EnumValueDBAdapterV0.V0_ENUM_VALUE_SCHEMA;
    static final int ENUMVAL_NAME_COL = 0;
    static final int ENUMVAL_VALUE_COL = 1;
    static final int ENUMVAL_ID_COL = 2;

    EnumValueDBAdapter() {
    }

    static EnumValueDBAdapter getAdapter(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == 0) {
            return new EnumValueDBAdapterV0(handle, true);
        }
        try {
            return new EnumValueDBAdapterV0(handle, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            EnumValueDBAdapter adapter = EnumValueDBAdapter.findReadOnlyAdapter(handle);
            if (openMode == 3) {
                adapter = EnumValueDBAdapter.upgrade(handle, adapter);
            }
            return adapter;
        }
    }

    static EnumValueDBAdapter findReadOnlyAdapter(DBHandle handle) {
        return new EnumValueDBAdapterNoTable(handle);
    }

    static EnumValueDBAdapter upgrade(DBHandle handle, EnumValueDBAdapter oldAdapter) throws VersionException, IOException {
        return new EnumValueDBAdapterV0(handle, true);
    }

    abstract void createRecord(long var1, String var3, long var4) throws IOException;

    abstract Record getRecord(long var1) throws IOException;

    abstract void removeRecord(long var1) throws IOException;

    abstract void updateRecord(Record var1) throws IOException;

    abstract long[] getValueIdsInEnum(long var1) throws IOException;
}

