/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcodeCPort.context.FixedHandle;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghsymbol.FamilySymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import java.util.List;
import org.jdom.Element;

public class ValueSymbol
extends FamilySymbol {
    protected PatternValue patval;

    public ValueSymbol(Location location) {
        super(location);
        this.patval = null;
    }

    public ValueSymbol(Location location, String nm, PatternValue pv) {
        super(location, nm);
        this.patval = pv;
        this.patval.layClaim();
    }

    @Override
    public PatternValue getPatternValue() {
        return this.patval;
    }

    @Override
    public PatternExpression getPatternExpression() {
        return this.patval;
    }

    @Override
    public symbol_type getType() {
        return symbol_type.value_symbol;
    }

    @Override
    public void dispose() {
        if (this.patval != null) {
            PatternExpression.release(this.patval);
        }
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker pos) {
        hand.space = pos.getConstSpace();
        hand.offset_space = null;
        hand.offset_offset = this.patval.getValue(pos);
        hand.size = 0;
    }

    @Override
    public void print(PrintStream s, ParserWalker pos) {
        long val = this.patval.getValue(pos);
        if (val >= 0L) {
            s.append("0x");
            s.append(Long.toHexString(val));
        } else {
            s.append("-0x");
            s.append(Long.toHexString(-val));
        }
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<value_sym");
        this.saveSleighSymbolXmlHeader(s);
        s.println(">");
        this.patval.saveXml(s);
        s.println("</value_sym>");
    }

    @Override
    public void saveXmlHeader(PrintStream s) {
        s.append("<value_sym_head");
        this.saveSleighSymbolXmlHeader(s);
        s.println("/>");
    }

    @Override
    public void restoreXml(Element el, SleighBase trans) {
        List list = el.getChildren();
        Element child = (Element)list.get(0);
        this.patval = (PatternValue)PatternExpression.restoreExpression(child, trans);
        this.patval.layClaim();
    }
}

