/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.ValueSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.translate.BadDataError;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class NameSymbol
extends ValueSymbol {
    private VectorSTL<String> nametable = new VectorSTL();
    private boolean tableisfilled;

    public NameSymbol(Location location) {
        super(location);
    }

    public NameSymbol(Location location, String nm, PatternValue pv, VectorSTL<String> nt) {
        super(location, nm, pv);
        this.nametable = nt;
        this.checkTableFill();
    }

    private void checkTableFill() {
        long min = this.patval.minValue();
        long max = this.patval.maxValue();
        this.tableisfilled = min >= 0L && max < (long)this.nametable.size();
        for (int i = 0; i < this.nametable.size(); ++i) {
            if (this.nametable.get(i) != null) continue;
            this.tableisfilled = false;
        }
    }

    @Override
    public Constructor resolve(ParserWalker pos) {
        int ind;
        if (!(this.tableisfilled || (ind = (int)this.patval.getValue(pos)) < this.nametable.size() && ind >= 0 && ((String)this.nametable.get(ind)).length() != 0)) {
            throw new BadDataError("No corresponding entry in nametable <" + this.getName() + ">, index=" + ind);
        }
        return null;
    }

    @Override
    public symbol_type getType() {
        return symbol_type.name_symbol;
    }

    @Override
    public void print(PrintStream s, ParserWalker pos) {
        int ind = (int)this.patval.getValue(pos);
        s.print((String)this.nametable.get(ind));
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<name_sym");
        this.saveSleighSymbolXmlHeader(s);
        s.println(">");
        this.patval.saveXml(s);
        for (int i = 0; i < this.nametable.size(); ++i) {
            String name = (String)this.nametable.get(i);
            if (name != null) {
                s.append("<nametab name=\"");
                s.append(name);
                s.println("\"/>");
                continue;
            }
            s.println("<nametab/>");
        }
        s.println("</name_sym>");
    }

    @Override
    public void saveXmlHeader(PrintStream s) {
        s.append("<name_sym_head");
        this.saveSleighSymbolXmlHeader(s);
        s.println("/>");
    }

    @Override
    public void restoreXml(Element el, SleighBase trans) {
        List list = el.getChildren();
        Iterator iter = list.iterator();
        Element element = (Element)iter.next();
        this.patval = (PatternValue)PatternExpression.restoreExpression(element, trans);
        this.patval.layClaim();
        while (iter.hasNext()) {
            Element child = (Element)iter.next();
            this.nametable.push_back((Object)child.getAttributeValue("name"));
        }
        this.checkTableFill();
    }
}

