/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.slghpatexpress.BinaryExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.utils.MutableInt;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;

public class MultExpression
extends BinaryExpression {
    public MultExpression(Location location) {
        super(location);
    }

    public MultExpression(Location location, PatternExpression l, PatternExpression r) {
        super(location, l, r);
    }

    @Override
    public long getValue(ParserWalker pos) {
        long leftval = this.getLeft().getValue(pos);
        long rightval = this.getRight().getValue(pos);
        return leftval * rightval;
    }

    @Override
    public long getSubValue(VectorSTL<Long> replace, MutableInt listpos) {
        long leftval = this.getLeft().getSubValue(replace, listpos);
        long rightval = this.getRight().getSubValue(replace, listpos);
        return leftval * rightval;
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<mult_exp>\n");
        super.saveXml(s);
        s.append("</mult_exp>\n");
    }
}

