/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.context;

import generic.stl.IteratorSTL;
import generic.stl.VectorSTL;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.pcodeCPort.address.Address;
import ghidra.pcodeCPort.context.ConstructState;
import ghidra.pcodeCPort.context.ContextSet;
import ghidra.pcodeCPort.context.FixedHandle;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.context.ParserWalkerChange;
import ghidra.pcodeCPort.globalcontext.ContextCache;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.OperandSymbol;
import ghidra.pcodeCPort.slghsymbol.TripleSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.translate.BadDataError;

public class ParserContext {
    private ContextState parsestate;
    private AddrSpace const_space;
    private byte[] buf = new byte[16];
    private int[] context;
    private int contextsize;
    private ContextCache contcache;
    private VectorSTL<ContextSet> contextcommit = new VectorSTL();
    private Address addr;
    private Address naddr;
    private VectorSTL<ConstructState> state = new VectorSTL();
    ConstructState base_state;
    private ConstructState point;
    private boolean outofband;
    private int oob_offset;
    private int alloc;
    private int delayslot;

    public void dispose() {
        if (this.context != null) {
            this.context = null;
        }
    }

    private ConstructState getState(int index) {
        ConstructState constructState = (ConstructState)this.state.get(index);
        if (constructState == null) {
            constructState = new ConstructState();
            this.state.set(index, (Object)constructState);
        }
        return constructState;
    }

    public void setAddr(Address ad) {
        this.addr = ad;
    }

    public void setNaddr(Address ad) {
        this.naddr = ad;
    }

    public void clearCommits() {
        this.contextcommit.clear();
    }

    public Address getAddr() {
        return this.addr;
    }

    public Address getNaddr() {
        return this.naddr;
    }

    public AddrSpace getCurSpace() {
        return this.addr.getSpace();
    }

    public AddrSpace getConstSpace() {
        return this.const_space;
    }

    public void setContextWord(int i, int val, int mask) {
        this.context[i] = this.context[i] & ~mask | mask & val;
    }

    public void loadContext() {
        this.contcache.getContext(this.addr, this.context);
    }

    public int getLength() {
        return this.base_state.length;
    }

    public void setDelaySlot(int val) {
        this.delayslot = val;
    }

    public int getDelaySlot() {
        return this.delayslot;
    }

    public ParserContext(ContextCache ccache) {
        this.parsestate = ContextState.uninitialized;
        this.contcache = ccache;
        if (ccache != null) {
            this.contextsize = ccache.getDatabase().getContextSize();
            this.context = new int[this.contextsize];
        } else {
            this.contextsize = 0;
            this.context = null;
        }
    }

    private void resize(VectorSTL<ConstructState> list, int newsize) {
        while (list.size() < newsize) {
            list.push_back((Object)new ConstructState());
        }
        while (list.size() > newsize) {
            list.pop_back();
        }
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public void initialize(int maxstate, int maxparam, AddrSpace spc) {
        this.const_space = spc;
        this.resize(this.state, maxstate);
        this.getState((int)0).parent = null;
        for (int i = 0; i < maxstate; ++i) {
            this.resize(this.getState((int)i).resolve, maxparam);
        }
        this.base_state = this.getState(0);
    }

    public ContextState getParserState() {
        return this.parsestate;
    }

    public void setParserState(ContextState st) {
        this.parsestate = st;
    }

    public void deallocateState(ParserWalkerChange walker) {
        this.alloc = 1;
        walker.context = this;
        walker.baseState();
    }

    public void allocateOperand(int i, ParserWalkerChange walker) {
        ConstructState opstate = (ConstructState)this.state.get(this.alloc++);
        opstate.parent = walker.point;
        opstate.ct = null;
        walker.point.resolve.set(i, (Object)opstate);
        int n = walker.depth++;
        walker.breadcrumb[n] = walker.breadcrumb[n] + 1;
        walker.point = opstate;
        walker.breadcrumb[walker.depth] = 0;
    }

    public int getInstructionBytes(int bytestart, int size, int off) {
        if ((off += bytestart) >= 16) {
            throw new BadDataError("Instruction is using more than 16 bytes");
        }
        int res = 0;
        for (int i = 0; i < size; ++i) {
            res <<= 8;
            res |= this.buf[i + off];
        }
        return res;
    }

    public int getInstructionBits(int startbit, int size, int off) {
        if ((off += startbit / 8) >= 16) {
            throw new BadDataError("Instruction is using more than 16 bytes");
        }
        int bytesize = ((startbit %= 8) + size - 1) / 8 + 1;
        int res = 0;
        for (int i = 0; i < bytesize; ++i) {
            res <<= 8;
            res |= this.buf[i + off];
        }
        res <<= 8 * (4 - bytesize) + startbit;
        return res >>= 32 - size;
    }

    public int getContextBytes(int bytestart, int size) {
        int res = this.context[bytestart / 4];
        res <<= bytestart % 4 * 8;
        return res >>>= (4 - size) * 8;
    }

    public int getContextBits(int startbit, int size) {
        int res = this.context[startbit / 32];
        res <<= startbit % 32;
        return res >>>= 32 - size;
    }

    public void setOffsetOutOfBand(Constructor c, int index) {
        this.outofband = true;
        ConstructState pt = this.point;
        while (pt.ct != c) {
            if (pt == this.getState(0)) {
                return;
            }
            pt = pt.parent;
        }
        OperandSymbol sym = c.getOperand(index);
        int i = sym.getOffsetBase();
        this.oob_offset = i < 0 ? pt.offset + sym.getRelativeOffset() : ((ConstructState)pt.resolve.get((int)index)).offset;
    }

    public void addCommit(TripleSymbol sym, int num, int mask, boolean flow, ConstructState point) {
        this.contextcommit.push_back((Object)new ContextSet());
        ContextSet set = (ContextSet)this.contextcommit.back();
        set.sym = sym;
        set.point = point;
        set.num = num;
        set.mask = mask;
        set.value = this.context[num] & mask;
        set.flow = flow;
    }

    public void applyCommits() {
        if (this.contextcommit.empty()) {
            return;
        }
        ParserWalker walker = new ParserWalker(this);
        walker.baseState();
        IteratorSTL iter = this.contextcommit.begin();
        while (!iter.isEnd()) {
            TripleSymbol sym = ((ContextSet)iter.get()).sym;
            Address addr = null;
            if (sym.getType() == symbol_type.operand_symbol) {
                int i = ((OperandSymbol)sym).getIndex();
                FixedHandle h = ((ConstructState)((ContextSet)iter.get()).point.resolve.get((int)i)).hand;
                addr = new Address(h.space, h.offset_offset);
            } else {
                FixedHandle hand = new FixedHandle();
                sym.getFixedHandle(hand, walker);
                addr = new Address(hand.space, hand.offset_offset);
            }
            this.contcache.setContext(addr, ((ContextSet)iter.get()).num, ((ContextSet)iter.get()).mask, ((ContextSet)iter.get()).value);
            iter.increment();
        }
    }

    public Address getFlowRefAddr() {
        throw new SleighException("Flow reference (inst_ref) is undefined at " + this.getAddr());
    }

    public Address getFlowDestAddr() {
        throw new SleighException("Flow destination (inst_dest) is undefined at " + this.getAddr());
    }

    public static enum ContextState {
        uninitialized,
        disassembly,
        pcode;

    }
}

