/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractBinaryExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.DefaultSolverHint;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.SolverException;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedConstructor;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.BinaryExpression;
import ghidra.app.plugin.processors.sleigh.expression.ConstantValue;
import ghidra.app.plugin.processors.sleigh.expression.LeftShiftExpression;
import ghidra.app.plugin.processors.sleigh.expression.OrExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.RightShiftExpression;
import ghidra.app.plugin.processors.sleigh.expression.SubExpression;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.xml.XmlPullParser;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class OrExpressionSolver
extends AbstractBinaryExpressionSolver<OrExpression> {
    static final PatternExpression DUMMY = new PatternExpression(){

        @Override
        public long getValue(ParserWalker walker) throws MemoryAccessException {
            return 0L;
        }

        @Override
        public void restoreXml(XmlPullParser parser, SleighLanguage lang) {
        }

        @Override
        public String toString() {
            return null;
        }
    };

    public OrExpressionSolver() {
        super(OrExpression.class);
    }

    @Override
    public MaskedLong compute(MaskedLong lval, MaskedLong rval) {
        return lval.or(rval);
    }

    @Override
    public MaskedLong computeLeft(MaskedLong rval, MaskedLong goal) throws SolverException {
        return goal.invOr(rval);
    }

    protected AssemblyResolution tryCatenationExpression(OrExpression exp, MaskedLong goal, Map<String, Long> vals, Map<Integer, Object> res, AssemblyResolvedConstructor cur, Set<SolverHint> hints, String description) throws SolverException {
        TreeMap<Long, PatternExpression> fields = new TreeMap<Long, PatternExpression>();
        fields.put(0L, new ConstantValue(0L));
        this.collectComponentsOr(exp, 0L, fields, vals, res, cur);
        fields.put(64L, new ConstantValue(0L));
        long lo = 0L;
        PatternExpression fieldExp = null;
        AssemblyResolvedConstructor result = AssemblyResolution.nop(description, null);
        try (DbgTimer.DbgCtx dc = this.dbg.start("Trying solution of field catenation");){
            this.dbg.println("Original: " + goal + ":= " + exp);
            for (Map.Entry ent : fields.entrySet()) {
                long hi = (Long)ent.getKey();
                if (hi == 0L) {
                    fieldExp = (PatternExpression)ent.getValue();
                    continue;
                }
                this.dbg.println("Part(" + hi + ":" + lo + "]:= " + fieldExp);
                MaskedLong part = goal.shiftLeft(64L - hi).shiftRightPositional(64L - hi + lo);
                this.dbg.println("Solving: " + part + ":= " + fieldExp);
                AssemblyResolution sol = this.solver.solve(fieldExp, part, vals, res, cur, hints, description + " with shift " + lo);
                if (sol.isError()) {
                    AssemblyResolution assemblyResolution = sol;
                    return assemblyResolution;
                }
                if ((result = result.combine((AssemblyResolvedConstructor)sol)) == null) {
                    throw new SolverException("Solutions to individual fields produced conflict");
                }
                lo = hi;
                fieldExp = (PatternExpression)ent.getValue();
            }
        }
        return result;
    }

    protected AssemblyResolution tryCircularShiftExpression(OrExpression exp, MaskedLong goal, Map<String, Long> vals, Map<Integer, Object> res, AssemblyResolvedConstructor cur, Set<SolverHint> hints, String description) throws SolverException {
        PatternExpression c;
        MaskedLong cc;
        SubExpression sub;
        int leftdir;
        if (exp.getLeft() instanceof LeftShiftExpression && exp.getRight() instanceof RightShiftExpression) {
            leftdir = 0;
        } else if (exp.getLeft() instanceof RightShiftExpression && exp.getRight() instanceof LeftShiftExpression) {
            leftdir = 1;
        } else {
            throw new SolverException("Not a circular shift");
        }
        BinaryExpression left = (BinaryExpression)exp.getLeft();
        BinaryExpression right = (BinaryExpression)exp.getRight();
        PatternExpression expValu1 = left.getLeft();
        PatternExpression expValu2 = right.getLeft();
        if (!expValu1.equals(expValu2)) {
            throw new SolverException("Not a circular shift");
        }
        PatternExpression expShift = null;
        int size = -1;
        int dir = -1;
        PatternExpression s1 = left.getRight();
        PatternExpression s2 = right.getRight();
        if (s1 instanceof SubExpression && (expShift = (sub = (SubExpression)s1).getRight()).equals(s2) && (cc = this.solver.getValue(c = sub.getLeft(), vals, res, cur)).isFullyDefined()) {
            dir = 1 - leftdir;
            size = (int)cc.longValue();
        }
        if (dir == -1 && s2 instanceof SubExpression && (expShift = (sub = (SubExpression)s2).getRight()).equals(s1) && (cc = this.solver.getValue(c = sub.getLeft(), vals, res, cur)).isFullyDefined()) {
            dir = leftdir;
            size = (int)cc.longValue();
        }
        if (dir == -1) {
            throw new SolverException("Not a circular shift (or of known size)");
        }
        this.dbg.println("Identified circular shift: value:= " + expValu1 + ", shift:= " + expShift + ", size:= " + size + ", dir:= " + (dir == 1 ? "right" : "left"));
        return this.solveLeftCircularShift(expValu1, expShift, size, dir, goal, vals, res, cur, hints, description);
    }

    protected AssemblyResolution solveLeftCircularShift(PatternExpression expValue, PatternExpression expShift, int size, int dir, MaskedLong goal, Map<String, Long> vals, Map<Integer, Object> res, AssemblyResolvedConstructor cur, Set<SolverHint> hints, String description) throws NeedsBackfillException, SolverException {
        MaskedLong valValue = this.solver.getValue(expValue, vals, res, cur);
        MaskedLong valShift = this.solver.getValue(expShift, vals, res, cur);
        if (valValue != null && !valValue.isFullyDefined()) {
            if (!valValue.isFullyUndefined()) {
                this.dbg.println("Partially-defined f for left circular shift solver: " + valValue);
            }
            valValue = null;
        }
        if (valShift != null && valShift.isFullyDefined()) {
            if (!valShift.isFullyUndefined()) {
                this.dbg.println("Partially-defined g for left circular shift solver: " + valShift);
            }
            valShift = null;
        }
        if (valValue != null && valShift != null) {
            throw new AssertionError((Object)"Should not have constants when solving special forms");
        }
        if (valValue != null) {
            return this.solver.solve(expShift, this.computeCircShiftG(valValue, size, dir, goal), vals, res, cur, hints, description);
        }
        if (valShift != null) {
            return this.solver.solve(expValue, this.computeCircShiftF(valShift, size, dir, goal), vals, res, cur, hints, description);
        }
        if (hints.contains(DefaultSolverHint.GUESSING_CIRCULAR_SHIFT_AMOUNT)) {
            throw new SolverException("Already guessing circular shift amount. Try to express a double-shift as a shift by sum.");
        }
        Set<SolverHint> hintsWithCircularShift = SolverHint.with(hints, DefaultSolverHint.GUESSING_CIRCULAR_SHIFT_AMOUNT);
        for (int shift = 0; shift < size; ++shift) {
            try {
                MaskedLong reqShift = MaskedLong.fromLong(shift);
                MaskedLong reqValue = this.computeCircShiftF(reqShift, size, dir, goal);
                AssemblyResolution resValue = this.solver.solve(expValue, reqValue, vals, res, cur, hintsWithCircularShift, description);
                if (resValue.isError()) {
                    AssemblyResolvedError err = (AssemblyResolvedError)resValue;
                    throw new SolverException("Solving f failed: " + err.getError());
                }
                AssemblyResolution resShift = this.solver.solve(expShift, reqShift, vals, res, cur, hints, description);
                if (resShift.isError()) {
                    AssemblyResolvedError err = (AssemblyResolvedError)resShift;
                    throw new SolverException("Solving g failed: " + err.getError());
                }
                AssemblyResolvedConstructor solValue = (AssemblyResolvedConstructor)resValue;
                AssemblyResolvedConstructor solShift = (AssemblyResolvedConstructor)resShift;
                AssemblyResolvedConstructor sol = solValue.combine(solShift);
                if (sol == null) {
                    throw new SolverException("value and shift solutions conflict for shift=" + shift);
                }
                return sol;
            }
            catch (SolverException | UnsupportedOperationException e) {
                Msg.trace((Object)this, (Object)("Shift of " + shift + " resulted in " + e));
                continue;
            }
        }
        throw new SolverException("Could not solve circular shift with variable bits and shift amount");
    }

    protected MaskedLong computeCircShiftG(MaskedLong fval, int size, int dir, MaskedLong goal) throws SolverException {
        long acc = 0L;
        for (int i = 0; i < size; ++i) {
            if (!fval.shiftCircular(i, size, dir).agrees(goal)) continue;
            return MaskedLong.fromLong(i);
        }
        if (Long.bitCount(acc) == 1) {
            return MaskedLong.fromLong(Long.numberOfTrailingZeros(acc));
        }
        throw new SolverException("Cannot solve for the circular shift amount");
    }

    protected MaskedLong computeCircShiftF(MaskedLong gval, int size, int dir, MaskedLong goal) {
        return goal.shiftCircular(gval, size, 1 - dir);
    }

    @Override
    protected AssemblyResolution solveTwoSided(OrExpression exp, MaskedLong goal, Map<String, Long> vals, Map<Integer, Object> res, AssemblyResolvedConstructor cur, Set<SolverHint> hints, String description) throws NeedsBackfillException, SolverException {
        try {
            return this.tryCatenationExpression(exp, goal, vals, res, cur, hints, description);
        }
        catch (Exception e) {
            this.dbg.println("while solving: " + goal + "=:" + exp);
            this.dbg.println(e.getMessage());
            try {
                return this.tryCircularShiftExpression(exp, goal, vals, res, cur, hints, description);
            }
            catch (Exception e2) {
                this.dbg.println("while solving: " + goal + "=:" + exp);
                this.dbg.println(e2.getMessage());
                throw new SolverException("Could not solve two-sided OR");
            }
        }
    }

    void collectComponents(PatternExpression exp, long shift, Map<Long, PatternExpression> components, Map<String, Long> vals, Map<Integer, Object> res, AssemblyResolvedConstructor cur) throws SolverException {
        if (exp instanceof OrExpression) {
            this.collectComponentsOr((OrExpression)exp, shift, components, vals, res, cur);
        } else if (exp instanceof LeftShiftExpression) {
            this.collectComponentsLeft((LeftShiftExpression)exp, shift, components, vals, res, cur);
        } else if (exp instanceof RightShiftExpression) {
            this.collectComponentsRight((RightShiftExpression)exp, shift, components, vals, res, cur);
        } else {
            assert (shift < 64L);
            components.put(shift, exp);
        }
    }

    void collectComponentsOr(OrExpression exp, long shift, Map<Long, PatternExpression> components, Map<String, Long> vals, Map<Integer, Object> res, AssemblyResolvedConstructor cur) throws SolverException {
        this.collectComponents(exp.getLeft(), shift, components, vals, res, cur);
        this.collectComponents(exp.getRight(), shift, components, vals, res, cur);
    }

    void collectComponentsLeft(LeftShiftExpression exp, long shift, Map<Long, PatternExpression> components, Map<String, Long> vals, Map<Integer, Object> res, AssemblyResolvedConstructor cur) throws SolverException {
        MaskedLong adj;
        try {
            adj = this.solver.getValue(exp.getRight(), vals, res, cur);
        }
        catch (NeedsBackfillException e) {
            throw new SolverException("Variable shifts break field catenation solver", e);
        }
        if (adj == null || !adj.isFullyDefined()) {
            throw new SolverException("Variable shifts break field catenation solver");
        }
        this.collectComponents(exp.getLeft(), shift + adj.val, components, vals, res, cur);
    }

    void collectComponentsRight(RightShiftExpression exp, long shift, Map<Long, PatternExpression> components, Map<String, Long> vals, Map<Integer, Object> res, AssemblyResolvedConstructor cur) throws SolverException {
        MaskedLong adj;
        try {
            adj = this.solver.getValue(exp.getRight(), vals, res, cur);
        }
        catch (NeedsBackfillException e) {
            throw new SolverException("Variable shifts break field catenation solver", e);
        }
        if (adj == null || !adj.isFullyDefined()) {
            throw new SolverException("Variable shifts break field catenation solver");
        }
        this.collectComponents(exp.getLeft(), shift - adj.val, components, vals, res, cur);
    }
}

