/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.bytesearch;

import ghidra.util.bytesearch.DittedBitSequence;
import ghidra.util.bytesearch.MatchAction;
import ghidra.util.bytesearch.Pattern;
import ghidra.util.bytesearch.PatternFactory;
import ghidra.util.bytesearch.PostRule;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;

public class PatternPairSet {
    private int totalBitsOfCheck;
    private int postBitsOfCheck;
    private ArrayList<DittedBitSequence> preSequences = new ArrayList();
    private ArrayList<Pattern> postPatterns = new ArrayList();

    public void createFinalPatterns(ArrayList<Pattern> finalpats) {
        for (int i = 0; i < this.postPatterns.size(); ++i) {
            Pattern postpattern = this.postPatterns.get(i);
            int postcheck = postpattern.getNumFixedBits();
            if (postcheck < this.postBitsOfCheck) continue;
            for (int j = 0; j < this.preSequences.size(); ++j) {
                DittedBitSequence prepattern = this.preSequences.get(j);
                int precheck = prepattern.getNumFixedBits();
                if (precheck + postcheck < this.totalBitsOfCheck) continue;
                DittedBitSequence concat = prepattern.concatenate(postpattern);
                Pattern finalpattern = new Pattern(concat, prepattern.getSize(), postpattern.getPostRules(), postpattern.getMatchActions());
                finalpats.add(finalpattern);
            }
        }
    }

    public void extractPostPatterns(ArrayList<Pattern> postpats) {
        for (int i = 0; i < this.postPatterns.size(); ++i) {
            postpats.add(this.postPatterns.get(i));
        }
    }

    public void restoreXml(XmlPullParser parser, PatternFactory pfactory) throws IOException {
        XmlElement el = parser.start(new String[]{"patternpairs"});
        this.totalBitsOfCheck = SpecXmlUtils.decodeInt((String)el.getAttribute("totalbits"));
        this.postBitsOfCheck = SpecXmlUtils.decodeInt((String)el.getAttribute("postbits"));
        parser.start(new String[]{"prepatterns"});
        el = parser.peek();
        while (el.isStart()) {
            DittedBitSequence preseq = new DittedBitSequence();
            preseq.restoreXmlData(parser);
            this.preSequences.add(preseq);
            el = parser.peek();
        }
        parser.end();
        while (parser.peek().isStart()) {
            parser.start(new String[]{"postpatterns"});
            el = parser.peek();
            ArrayList<DittedBitSequence> postdit = new ArrayList<DittedBitSequence>();
            while (el.isStart() && el.getName().equals("data")) {
                DittedBitSequence postseq = new DittedBitSequence();
                postseq.restoreXmlData(parser);
                if (postseq.getNumFixedBits() >= this.postBitsOfCheck) {
                    postdit.add(postseq);
                }
                el = parser.peek();
            }
            ArrayList<PostRule> postRuleArray = new ArrayList<PostRule>();
            ArrayList<MatchAction> matchActionArray = new ArrayList<MatchAction>();
            if (pfactory != null) {
                Pattern.restoreXmlAttributes(postRuleArray, matchActionArray, parser, pfactory);
            }
            PostRule[] postRules = new PostRule[postRuleArray.size()];
            postRuleArray.toArray(postRules);
            MatchAction[] matchActions = new MatchAction[matchActionArray.size()];
            matchActionArray.toArray(matchActions);
            for (int i = 0; i < postdit.size(); ++i) {
                Pattern postpat = new Pattern((DittedBitSequence)postdit.get(i), 0, postRules, matchActions);
                this.postPatterns.add(postpat);
            }
            parser.end();
        }
        parser.end();
    }

    public ArrayList<DittedBitSequence> getPreSequences() {
        return this.preSequences;
    }

    public ArrayList<Pattern> getPostPatterns() {
        return this.postPatterns;
    }

    public int getPostBitsOfCheck() {
        return this.postBitsOfCheck;
    }

    public int getTotalBitsOfCheck() {
        return this.totalBitsOfCheck;
    }
}

