/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.analyzers;

import generic.jar.ResourceFile;
import ghidra.app.analyzers.Patterns;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.function.CreateThunkFunctionCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.Analyzer;
import ghidra.app.services.AnalyzerAdapter;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.PseudoDisassemblerContext;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.DisassemblerContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.AddressSetPropertyMap;
import ghidra.util.Msg;
import ghidra.util.bytesearch.AlignRule;
import ghidra.util.bytesearch.Match;
import ghidra.util.bytesearch.MatchAction;
import ghidra.util.bytesearch.Pattern;
import ghidra.util.bytesearch.PatternFactory;
import ghidra.util.bytesearch.PostRule;
import ghidra.util.bytesearch.SequenceSearchState;
import ghidra.util.constraint.ProgramDecisionTree;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;

public class FunctionStartAnalyzer
extends AbstractAnalyzer
implements PatternFactory {
    private static final String FUNCTION_START_SEARCH = "Function Start Search";
    protected static final String NAME = "Function Start Search";
    private static final String DESCRIPTION = "Search for architecture specific byte patterns: typically starts of functions";
    private static final String PRE_FUNCTION_MATCH_PROPERTY_NAME = "PreFunctionMatch";
    private static final int RESTRICTED_PATTERN_BYTE_RANGE = 32;
    private static final String OPTION_NAME_DATABLOCKS = "Search Data Blocks";
    private static final String OPTION_DESCRIPTION_DATABLOCKS = "Search for byte patterns in blocks that are not executable";
    private static final boolean OPTION_DEFAULT_DATABLOCKS = false;
    private static final String OPTION_NAME_BOOKMARKS = "Bookmark Functions";
    private static final String OPTION_DESCRIPTION_BOOKMARKS = "Place a bookmark at functions that were discovered by a pattern";
    private static final boolean OPTION_DEFAULT_BOOKMARKS = false;
    private static ProgramDecisionTree patternDecisitionTree;
    SequenceSearchState rootState = null;
    SequenceSearchState explicitState = null;
    private boolean executableBlocksOnly = true;
    private boolean setbookmark = false;
    protected boolean hasDataConstraints = false;
    protected boolean hasCodeConstraints = false;
    protected boolean hasFunctionStartConstraints = false;
    protected AddressSetPropertyMap potentialMatchAddressSetPropertyMap;
    private AddressSet funcResult = null;
    private AddressSet potentialFuncResult = null;
    private AddressSet disassemResult = null;
    private AddressSet codeLocations = null;
    protected AddressSet postreqFailedResult = null;
    protected ArrayList<RegisterValue> contextValueList = null;

    private static ProgramDecisionTree getPatternDecisionTree() {
        if (patternDecisitionTree == null) {
            patternDecisitionTree = Patterns.getPatternDecisionTree();
        }
        return patternDecisitionTree;
    }

    public FunctionStartAnalyzer() {
        this("Function Start Search", AnalyzerType.BYTE_ANALYZER);
    }

    public FunctionStartAnalyzer(String name, AnalyzerType analyzerType) {
        super(name, DESCRIPTION, analyzerType);
        this.setPriority(AnalysisPriority.CODE_ANALYSIS.after().after());
        this.setDefaultEnablement(true);
        this.setSupportsOneTimeAnalysis();
    }

    public void setExplicitState(SequenceSearchState explicit) {
        this.explicitState = explicit;
    }

    public void clearExplicitState() {
        this.explicitState = null;
    }

    private void setCurrentContext(Program program, Address addr) {
        if (this.contextValueList == null) {
            return;
        }
        ProgramContext programContext = program.getProgramContext();
        for (RegisterValue contextValue : this.contextValueList) {
            try {
                programContext.setRegisterValue(addr, addr, contextValue);
            }
            catch (ContextChangeException contextChangeException) {}
        }
        this.contextValueList = null;
    }

    private void setDisassemblerContext(Program program, DisassemblerContext pcont) {
        if (this.contextValueList == null) {
            return;
        }
        for (RegisterValue contextValue : this.contextValueList) {
            try {
                pcont.setRegisterValue(contextValue);
            }
            catch (ContextChangeException contextChangeException) {}
        }
    }

    public boolean canAnalyze(Program program) {
        ProgramDecisionTree patternDecisionTree = FunctionStartAnalyzer.getPatternDecisionTree();
        boolean hasPatterns = Patterns.hasPatternFiles(program, patternDecisionTree);
        return hasPatterns;
    }

    public AddressSetPropertyMap getOrCreatePotentialMatchPropertyMap(Program program) {
        if (this.potentialMatchAddressSetPropertyMap != null) {
            return this.potentialMatchAddressSetPropertyMap;
        }
        this.potentialMatchAddressSetPropertyMap = program.getAddressSetPropertyMap(PRE_FUNCTION_MATCH_PROPERTY_NAME);
        if (this.potentialMatchAddressSetPropertyMap != null) {
            return this.potentialMatchAddressSetPropertyMap;
        }
        try {
            this.potentialMatchAddressSetPropertyMap = program.createAddressSetPropertyMap(PRE_FUNCTION_MATCH_PROPERTY_NAME);
        }
        catch (DuplicateNameException e) {
            throw new AssertException("Can't get DuplicateNameException since we tried to get it first");
        }
        return this.potentialMatchAddressSetPropertyMap;
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        MemoryBlock[] blocks;
        SequenceSearchState root = this.initialize(program);
        if (root == null) {
            String message = "Could not initialize a search state.";
            log.appendMsg(this.getName(), message);
            log.setStatus(message);
            return false;
        }
        AddressSet restrictedSet = this.removeNotSearchedAddresses(program, set);
        this.getOrCreatePotentialMatchPropertyMap(program).remove(restrictedSet);
        for (MemoryBlock block2 : blocks = program.getMemory().getBlocks()) {
            MemoryBlock block = block2;
            if (!restrictedSet.intersects(block.getStart(), block.getEnd())) continue;
            try {
                this.searchBlock(root, program, block, (AddressSetView)restrictedSet, monitor);
            }
            catch (IOException e) {
                log.appendMsg("Unable to scan block " + block.getName() + " for function starts");
            }
        }
        AutoAnalysisManager analysisManager = AutoAnalysisManager.getAnalysisManager((Program)program);
        if (!this.disassemResult.isEmpty()) {
            analysisManager.disassemble((AddressSetView)this.disassemResult);
        }
        analysisManager.setProtectedLocations(this.codeLocations);
        if (!this.potentialFuncResult.isEmpty()) {
            this.potentialFuncResult = this.potentialFuncResult.subtract((AddressSetView)this.funcResult);
            analysisManager.scheduleOneTimeAnalysis((Analyzer)new AnalyzerAdapter("Function Start Search delayed", AnalysisPriority.DATA_ANALYSIS.after()){

                public boolean added(Program addedProgram, AddressSetView addedSet, TaskMonitor addedMonitor, MessageLog addedLog) throws CancelledException {
                    AddressIterator addresses = addedSet.getAddresses(true);
                    while (addresses.hasNext() && !addedMonitor.isCancelled()) {
                        Address address = addresses.next();
                        ReferenceIterator referencesTo = addedProgram.getReferenceManager().getReferencesTo(address);
                        while (referencesTo.hasNext()) {
                            Reference reference = referencesTo.next();
                            if (!reference.getReferenceType().isConditional()) continue;
                        }
                        Function funcAt = addedProgram.getFunctionManager().getFunctionContaining(address);
                        if (funcAt != null) {
                            if (funcAt.getEntryPoint().equals((Object)address)) continue;
                            BookmarkManager bookmarkManager = addedProgram.getBookmarkManager();
                            bookmarkManager.setBookmark(address, "Analysis", this.getName() + " Overlap", "Function exists at probable good function start");
                            continue;
                        }
                        new CreateFunctionCmd(address, false).applyTo((DomainObject)addedProgram, addedMonitor);
                    }
                    return true;
                }
            }, (AddressSetView)this.potentialFuncResult);
        }
        if (!this.funcResult.isEmpty()) {
            analysisManager.createFunction((AddressSetView)this.funcResult, false);
        }
        return true;
    }

    private AddressSet removeNotSearchedAddresses(Program program, AddressSetView bset) {
        AddressSet restrictedSet = new AddressSet(bset);
        MemoryBlock[] blocks = program.getMemory().getBlocks();
        boolean hasExecutable = false;
        for (MemoryBlock block : blocks) {
            if (!block.isExecute()) continue;
            hasExecutable = true;
        }
        for (MemoryBlock block : blocks) {
            if (!block.isInitialized()) {
                restrictedSet.deleteRange(block.getStart(), block.getEnd());
                continue;
            }
            if (!this.executableBlocksOnly || !hasExecutable || block.isExecute()) continue;
            restrictedSet.deleteRange(block.getStart(), block.getEnd());
        }
        return restrictedSet;
    }

    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_DATABLOCKS, (Object)false, null, OPTION_DESCRIPTION_DATABLOCKS);
        options.registerOption(OPTION_NAME_BOOKMARKS, (Object)this.setbookmark, null, OPTION_DESCRIPTION_BOOKMARKS);
    }

    public void optionsChanged(Options options, Program program) {
        boolean datablocks = options.getBoolean(OPTION_NAME_DATABLOCKS, false);
        this.executableBlocksOnly = !datablocks;
        this.setbookmark = options.getBoolean(OPTION_NAME_BOOKMARKS, this.setbookmark);
    }

    protected SequenceSearchState initialize(Program program) {
        this.potentialFuncResult = new AddressSet();
        this.disassemResult = new AddressSet();
        this.codeLocations = new AddressSet();
        this.postreqFailedResult = new AddressSet();
        this.funcResult = new AddressSet();
        if (this.explicitState != null) {
            return this.explicitState;
        }
        if (this.rootState != null) {
            return this.rootState;
        }
        ArrayList<Object> patternlist = new ArrayList();
        try {
            ProgramDecisionTree patternDecisionTree = FunctionStartAnalyzer.getPatternDecisionTree();
            ResourceFile[] fileList = Patterns.findPatternFiles(program, patternDecisionTree);
            patternlist = this.readPatterns(fileList, program);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Couldn't load pattern files", (Throwable)e);
            return null;
        }
        if (patternlist == null) {
            return null;
        }
        if (patternlist.size() == 0) {
            return null;
        }
        SequenceSearchState root = SequenceSearchState.buildStateMachine(patternlist);
        return root;
    }

    private ArrayList<Pattern> readPatterns(ResourceFile[] filelist, Program program) {
        ArrayList<Pattern> patlist = new ArrayList<Pattern>();
        boolean success = true;
        for (ResourceFile element : filelist) {
            try {
                Pattern.readPatterns(element, patlist, this);
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Pattern file error (" + element.getAbsolutePath() + ")"), (Throwable)e);
                success = false;
            }
        }
        if (!success) {
            return null;
        }
        return patlist;
    }

    private void searchBlock(SequenceSearchState root, Program program, MemoryBlock block, AddressSetView restrictSet, TaskMonitor monitor) throws IOException, CancelledException {
        AddressSet doneSet = new AddressSet(restrictSet);
        if (doneSet.isEmpty()) {
            doneSet.addRange(block.getStart(), block.getEnd());
        }
        doneSet = doneSet.intersectRange(block.getStart(), block.getEnd());
        Address blockStartAddr = block.getStart();
        AddressRangeIterator addressRanges = doneSet.getAddressRanges();
        while (addressRanges.hasNext()) {
            monitor.checkCanceled();
            AddressRange addressRange = (AddressRange)addressRanges.next();
            monitor.setMessage("Function Search");
            monitor.initialize(doneSet.getNumAddresses());
            monitor.setProgress(0L);
            ArrayList<Match> mymatches = new ArrayList<Match>();
            long streamoffset = blockStartAddr.getOffset();
            long blockOffset = addressRange.getMinAddress().subtract(blockStartAddr);
            if ((blockOffset -= 32L) <= 0L) {
                blockOffset = 0L;
            }
            long maxBlockSearchLength = addressRange.getMaxAddress().subtract(blockStartAddr) - blockOffset + 1L;
            InputStream data = block.getData();
            data.skip(blockOffset);
            root.apply(data, maxBlockSearchLength, mymatches, monitor);
            monitor.checkCanceled();
            monitor.setMessage("Function Search (Examine Matches)");
            monitor.initialize((long)mymatches.size());
            monitor.setProgress(0L);
            for (int i = 0; i < mymatches.size(); ++i) {
                monitor.checkCanceled();
                monitor.setProgress((long)i);
                Match match = mymatches.get(i);
                Address addr = blockStartAddr.add(match.getMarkOffset() + blockOffset);
                if (!match.checkPostRules(streamoffset + blockOffset)) continue;
                MatchAction[] matchactions = match.getMatchActions();
                this.contextValueList = null;
                for (MatchAction matchaction : matchactions) {
                    matchaction.apply(program, addr, match);
                }
                if (!this.postreqFailedResult.contains(addr)) {
                    this.setCurrentContext(program, addr);
                    continue;
                }
                this.contextValueList = null;
            }
        }
    }

    @Override
    public MatchAction getMatchActionByName(String nm) {
        if (nm.equals("funcstart")) {
            return new FunctionStartAction();
        }
        if (nm.equals("possiblefuncstart")) {
            return new PossibleFunctionStartAction();
        }
        if (nm.equals("codeboundary")) {
            return new CodeBoundaryAction();
        }
        if (nm.equals("setcontext")) {
            return new ContextAction();
        }
        return null;
    }

    @Override
    public PostRule getPostRuleByName(String nm) {
        if (nm.equals("align")) {
            return new AlignRule();
        }
        return null;
    }

    public class ContextAction
    implements MatchAction {
        private String contextRegName = null;
        private BigInteger value = null;

        public ContextAction() {
        }

        public ContextAction(String register, BigInteger value) {
            this.contextRegName = register;
            this.value = value;
        }

        @Override
        public void apply(Program program, Address addr, Match match) {
            Register contextReg;
            Listing listing = program.getListing();
            CodeUnit cu = listing.getCodeUnitContaining(addr);
            if (cu != null) {
                if (cu instanceof Data) {
                    if (((Data)cu).isDefined()) {
                        return;
                    }
                } else {
                    return;
                }
            }
            if (FunctionStartAnalyzer.this.contextValueList == null) {
                FunctionStartAnalyzer.this.contextValueList = new ArrayList();
            }
            if ((contextReg = program.getProgramContext().getRegister(this.contextRegName)) != null) {
                FunctionStartAnalyzer.this.contextValueList.add(new RegisterValue(contextReg, this.value));
            }
        }

        @Override
        public void restoreXml(XmlPullParser parser) {
            XmlElement el = parser.start(new String[]{"setcontext"});
            this.contextRegName = el.getAttribute("name");
            long val = SpecXmlUtils.decodeLong((String)el.getAttribute("value"));
            this.value = BigInteger.valueOf(val);
            parser.end();
        }

        public String getName() {
            return this.contextRegName;
        }

        public BigInteger getValue() {
            return this.value;
        }
    }

    public class PossibleFunctionStartAction
    extends FunctionStartAction {
        @Override
        public void apply(Program program, Address addr, Match match) {
            if (!this.checkPreRequisites(program, addr)) {
                return;
            }
            this.applyActionToSet(program, addr, FunctionStartAnalyzer.this.potentialFuncResult, match);
        }

        @Override
        void bookmarkAction(Program program, Address addr, Match match) {
            if (FunctionStartAnalyzer.this.setbookmark) {
                BookmarkManager bookmarkManager = program.getBookmarkManager();
                bookmarkManager.setBookmark(addr, "Analysis", "Possible " + FunctionStartAnalyzer.this.getName(), "Match pattern " + match.getSequenceIndex());
            }
        }

        @Override
        public void restoreXml(XmlPullParser parser) {
            XmlElement el = parser.start(new String[]{"possiblefuncstart"});
            this.restoreXmlAttributes(el);
            parser.end();
        }
    }

    public class FunctionStartAction
    implements MatchAction {
        private String afterName = null;
        private int validcode = 0;
        private String label = null;
        private boolean isThunk = false;
        private boolean noreturn = false;
        boolean validFunction = false;

        @Override
        public void apply(Program program, Address addr, Match match) {
            if (!this.checkPreRequisites(program, addr)) {
                return;
            }
            this.applyActionToSet(program, addr, FunctionStartAnalyzer.this.funcResult, match);
        }

        protected boolean checkPreRequisites(Program program, Address addr) {
            Function func;
            if (this.validFunction && (func = program.getFunctionManager().getFunctionAt(addr)) == null) {
                FunctionStartAnalyzer.this.postreqFailedResult.add(addr);
                FunctionStartAnalyzer.this.potentialMatchAddressSetPropertyMap.add(addr, addr);
                return false;
            }
            if (!this.checkAfterName(program, addr)) {
                FunctionStartAnalyzer.this.postreqFailedResult.add(addr);
                return false;
            }
            if (this.validcode != 0) {
                PseudoDisassembler pseudoDisassembler = new PseudoDisassembler(program);
                PseudoDisassemblerContext pcont = new PseudoDisassemblerContext(program.getProgramContext());
                FunctionStartAnalyzer.this.setDisassemblerContext(program, (DisassemblerContext)pcont);
                boolean isvalid = false;
                if (this.validcode == -1) {
                    isvalid = pseudoDisassembler.checkValidSubroutine(addr, pcont, true, true);
                } else {
                    pseudoDisassembler.setMaxInstructions(this.validcode);
                    isvalid = pseudoDisassembler.checkValidSubroutine(addr, pcont, true, false);
                }
                if (!isvalid) {
                    return false;
                }
            }
            return true;
        }

        protected void applyActionToSet(Program program, Address addr, AddressSet resultSet, Match match) {
            String labelStr;
            if (addr.getOffset() % (long)program.getLanguage().getInstructionAlignment() != 0L) {
                return;
            }
            Listing listing = program.getListing();
            CodeUnit cu = listing.getCodeUnitContaining(addr);
            Function func = listing.getFunctionContaining(addr);
            if (cu != null) {
                if (cu instanceof Data) {
                    if (!((Data)cu).isDefined()) {
                        FunctionStartAnalyzer.this.setCurrentContext(program, addr);
                        FunctionStartAnalyzer.this.disassemResult.add(addr);
                        FunctionStartAnalyzer.this.codeLocations.add(addr);
                        resultSet.add(addr);
                        this.bookmarkAction(program, addr, match);
                    }
                } else {
                    if (func == null && !this.checkAlreadyInFunctionAbove(program, addr)) {
                        resultSet.add(addr);
                        this.bookmarkAction(program, addr, match);
                    }
                    FunctionStartAnalyzer.this.codeLocations.add(addr);
                }
            }
            if (func != null && this.noreturn) {
                func.setNoReturn(true);
            }
            if (func != null && this.isThunk && !func.isThunk()) {
                CreateThunkFunctionCmd createThunkFunctionCmd = new CreateThunkFunctionCmd(addr, false);
                createThunkFunctionCmd.applyTo((DomainObject)program);
            }
            if (this.label != null && this.setFunctionLabel(program, addr, labelStr = this.label) && func != null) {
                AutoAnalysisManager analysisManager = AutoAnalysisManager.getAnalysisManager((Program)program);
                analysisManager.functionDefined((AddressSetView)new AddressSet(addr));
            }
        }

        private boolean setFunctionLabel(Program program, Address addr, String labelStr) {
            boolean createdSym = false;
            SymbolTable symTable = program.getSymbolTable();
            Symbol sym = null;
            try {
                Symbol[] symbols;
                for (Symbol symbol : symbols = symTable.getSymbols(addr)) {
                    if (!symbol.getName().contains(labelStr)) continue;
                    return false;
                }
                sym = symTable.createLabel(addr, labelStr, null, SourceType.ANALYSIS);
                createdSym = true;
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            if (sym != null) {
                sym.setPrimary();
            }
            return createdSym;
        }

        private boolean checkAfterName(Program program, Address addr) {
            if (this.afterName != null) {
                Address addrToCheck = addr.previous();
                if (addrToCheck == null || !program.getMemory().contains(addrToCheck)) {
                    return true;
                }
                MemoryBlock block = program.getMemory().getBlock(addr);
                if (block.getStart().equals((Object)addr)) {
                    return true;
                }
                String name = this.afterName;
                if (name.startsWith("func")) {
                    if (this.checkAlreadyInFunctionAbove(program, addr)) {
                        return false;
                    }
                } else if (name.startsWith("inst")) {
                    Instruction instr = program.getListing().getInstructionContaining(addrToCheck);
                    if (instr == null) {
                        return false;
                    }
                } else if (name.startsWith("data")) {
                    Data data = program.getListing().getDefinedDataContaining(addrToCheck);
                    if (data == null) {
                        return false;
                    }
                } else if (name.startsWith("def")) {
                    Instruction instr = program.getListing().getInstructionContaining(addrToCheck);
                    if (instr != null) {
                        return !this.checkAlreadyInFunctionAbove(program, addr);
                    }
                    Data data = program.getListing().getDefinedDataContaining(addrToCheck);
                    return data != null;
                }
            }
            return true;
        }

        private boolean checkAlreadyInFunctionAbove(Program program, Address addr) {
            Function func = null;
            Address addrBefore = addr.previous();
            func = program.getFunctionManager().getFunctionContaining(addrBefore);
            if (func == null) {
                Instruction instr = program.getListing().getInstructionContaining(addrBefore);
                if (instr != null && addr.equals((Object)instr.getFallThrough())) {
                    return true;
                }
                ReferenceIterator referencesTo = program.getReferenceManager().getReferencesTo(addr);
                for (Reference reference : referencesTo) {
                    RefType referenceType = reference.getReferenceType();
                    if (referenceType.isData() && !referenceType.isRead() && !referenceType.isWrite()) continue;
                    return true;
                }
                return false;
            }
            Function myfunc = program.getFunctionManager().getFunctionContaining(addr);
            return myfunc != null && myfunc.getEntryPoint().equals((Object)func.getEntryPoint());
        }

        void bookmarkAction(Program program, Address addr, Match match) {
            if (FunctionStartAnalyzer.this.setbookmark) {
                BookmarkManager bookmarkManager = program.getBookmarkManager();
                bookmarkManager.setBookmark(addr, "Analysis", FunctionStartAnalyzer.this.getName(), "Match pattern " + match.getSequenceIndex());
            }
        }

        @Override
        public void restoreXml(XmlPullParser parser) {
            XmlElement el = parser.start(new String[]{"funcstart"});
            this.restoreXmlAttributes(el);
            parser.end();
        }

        protected void restoreXmlAttributes(XmlElement el) {
            if (el.hasAttribute("after")) {
                this.afterName = el.getAttribute("after");
                if (this.afterName.startsWith("func")) {
                    FunctionStartAnalyzer.this.hasCodeConstraints = true;
                } else if (this.afterName.startsWith("inst")) {
                    FunctionStartAnalyzer.this.hasCodeConstraints = true;
                } else if (this.afterName.startsWith("data")) {
                    FunctionStartAnalyzer.this.hasDataConstraints = true;
                } else if (this.afterName.startsWith("def")) {
                    FunctionStartAnalyzer.this.hasDataConstraints = true;
                    FunctionStartAnalyzer.this.hasCodeConstraints = true;
                } else {
                    Msg.error((Object)this, (Object)"funcstart pattern attribute 'after' must be one of 'function', 'instruction', 'data', 'defined'");
                }
            }
            if (el.hasAttribute("validcode")) {
                this.validcode = 8;
                String validcodeStr = el.getAttribute("validcode");
                if (validcodeStr.equals("0") || validcodeStr.equals("false")) {
                    this.validcode = 0;
                } else if (validcodeStr.equalsIgnoreCase("true") || validcodeStr.equalsIgnoreCase("subroutine")) {
                    this.validcode = -1;
                } else if (validcodeStr.equalsIgnoreCase("function")) {
                    this.validFunction = true;
                    FunctionStartAnalyzer.this.hasFunctionStartConstraints = true;
                } else {
                    this.validcode = Integer.parseInt(validcodeStr);
                }
            }
            if (el.hasAttribute("label")) {
                String name;
                this.label = name = el.getAttribute("label");
            }
            if (el.hasAttribute("thunk")) {
                this.isThunk = true;
            }
            if (el.hasAttribute("noreturn")) {
                this.noreturn = true;
            }
        }
    }

    public class CodeBoundaryAction
    implements MatchAction {
        @Override
        public void apply(Program program, Address addr, Match match) {
            Listing listing = program.getListing();
            CodeUnit cu = listing.getCodeUnitContaining(addr);
            if (cu != null) {
                if (cu instanceof Data) {
                    if (!((Data)cu).isDefined()) {
                        FunctionStartAnalyzer.this.setCurrentContext(program, addr);
                        FunctionStartAnalyzer.this.disassemResult.add(addr);
                        FunctionStartAnalyzer.this.codeLocations.add(addr);
                    }
                } else {
                    FunctionStartAnalyzer.this.codeLocations.add(addr);
                }
            }
        }

        @Override
        public void restoreXml(XmlPullParser parser) {
            parser.start(new String[]{"codeboundary"});
            parser.end();
        }
    }
}

