/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import org.catacombae.csjc.MutableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.ASCIIStringField;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfsplus.HFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusDate;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusDateField;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusForkData;

public class HFSPlusVolumeHeader
extends MutableStruct
implements StructElements {
    public static final short SIGNATURE_HFS_PLUS = 18475;
    public static final short SIGNATURE_HFSX = 18520;
    private final byte[] signature = new byte[2];
    private final byte[] version = new byte[2];
    private final byte[] attributes = new byte[4];
    private final byte[] lastMountedVersion = new byte[4];
    private final byte[] journalInfoBlock = new byte[4];
    private final byte[] createDate = new byte[4];
    private final byte[] modifyDate = new byte[4];
    private final byte[] backupDate = new byte[4];
    private final byte[] checkedDate = new byte[4];
    private final byte[] fileCount = new byte[4];
    private final byte[] folderCount = new byte[4];
    private final byte[] blockSize = new byte[4];
    private final byte[] totalBlocks = new byte[4];
    private final byte[] freeBlocks = new byte[4];
    private final byte[] nextAllocation = new byte[4];
    private final byte[] rsrcClumpSize = new byte[4];
    private final byte[] dataClumpSize = new byte[4];
    private final HFSCatalogNodeID nextCatalogID;
    private final byte[] writeCount = new byte[4];
    private final byte[] encodingsBitmap = new byte[8];
    private final byte[] finderInfo = new byte[32];
    private final HFSPlusForkData allocationFile;
    private final HFSPlusForkData extentsFile;
    private final HFSPlusForkData catalogFile;
    private final HFSPlusForkData attributesFile;
    private final HFSPlusForkData startupFile;

    public HFSPlusVolumeHeader(byte[] data) {
        this(data, 0);
    }

    public HFSPlusVolumeHeader(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.signature, 0, 2);
        System.arraycopy(data, offset + 2, this.version, 0, 2);
        System.arraycopy(data, offset + 4, this.attributes, 0, 4);
        System.arraycopy(data, offset + 8, this.lastMountedVersion, 0, 4);
        System.arraycopy(data, offset + 12, this.journalInfoBlock, 0, 4);
        System.arraycopy(data, offset + 16, this.createDate, 0, 4);
        System.arraycopy(data, offset + 20, this.modifyDate, 0, 4);
        System.arraycopy(data, offset + 24, this.backupDate, 0, 4);
        System.arraycopy(data, offset + 28, this.checkedDate, 0, 4);
        System.arraycopy(data, offset + 32, this.fileCount, 0, 4);
        System.arraycopy(data, offset + 36, this.folderCount, 0, 4);
        System.arraycopy(data, offset + 40, this.blockSize, 0, 4);
        System.arraycopy(data, offset + 44, this.totalBlocks, 0, 4);
        System.arraycopy(data, offset + 48, this.freeBlocks, 0, 4);
        System.arraycopy(data, offset + 52, this.nextAllocation, 0, 4);
        System.arraycopy(data, offset + 56, this.rsrcClumpSize, 0, 4);
        System.arraycopy(data, offset + 60, this.dataClumpSize, 0, 4);
        this.nextCatalogID = new HFSCatalogNodeID(data, offset + 64);
        System.arraycopy(data, offset + 68, this.writeCount, 0, 4);
        System.arraycopy(data, offset + 72, this.encodingsBitmap, 0, 4);
        System.arraycopy(data, offset + 80, this.finderInfo, 0, 32);
        this.allocationFile = new HFSPlusForkData(data, offset + 112);
        this.extentsFile = new HFSPlusForkData(data, offset + 192);
        this.catalogFile = new HFSPlusForkData(data, offset + 272);
        this.attributesFile = new HFSPlusForkData(data, offset + 352);
        this.startupFile = new HFSPlusForkData(data, offset + 432);
    }

    public HFSPlusVolumeHeader(InputStream is) throws IOException {
        this(Util.fillBuffer((InputStream)is, (byte[])new byte[HFSPlusVolumeHeader._getSize()]), 0);
    }

    private static int _getSize() {
        return 512;
    }

    public short getSignature() {
        return Util.readShortBE((byte[])this.signature);
    }

    public short getVersion() {
        return Util.readShortBE((byte[])this.version);
    }

    public int getAttributes() {
        return Util.readIntBE((byte[])this.attributes);
    }

    public int getLastMountedVersion() {
        return Util.readIntBE((byte[])this.lastMountedVersion);
    }

    public int getJournalInfoBlock() {
        return Util.readIntBE((byte[])this.journalInfoBlock);
    }

    public int getCreateDate() {
        return Util.readIntBE((byte[])this.createDate);
    }

    public int getModifyDate() {
        return Util.readIntBE((byte[])this.modifyDate);
    }

    public int getBackupDate() {
        return Util.readIntBE((byte[])this.backupDate);
    }

    public int getCheckedDate() {
        return Util.readIntBE((byte[])this.checkedDate);
    }

    public int getFileCount() {
        return Util.readIntBE((byte[])this.fileCount);
    }

    public int getFolderCount() {
        return Util.readIntBE((byte[])this.folderCount);
    }

    public int getBlockSize() {
        return Util.readIntBE((byte[])this.blockSize);
    }

    public int getTotalBlocks() {
        return Util.readIntBE((byte[])this.totalBlocks);
    }

    public int getFreeBlocks() {
        return Util.readIntBE((byte[])this.freeBlocks);
    }

    public int getNextAllocation() {
        return Util.readIntBE((byte[])this.nextAllocation);
    }

    public int getRsrcClumpSize() {
        return Util.readIntBE((byte[])this.rsrcClumpSize);
    }

    public int getDataClumpSize() {
        return Util.readIntBE((byte[])this.dataClumpSize);
    }

    public HFSCatalogNodeID getNextCatalogID() {
        return this.nextCatalogID;
    }

    public int getWriteCount() {
        return Util.readIntBE((byte[])this.writeCount);
    }

    public long getEncodingsBitmap() {
        return Util.readLongBE((byte[])this.encodingsBitmap);
    }

    public int[] getFinderInfo() {
        return Util.readIntArrayBE((byte[])this.finderInfo);
    }

    public HFSPlusForkData getAllocationFile() {
        return this.allocationFile;
    }

    public HFSPlusForkData getExtentsFile() {
        return this.extentsFile;
    }

    public HFSPlusForkData getCatalogFile() {
        return this.catalogFile;
    }

    public HFSPlusForkData getAttributesFile() {
        return this.attributesFile;
    }

    public HFSPlusForkData getStartupFile() {
        return this.startupFile;
    }

    public Date getCreateDateAsDate() {
        return HFSPlusDate.localTimestampToDate(this.getCreateDate());
    }

    public Date getModifyDateAsDate() {
        return HFSPlusDate.localTimestampToDate(this.getModifyDate());
    }

    public Date getBackupDateAsDate() {
        return HFSPlusDate.localTimestampToDate(this.getBackupDate());
    }

    public Date getCheckedDateAsDate() {
        return HFSPlusDate.localTimestampToDate(this.getCheckedDate());
    }

    public boolean getAttributeVolumeHardwareLock() {
        return (this.getAttributes() >> 7 & 1) != 0;
    }

    public boolean getAttributeVolumeUnmounted() {
        return (this.getAttributes() >> 8 & 1) != 0;
    }

    public boolean getAttributeVolumeSparedBlocks() {
        return (this.getAttributes() >> 9 & 1) != 0;
    }

    public boolean getAttributeVolumeNoCacheRequired() {
        return (this.getAttributes() >> 10 & 1) != 0;
    }

    public boolean getAttributeBootVolumeInconsistent() {
        return (this.getAttributes() >> 11 & 1) != 0;
    }

    public boolean getAttributeCatalogNodeIDsReused() {
        return (this.getAttributes() >> 12 & 1) != 0;
    }

    public boolean getAttributeVolumeJournaled() {
        return (this.getAttributes() >> 13 & 1) != 0;
    }

    public boolean getAttributeVolumeSoftwareLock() {
        return (this.getAttributes() >> 15 & 1) != 0;
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "signature: \"" + Util.toASCIIString((short)this.getSignature()) + "\"");
        ps.println(prefix + "version: " + this.getVersion());
        ps.println(prefix + "attributes: " + this.getAttributes());
        this.printAttributes(ps, prefix + "  ");
        ps.println(prefix + "lastMountedVersion: " + this.getLastMountedVersion());
        ps.println(prefix + "journalInfoBlock: " + this.getJournalInfoBlock());
        ps.println(prefix + "createDate: " + this.getCreateDateAsDate());
        ps.println(prefix + "modifyDate: " + this.getModifyDateAsDate());
        ps.println(prefix + "backupDate: " + this.getBackupDateAsDate());
        ps.println(prefix + "checkedDate: " + this.getCheckedDateAsDate());
        ps.println(prefix + "fileCount: " + this.getFileCount());
        ps.println(prefix + "folderCount: " + this.getFolderCount());
        ps.println(prefix + "blockSize: " + this.getBlockSize());
        ps.println(prefix + "totalBlocks: " + this.getTotalBlocks());
        ps.println(prefix + "freeBlocks: " + this.getFreeBlocks());
        ps.println(prefix + "nextAllocation: " + this.getNextAllocation());
        ps.println(prefix + "rsrcClumpSize: " + this.getRsrcClumpSize());
        ps.println(prefix + "dataClumpSize: " + this.getDataClumpSize());
        ps.println(prefix + "nextCatalogID: " + this.getNextCatalogID().toString());
        ps.println(prefix + "writeCount: " + this.getWriteCount());
        ps.println(prefix + "encodingsBitmap: " + this.getEncodingsBitmap());
        ps.println(prefix + "encodingsBitmap (hex): 0x" + Util.toHexStringBE((long)this.getEncodingsBitmap()));
        int[] finderInfoInts = this.getFinderInfo();
        for (int i = 0; i < finderInfoInts.length; ++i) {
            ps.println(prefix + "finderInfo[" + i + "]: " + finderInfoInts[i]);
        }
        ps.println(prefix + "allocationFile: ");
        this.allocationFile.print(ps, prefix + "  ");
        ps.println(prefix + "extentsFile: ");
        this.extentsFile.print(ps, prefix + "  ");
        ps.println(prefix + "catalogFile: ");
        this.catalogFile.print(ps, prefix + "  ");
        ps.println(prefix + "attributesFile: ");
        this.attributesFile.print(ps, prefix + "  ");
        ps.println(prefix + "startupFile: ");
        this.startupFile.print(ps, prefix + "  ");
    }

    public void printAttributes(PrintStream ps, int pregap) {
        String pregapString = "";
        for (int i = 0; i < pregap; ++i) {
            pregapString = pregapString + " ";
        }
    }

    public void printAttributes(PrintStream ps, String prefix) {
        int attributesInt = this.getAttributes();
        ps.println(prefix + "kHFSVolumeHardwareLockBit = " + (attributesInt >> 7 & 1));
        ps.println(prefix + "kHFSVolumeUnmountedBit = " + (attributesInt >> 8 & 1));
        ps.println(prefix + "kHFSVolumeSparedBlocksBit = " + (attributesInt >> 9 & 1));
        ps.println(prefix + "kHFSVolumeNoCacheRequiredBit = " + (attributesInt >> 10 & 1));
        ps.println(prefix + "kHFSBootVolumeInconsistentBit = " + (attributesInt >> 11 & 1));
        ps.println(prefix + "kHFSCatalogNodeIDsReusedBit = " + (attributesInt >> 12 & 1));
        ps.println(prefix + "kHFSVolumeJournaledBit = " + (attributesInt >> 13 & 1));
        ps.println(prefix + "kHFSVolumeSoftwareLockBit = " + (attributesInt >> 15 & 1));
    }

    private Dictionary getAttributeElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder("Attributes");
        db.addFlag("kHFSVolumeHardwareLockBit", this.attributes, 7);
        db.addFlag("kHFSVolumeUnmountedBit", this.attributes, 8);
        db.addFlag("kHFSVolumeSparedBlocksBit", this.attributes, 9);
        db.addFlag("kHFSVolumeNoCacheRequiredBit", this.attributes, 10);
        db.addFlag("kHFSBootVolumeInconsistentBit", this.attributes, 11);
        db.addFlag("kHFSCatalogNodeIDsReusedBit", this.attributes, 12);
        db.addFlag("kHFSVolumeJournaledBit", this.attributes, 13);
        db.addFlag("kHFSVolumeSoftwareLockBit", this.attributes, 15);
        return db.getResult();
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(HFSPlusVolumeHeader.class.getSimpleName());
        db.add("signature", new ASCIIStringField(this.signature));
        db.addUIntBE("version", this.version);
        db.add("attributes", this.getAttributeElements());
        db.addUIntBE("lastMountedVersion", this.lastMountedVersion);
        db.addUIntBE("journalInfoBlock", this.journalInfoBlock);
        db.add("createDate", new HFSPlusDateField(this.createDate, true));
        db.add("modifyDate", new HFSPlusDateField(this.modifyDate, true));
        db.add("backupDate", new HFSPlusDateField(this.backupDate, true));
        db.add("checkedDate", new HFSPlusDateField(this.checkedDate, true));
        db.addUIntBE("fileCount", this.fileCount);
        db.addUIntBE("folderCount", this.folderCount);
        db.addUIntBE("blockSize", this.blockSize);
        db.addUIntBE("totalBlocks", this.totalBlocks);
        db.addUIntBE("freeBlocks", this.freeBlocks);
        db.addUIntBE("nextAllocation", this.nextAllocation);
        db.addUIntBE("rsrcClumpSize", this.rsrcClumpSize);
        db.addUIntBE("dataClumpSize", this.dataClumpSize);
        db.add("nextCatalogID", this.nextCatalogID.getStructElements());
        db.addUIntBE("writeCount", this.writeCount);
        db.addUIntBE("encodingsBitmap", this.encodingsBitmap);
        db.addIntArray("finderInfo", this.finderInfo, BITS_32, SIGNED, BIG_ENDIAN);
        db.add("allocationFile", this.allocationFile.getStructElements());
        db.add("extentsFile", this.extentsFile.getStructElements());
        db.add("catalogFile", this.catalogFile.getStructElements());
        db.add("attributesFile", this.attributesFile.getStructElements());
        db.add("startupFile", this.startupFile.getStructElements());
        return db.getResult();
    }
}

