/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;

public class ClangVariableToken
extends ClangToken {
    private Varnode varnode = null;
    private PcodeOp op = null;

    public ClangVariableToken(ClangNode par) {
        super(par);
    }

    @Override
    public Varnode getVarnode() {
        return this.varnode;
    }

    @Override
    public PcodeOp getPcodeOp() {
        return this.op;
    }

    @Override
    public boolean isVariableRef() {
        return true;
    }

    @Override
    public Address getMinAddress() {
        if (this.op == null) {
            return null;
        }
        return this.op.getSeqnum().getTarget().getPhysicalAddress();
    }

    @Override
    public Address getMaxAddress() {
        if (this.op == null) {
            return null;
        }
        return this.op.getSeqnum().getTarget().getPhysicalAddress();
    }

    @Override
    public HighVariable getHighVariable() {
        Varnode inst = this.getVarnode();
        if (inst != null) {
            HighVariable hvar = inst.getHigh();
            if (hvar != null && hvar.getRepresentative() == null) {
                Varnode[] instances = new Varnode[]{inst};
                hvar.attachInstances(instances, inst);
            }
            return inst.getHigh();
        }
        return super.getHighVariable();
    }

    @Override
    public void restoreFromXML(XmlElement el, XmlElement end, PcodeFactory pfactory) {
        String oprefstring;
        super.restoreFromXML(el, end, pfactory);
        String varrefstring = el.getAttribute("varref");
        if (varrefstring != null) {
            int refid = SpecXmlUtils.decodeInt((String)varrefstring);
            this.varnode = pfactory.getRef(refid);
        }
        if ((oprefstring = el.getAttribute("opref")) != null) {
            int refid = SpecXmlUtils.decodeInt((String)oprefstring);
            this.op = pfactory.getOpRef(refid);
        }
    }
}

