/*
 * Decompiled with CFR 0.152.
 */
package db.buffers;

import db.Buffer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class DataBuffer
implements Buffer,
Externalizable {
    public static final long serialVersionUID = 3L;
    public static final String COMPRESSED_SERIAL_OUTPUT_PROPERTY = "db.buffers.DataBuffer.compressedOutput";
    private static boolean enableCompressedSerializationOutput = Boolean.parseBoolean(System.getProperty("db.buffers.DataBuffer.compressedOutput", "false"));
    private static int FORMAT_VERSION = 234;
    private int id;
    protected byte[] data;
    private boolean dirty = false;
    private boolean empty = false;

    public static void enableCompressedSerializationOutput(boolean enable) {
        System.setProperty(COMPRESSED_SERIAL_OUTPUT_PROPERTY, Boolean.toString(enable));
        enableCompressedSerializationOutput = enable;
    }

    public static boolean usingCompressedSerializationOutput() {
        return enableCompressedSerializationOutput;
    }

    public DataBuffer() {
    }

    protected DataBuffer(int bufsize) {
        this.data = new byte[bufsize];
    }

    protected DataBuffer(byte[] data) {
        this.data = data;
    }

    protected byte[] getData() {
        return this.data;
    }

    protected void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public int getId() {
        return this.id;
    }

    protected void setId(int id) {
        this.id = id;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean state) {
        this.dirty = state;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    protected void setEmpty(boolean state) {
        this.empty = state;
    }

    @Override
    public int length() {
        return this.data.length;
    }

    @Override
    public void get(int offset, byte[] bytes, int dataOffset, int length) throws ArrayIndexOutOfBoundsException {
        System.arraycopy(this.data, offset, bytes, dataOffset, length);
    }

    @Override
    public void get(int offset, byte[] bytes) {
        System.arraycopy(this.data, offset, bytes, 0, bytes.length);
    }

    @Override
    public byte[] get(int offset, int length) throws ArrayIndexOutOfBoundsException {
        byte[] bytes = new byte[length];
        System.arraycopy(this.data, offset, bytes, 0, bytes.length);
        return bytes;
    }

    @Override
    public byte getByte(int offset) {
        return this.data[offset];
    }

    @Override
    public int getInt(int offset) {
        return (this.data[offset] & 0xFF) << 24 | (this.data[++offset] & 0xFF) << 16 | (this.data[++offset] & 0xFF) << 8 | this.data[++offset] & 0xFF;
    }

    @Override
    public short getShort(int offset) {
        return (short)((this.data[offset] & 0xFF) << 8 | this.data[++offset] & 0xFF);
    }

    @Override
    public long getLong(int offset) {
        return ((long)this.data[offset] & 0xFFL) << 56 | ((long)this.data[++offset] & 0xFFL) << 48 | ((long)this.data[++offset] & 0xFFL) << 40 | ((long)this.data[++offset] & 0xFFL) << 32 | ((long)this.data[++offset] & 0xFFL) << 24 | ((long)this.data[++offset] & 0xFFL) << 16 | ((long)this.data[++offset] & 0xFFL) << 8 | (long)this.data[++offset] & 0xFFL;
    }

    @Override
    public int put(int offset, byte[] bytes, int dataOffset, int length) {
        this.dirty = true;
        System.arraycopy(bytes, dataOffset, this.data, offset, length);
        return offset + length;
    }

    @Override
    public int put(int offset, byte[] bytes) {
        this.dirty = true;
        System.arraycopy(bytes, 0, this.data, offset, bytes.length);
        return offset + bytes.length;
    }

    @Override
    public int putByte(int offset, byte b) {
        this.dirty = true;
        this.data[offset] = b;
        return ++offset;
    }

    @Override
    public int putInt(int offset, int v) {
        this.dirty = true;
        this.data[offset] = (byte)(v >> 24);
        this.data[++offset] = (byte)(v >> 16);
        this.data[++offset] = (byte)(v >> 8);
        this.data[++offset] = (byte)v;
        return ++offset;
    }

    @Override
    public int putShort(int offset, short v) {
        this.dirty = true;
        this.data[offset] = (byte)(v >> 8);
        this.data[++offset] = (byte)v;
        return ++offset;
    }

    @Override
    public int putLong(int offset, long v) {
        this.dirty = true;
        this.data[offset] = (byte)(v >> 56);
        this.data[++offset] = (byte)(v >> 48);
        this.data[++offset] = (byte)(v >> 40);
        this.data[++offset] = (byte)(v >> 32);
        this.data[++offset] = (byte)(v >> 24);
        this.data[++offset] = (byte)(v >> 16);
        this.data[++offset] = (byte)(v >> 8);
        this.data[++offset] = (byte)v;
        return ++offset;
    }

    public void clear() {
        Arrays.fill(this.data, (byte)0);
    }

    public void move(int src, int dest, int length) {
        this.dirty = true;
        System.arraycopy(this.data, src, this.data, dest, length);
    }

    public void copy(int offset, DataBuffer buf, int bufOffset, int length) {
        this.dirty = true;
        System.arraycopy(buf.data, bufOffset, this.data, offset, length);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        boolean compress = enableCompressedSerializationOutput;
        byte[] compressedData = null;
        int compressedLen = -1;
        if (this.empty || this.data == null) {
            compress = false;
        } else if (compress && (compressedLen = DataBuffer.deflateData(this.data, compressedData = new byte[this.data.length])) < 0) {
            compress = false;
        }
        out.writeInt(FORMAT_VERSION);
        out.writeBoolean(compress);
        out.writeInt(this.id);
        out.writeBoolean(this.dirty);
        out.writeBoolean(this.empty);
        if (this.data == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.data.length);
            if (compress) {
                out.writeInt(compressedLen);
                out.write(compressedData, 0, compressedLen);
            } else if (this.data != null) {
                out.write(this.data);
            }
        }
    }

    private static int deflateData(byte[] data, byte[] compressedData) {
        int compressedDataOffset;
        Deflater deflate = new Deflater(9, true);
        deflate.setStrategy(2);
        deflate.setInput(data, 0, data.length);
        deflate.finish();
        for (compressedDataOffset = 0; !deflate.finished() && compressedDataOffset < compressedData.length; compressedDataOffset += deflate.deflate(compressedData, compressedDataOffset, compressedData.length - compressedDataOffset, 2)) {
        }
        if (!deflate.finished()) {
            return -1;
        }
        return compressedDataOffset;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int formatVersion = in.readInt();
        if (formatVersion != FORMAT_VERSION) {
            throw new IOException("Unsupported DataBuffer serialization");
        }
        boolean compressed = in.readBoolean();
        this.id = in.readInt();
        this.dirty = in.readBoolean();
        this.empty = in.readBoolean();
        int len = in.readInt();
        this.data = null;
        if (len >= 0) {
            this.data = new byte[len];
            if (compressed) {
                int compressedLen = in.readInt();
                byte[] compressedData = new byte[compressedLen];
                in.readFully(compressedData);
                DataBuffer.inflateData(compressedData, this.data);
            } else {
                in.readFully(this.data);
            }
        }
    }

    private static void inflateData(byte[] compressedData, byte[] data) throws IOException {
        Inflater inflater = new Inflater(true);
        inflater.setInput(compressedData, 0, compressedData.length);
        try {
            for (int off = 0; !inflater.finished() && off < data.length; off += inflater.inflate(data, off, data.length - off)) {
                if (!inflater.needsDictionary()) continue;
                throw new IOException("DataBuffer dictionary error");
            }
            if (!inflater.finished()) {
                throw new IOException("DataBuffer inflate size error");
            }
        }
        catch (DataFormatException e) {
            throw new IOException("DataBuffer inflation failed", e);
        }
    }
}

