/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.FixedRecNode;
import db.LongKeyInteriorNode;
import db.LongKeyNode;
import db.NodeMgr;
import db.Record;
import db.Schema;
import db.Table;
import db.VarRecNode;
import db.buffers.DataBuffer;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class LongKeyRecordNode
extends LongKeyNode {
    private static final int ID_SIZE = 4;
    private static final int PREV_LEAF_ID_OFFSET = 5;
    private static final int NEXT_LEAF_ID_OFFSET = 9;
    static final int RECORD_LEAF_HEADER_SIZE = 13;

    LongKeyRecordNode(NodeMgr nodeMgr, DataBuffer buf) {
        super(nodeMgr, buf);
    }

    LongKeyRecordNode(NodeMgr nodeMgr, byte nodeType, int prevLeafId, int nextLeafId) throws IOException {
        super(nodeMgr, nodeType);
        this.buffer.putInt(5, prevLeafId);
        this.buffer.putInt(9, nextLeafId);
    }

    void logConsistencyError(String tableName, String msg, Throwable t) {
        Msg.debug((Object)this, (Object)("Consistency Error (" + tableName + "): " + msg));
        Msg.debug((Object)this, (Object)("  bufferID=" + this.getBufferId() + " key[0]=0x" + Long.toHexString(this.getKey(0))));
        if (t != null) {
            Msg.error((Object)this, (Object)("Consistency Error (" + tableName + ")"), (Throwable)t);
        }
    }

    @Override
    public boolean isConsistent(String tableName, TaskMonitor monitor) throws IOException, CancelledException {
        LongKeyRecordNode node;
        boolean consistent = true;
        long prevKey = 0L;
        for (int i = 0; i < this.keyCount; ++i) {
            long key = this.getKey(i);
            if (i != 0 && key <= prevKey) {
                consistent = false;
                this.logConsistencyError(tableName, "key[" + i + "] <= key[" + (i - 1) + "]", null);
                Msg.debug((Object)this, (Object)("  key[" + i + "].minKey = 0x" + Long.toHexString(key)));
                Msg.debug((Object)this, (Object)("  key[" + (i - 1) + "].minKey = 0x" + Long.toHexString(prevKey)));
            }
            prevKey = key;
        }
        if ((this.parent == null || this.parent.isLeftmostKey(this.getKey(0))) && this.getPreviousLeaf() != null) {
            consistent = false;
            this.logConsistencyError(tableName, "previous-leaf should not exist", null);
        }
        if ((node = this.getNextLeaf()) != null) {
            if (this.parent == null || this.parent.isRightmostKey(this.getKey(0))) {
                consistent = false;
                this.logConsistencyError(tableName, "next-leaf should not exist", null);
            } else {
                LongKeyRecordNode me = node.getPreviousLeaf();
                if (me != this) {
                    consistent = false;
                    this.logConsistencyError(tableName, "next-leaf is not linked to this leaf", null);
                }
            }
        } else if (this.parent != null && !this.parent.isRightmostKey(this.getKey(0))) {
            consistent = false;
            this.logConsistencyError(tableName, "this leaf is not linked to next-leaf", null);
        }
        return consistent;
    }

    @Override
    LongKeyRecordNode getLeafNode(long key) throws IOException {
        return this;
    }

    LongKeyRecordNode getNextLeaf() throws IOException {
        LongKeyRecordNode leaf = null;
        int nextLeafId = this.buffer.getInt(9);
        if (nextLeafId >= 0) {
            leaf = (LongKeyRecordNode)this.nodeMgr.getLongKeyNode(nextLeafId);
        }
        return leaf;
    }

    LongKeyRecordNode getPreviousLeaf() throws IOException {
        LongKeyRecordNode leaf = null;
        int nextLeafId = this.buffer.getInt(5);
        if (nextLeafId >= 0) {
            leaf = (LongKeyRecordNode)this.nodeMgr.getLongKeyNode(nextLeafId);
        }
        return leaf;
    }

    int getKeyIndex(long key) {
        int min = 0;
        int max = this.keyCount - 1;
        while (min <= max) {
            int i = (min + max) / 2;
            long k = this.getKey(i);
            if (k == key) {
                return i;
            }
            if (k < key) {
                min = i + 1;
                continue;
            }
            max = i - 1;
        }
        return -(min + 1);
    }

    LongKeyNode split() throws IOException {
        int oldSiblingId = this.buffer.getInt(9);
        LongKeyRecordNode newLeaf = this.createNewLeaf(this.buffer.getId(), oldSiblingId);
        DataBuffer newBuf = newLeaf.buffer;
        int newBufId = newBuf.getId();
        this.buffer.putInt(9, newBufId);
        if (oldSiblingId >= 0) {
            LongKeyRecordNode leaf = (LongKeyRecordNode)this.nodeMgr.getLongKeyNode(oldSiblingId);
            leaf.buffer.putInt(5, newBufId);
        }
        this.splitData(newLeaf);
        if (this.parent != null) {
            return this.parent.insert(newBufId, newLeaf.getKey(0));
        }
        return new LongKeyInteriorNode(this.nodeMgr, this.getKey(0), this.buffer.getId(), newLeaf.getKey(0), newBufId);
    }

    LongKeyNode appendLeaf(LongKeyRecordNode leaf) throws IOException {
        leaf.buffer.putInt(5, this.buffer.getId());
        int rightLeafBufId = this.buffer.getInt(9);
        leaf.buffer.putInt(9, rightLeafBufId);
        int newBufId = leaf.buffer.getId();
        this.buffer.putInt(9, newBufId);
        if (rightLeafBufId >= 0) {
            LongKeyNode rightLeaf = this.nodeMgr.getLongKeyNode(rightLeafBufId);
            rightLeaf.buffer.putInt(5, newBufId);
        }
        if (this.parent != null) {
            return this.parent.insert(newBufId, leaf.getKey(0));
        }
        return new LongKeyInteriorNode(this.nodeMgr, this.getKey(0), this.buffer.getId(), leaf.getKey(0), newBufId);
    }

    LongKeyNode removeLeaf() throws IOException {
        long key = this.getKey(0);
        int prevBufferId = this.buffer.getInt(5);
        int nextBufferId = this.buffer.getInt(9);
        if (prevBufferId >= 0) {
            LongKeyRecordNode prevNode = (LongKeyRecordNode)this.nodeMgr.getLongKeyNode(prevBufferId);
            prevNode.getBuffer().putInt(9, nextBufferId);
        }
        if (nextBufferId >= 0) {
            LongKeyRecordNode nextNode = (LongKeyRecordNode)this.nodeMgr.getLongKeyNode(nextBufferId);
            nextNode.getBuffer().putInt(5, prevBufferId);
        }
        this.nodeMgr.deleteNode(this);
        if (this.parent == null) {
            return null;
        }
        return this.parent.deleteChild(key);
    }

    abstract void splitData(LongKeyRecordNode var1);

    abstract LongKeyRecordNode createNewLeaf(int var1, int var2) throws IOException;

    LongKeyNode putRecord(Record record, Table table) throws IOException {
        long key = record.getKey();
        int index = this.getKeyIndex(key);
        if (index >= 0) {
            if (table != null) {
                table.updatedRecord(this.getRecord(table.getSchema(), index), record);
            }
            LongKeyNode newRoot = this.updateRecord(index, record);
            return newRoot;
        }
        if (this.insertRecord(index = -index - 1, record)) {
            if (index == 0 && this.parent != null) {
                this.parent.keyChanged(this.getKey(1), key);
            }
            if (table != null) {
                table.insertedRecord(record);
            }
            return this.getRoot();
        }
        if (index == this.keyCount) {
            LongKeyNode newRoot = this.appendNewLeaf(record);
            if (table != null) {
                table.insertedRecord(record);
            }
            return newRoot;
        }
        LongKeyRecordNode leaf = this.split().getLeafNode(key);
        return leaf.putRecord(record, table);
    }

    LongKeyNode appendNewLeaf(Record record) throws IOException {
        LongKeyRecordNode newLeaf = this.createNewLeaf(-1, -1);
        newLeaf.insertRecord(0, record);
        return this.appendLeaf(newLeaf);
    }

    LongKeyNode deleteRecord(long key, Table table) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            return this.getRoot();
        }
        if (table != null) {
            table.deletedRecord(this.getRecord(table.getSchema(), index));
        }
        if (this.keyCount == 1) {
            LongKeyNode newRoot = this.removeLeaf();
            return newRoot;
        }
        this.remove(index);
        if (index == 0 && this.parent != null) {
            this.parent.keyChanged(key, this.getKey(0));
        }
        return this.getRoot();
    }

    abstract void remove(int var1) throws IOException;

    abstract boolean insertRecord(int var1, Record var2) throws IOException;

    abstract LongKeyNode updateRecord(int var1, Record var2) throws IOException;

    abstract Record getRecord(long var1, Schema var3) throws IOException;

    abstract Record getRecord(Schema var1, int var2) throws IOException;

    Record getRecordBefore(long key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        index = index < 0 ? -index - 2 : --index;
        if (index < 0) {
            LongKeyRecordNode nextLeaf = this.getPreviousLeaf();
            return nextLeaf != null ? nextLeaf.getRecord(schema, nextLeaf.keyCount - 1) : null;
        }
        return this.getRecord(schema, index);
    }

    Record getRecordAfter(long key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        index = index < 0 ? -(index + 1) : ++index;
        if (index == this.keyCount) {
            LongKeyRecordNode nextLeaf = this.getNextLeaf();
            return nextLeaf != null ? nextLeaf.getRecord(schema, 0) : null;
        }
        return this.getRecord(schema, index);
    }

    Record getRecordAtOrBefore(long key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            index = -index - 2;
        }
        if (index < 0) {
            LongKeyRecordNode nextLeaf = this.getPreviousLeaf();
            return nextLeaf != null ? nextLeaf.getRecord(schema, nextLeaf.keyCount - 1) : null;
        }
        return this.getRecord(schema, index);
    }

    Record getRecordAtOrAfter(long key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            index = -(index + 1);
        }
        if (index == this.keyCount) {
            LongKeyRecordNode nextLeaf = this.getNextLeaf();
            return nextLeaf != null ? nextLeaf.getRecord(schema, 0) : null;
        }
        return this.getRecord(schema, index);
    }

    static LongKeyRecordNode createRecordNode(NodeMgr nodeMgr, Schema schema) throws IOException {
        LongKeyRecordNode node = null;
        node = schema.isVariableLength() ? new VarRecNode(nodeMgr, -1, -1) : new FixedRecNode(nodeMgr, schema.getFixedLength(), -1, -1);
        return node;
    }
}

