/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.keys.keyresolver;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class KeyResolverTest
extends TestCase {
    static /* synthetic */ Class class$org$apache$xml$security$test$keys$keyresolver$KeyResolverTest;
    static /* synthetic */ Class class$org$apache$xml$security$test$keys$keyresolver$KeyResolverTest$MyPrivateKeyResolver;

    public KeyResolverTest() {
        super("KeyResolverTest");
    }

    public KeyResolverTest(String string) {
        super(string);
        Init.init();
    }

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$keys$keyresolver$KeyResolverTest == null ? (class$org$apache$xml$security$test$keys$keyresolver$KeyResolverTest = KeyResolverTest.class$("org.apache.xml.security.test.keys.keyresolver.KeyResolverTest")) : class$org$apache$xml$security$test$keys$keyresolver$KeyResolverTest);
    }

    public void testResolvePrivateKey() throws Exception {
        String string = JCEMapper.translateURItoJCEID((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        boolean bl = false;
        if (string != null) {
            try {
                if (Cipher.getInstance(string) != null) {
                    bl = true;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                // empty catch block
            }
        }
        if (!bl) {
            return;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("root");
        document.appendChild(element);
        Element element2 = document.createElement("elem");
        Text text = document.createTextNode("text");
        element2.appendChild(text);
        element.appendChild(element2);
        byte[] byArray = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7};
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger("8710a2bcb2f3fdac177f0ae0461c2dd0ebf72e0d88a5400583a7d8bdabd6ae009d30cfdf6acb5b6a64cdc730bc630a39d946d08babffe62ea20a87e37c93b3b0e8a8e576045bbddfbde83ca9bfa180fe6a5f5eee60661936d728314e809201ef52cd71d9fa3c8ce83f9d30ab5e081539219e7e45dd6a60be65ac95d2049b8f21", 16), new BigInteger("10001", 16));
        RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(new BigInteger("8710a2bcb2f3fdac177f0ae0461c2dd0ebf72e0d88a5400583a7d8bdabd6ae009d30cfdf6acb5b6a64cdc730bc630a39d946d08babffe62ea20a87e37c93b3b0e8a8e576045bbddfbde83ca9bfa180fe6a5f5eee60661936d728314e809201ef52cd71d9fa3c8ce83f9d30ab5e081539219e7e45dd6a60be65ac95d2049b8f21", 16), new BigInteger("20c39e569c2aa80cc91e5e6b0d56e49e5bbf78827bf56a546c1d996c5975187cb9a50fa828e5efe51d52f5d112c20bc700b836facadca6e0051afcdfe866841e37d207c029536ff8674b301e2198b2c56abb0a0313f8ff84c1fcd6fa541aa6e5d9c018fab4784d2940def5dc709ddc714d73b6c23b5d178eaa5933577b8e8ae9", 16));
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(rSAPrivateKeySpec);
        XMLCipher xMLCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        xMLCipher.init(3, (Key)rSAPublicKey);
        EncryptedKey encryptedKey = xMLCipher.encryptKey(document, (Key)secretKeySpec);
        String string2 = "testResolvePrivateKey";
        KeyInfo keyInfo = new KeyInfo(document);
        keyInfo.addKeyName(string2);
        encryptedKey.setKeyInfo(keyInfo);
        XMLCipher xMLCipher2 = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        xMLCipher2.init(1, (Key)secretKeySpec);
        EncryptedData encryptedData = xMLCipher2.getEncryptedData();
        KeyInfo keyInfo2 = new KeyInfo(document);
        keyInfo2.add(encryptedKey);
        encryptedData.setKeyInfo(keyInfo2);
        xMLCipher2.doFinal(document, element, true);
        Element element3 = (Element)element.getFirstChild();
        KeyResolverTest.assertEquals((String)"EncryptedData", (String)element3.getLocalName());
        MyPrivateKeyResolver.pk = rSAPrivateKey;
        MyPrivateKeyResolver.pkName = string2;
        KeyResolver.registerAtStart((String)(class$org$apache$xml$security$test$keys$keyresolver$KeyResolverTest$MyPrivateKeyResolver == null ? (class$org$apache$xml$security$test$keys$keyresolver$KeyResolverTest$MyPrivateKeyResolver = KeyResolverTest.class$("org.apache.xml.security.test.keys.keyresolver.KeyResolverTest$MyPrivateKeyResolver")) : class$org$apache$xml$security$test$keys$keyresolver$KeyResolverTest$MyPrivateKeyResolver).getName());
        KeyResolverSpi keyResolverSpi = (KeyResolverSpi)KeyResolver.iterator().next();
        KeyResolverTest.assertEquals((String)(class$org$apache$xml$security$test$keys$keyresolver$KeyResolverTest$MyPrivateKeyResolver == null ? (class$org$apache$xml$security$test$keys$keyresolver$KeyResolverTest$MyPrivateKeyResolver = KeyResolverTest.class$("org.apache.xml.security.test.keys.keyresolver.KeyResolverTest$MyPrivateKeyResolver")) : class$org$apache$xml$security$test$keys$keyresolver$KeyResolverTest$MyPrivateKeyResolver).getName(), (String)keyResolverSpi.getClass().getName());
        XMLCipher xMLCipher3 = XMLCipher.getInstance();
        xMLCipher3.init(2, null);
        xMLCipher3.doFinal(document, element3);
        Element element4 = (Element)element.getFirstChild();
        KeyResolverTest.assertEquals((String)"elem", (String)element4.getLocalName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class MyPrivateKeyResolver
    extends KeyResolverSpi {
        private static PrivateKey pk;
        private static String pkName;

        public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
            return false;
        }

        public PrivateKey engineLookupAndResolvePrivateKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
            String string2;
            if ("http://www.w3.org/2000/09/xmldsig#".equals(element.getNamespaceURI()) && "KeyName".equals(element.getLocalName()) && pkName.equals(string2 = element.getFirstChild().getNodeValue())) {
                return pk;
            }
            return null;
        }
    }
}

