/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftree;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.DirCacheNameConflictException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.reftree.Command;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.util.RawParseUtils;

public class RefTree {
    public static final String PEELED_SUFFIX = " ^";
    static final String ROOT_DOTDOT = "..";
    private DirCache contents;
    private Map<ObjectId, String> pendingBlobs;

    public static RefTree newEmptyTree() {
        return new RefTree(DirCache.newInCore());
    }

    public static RefTree read(ObjectReader reader2, RevTree tree) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        return new RefTree(DirCache.read(reader2, tree));
    }

    private RefTree(DirCache dc) {
        this.contents = dc;
    }

    @Nullable
    public Ref exactRef(ObjectReader reader2, String name2) throws IOException {
        Ref r = this.readRef(reader2, name2);
        if (r == null) {
            return null;
        }
        if (r.isSymbolic()) {
            return this.resolve(reader2, r, 0);
        }
        DirCacheEntry p = this.contents.getEntry(RefTree.peeledPath(name2));
        if (p != null && p.getRawMode() == 57344) {
            return new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, r.getName(), r.getObjectId(), p.getObjectId());
        }
        return r;
    }

    private Ref readRef(ObjectReader reader2, String name2) throws IOException {
        DirCacheEntry e2 = this.contents.getEntry(RefTree.refPath(name2));
        return e2 != null ? this.toRef(reader2, e2, name2) : null;
    }

    private Ref toRef(ObjectReader reader2, DirCacheEntry e2, String name2) throws IOException {
        int mode = e2.getRawMode();
        if (mode == 57344) {
            ObjectId id = e2.getObjectId();
            return new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name2, id);
        }
        if (mode == 40960) {
            String n;
            ObjectId id = e2.getObjectId();
            String string2 = n = this.pendingBlobs != null ? this.pendingBlobs.get(id) : null;
            if (n == null) {
                byte[] bin = reader2.open(id, 3).getCachedBytes();
                n = RawParseUtils.decode(bin);
            }
            ObjectIdRef.Unpeeled dst = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, n, null);
            return new SymbolicRef(name2, dst);
        }
        return null;
    }

    private Ref resolve(ObjectReader reader2, Ref ref2, int depth) throws IOException {
        if (ref2.isSymbolic() && depth < 5) {
            Ref r = this.readRef(reader2, ref2.getTarget().getName());
            if (r == null) {
                return ref2;
            }
            Ref dst = this.resolve(reader2, r, depth + 1);
            return new SymbolicRef(ref2.getName(), dst);
        }
        return ref2;
    }

    public boolean apply(Collection<Command> cmdList) {
        try {
            DirCacheEditor ed = this.contents.editor();
            for (Command cmd : cmdList) {
                if (!RefTree.isValidRef(cmd)) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().funnyRefname);
                    Command.abort(cmdList, null);
                    return false;
                }
                this.apply(ed, cmd);
            }
            ed.finish();
            return true;
        }
        catch (DirCacheNameConflictException e2) {
            String r1 = RefTree.refName(e2.getPath1());
            String r2 = RefTree.refName(e2.getPath2());
            for (Command cmd : cmdList) {
                if (!r1.equals(cmd.getRefName()) && !r2.equals(cmd.getRefName())) continue;
                cmd.setResult(ReceiveCommand.Result.LOCK_FAILURE);
                break;
            }
            Command.abort(cmdList, null);
            return false;
        }
        catch (LockFailureException e3) {
            Command.abort(cmdList, null);
            return false;
        }
    }

    private static boolean isValidRef(Command cmd) {
        String n = cmd.getRefName();
        return "HEAD".equals(n) || Repository.isValidRefName(n);
    }

    private void apply(DirCacheEditor ed, final Command cmd) {
        String path2 = RefTree.refPath(cmd.getRefName());
        Ref oldRef = cmd.getOldRef();
        final Ref newRef = cmd.getNewRef();
        if (newRef == null) {
            RefTree.checkRef(this.contents.getEntry(path2), cmd);
            ed.add(new DirCacheEditor.DeletePath(path2));
            RefTree.cleanupPeeledRef(ed, oldRef);
            return;
        }
        if (newRef.isSymbolic()) {
            final String dst = newRef.getTarget().getName();
            ed.add(new DirCacheEditor.PathEdit(path2){

                @Override
                public void apply(DirCacheEntry ent) {
                    RefTree.checkRef(ent, cmd);
                    ObjectId id = Command.symref(dst);
                    ent.setFileMode(FileMode.SYMLINK);
                    ent.setObjectId(id);
                    if (RefTree.this.pendingBlobs == null) {
                        RefTree.this.pendingBlobs = new HashMap(4);
                    }
                    RefTree.this.pendingBlobs.put(id, dst);
                }
            }.setReplace(false));
            RefTree.cleanupPeeledRef(ed, oldRef);
            return;
        }
        ed.add(new DirCacheEditor.PathEdit(path2){

            @Override
            public void apply(DirCacheEntry ent) {
                RefTree.checkRef(ent, cmd);
                ent.setFileMode(FileMode.GITLINK);
                ent.setObjectId(newRef.getObjectId());
            }
        }.setReplace(false));
        if (newRef.getPeeledObjectId() != null) {
            ed.add(new DirCacheEditor.PathEdit(RefTree.peeledPath(newRef.getName())){

                @Override
                public void apply(DirCacheEntry ent) {
                    ent.setFileMode(FileMode.GITLINK);
                    ent.setObjectId(newRef.getPeeledObjectId());
                }
            }.setReplace(false));
        } else {
            RefTree.cleanupPeeledRef(ed, oldRef);
        }
    }

    private static void checkRef(@Nullable DirCacheEntry ent, Command cmd) {
        if (!cmd.checkRef(ent)) {
            cmd.setResult(ReceiveCommand.Result.LOCK_FAILURE);
            throw new LockFailureException();
        }
    }

    private static void cleanupPeeledRef(DirCacheEditor ed, Ref ref2) {
        if (!(ref2 == null || ref2.isSymbolic() || ref2.isPeeled() && ref2.getPeeledObjectId() == null)) {
            ed.add(new DirCacheEditor.DeletePath(RefTree.peeledPath(ref2.getName())));
        }
    }

    public static String refName(String path2) {
        if (path2.startsWith(ROOT_DOTDOT)) {
            return path2.substring(2);
        }
        return "refs/" + path2;
    }

    static String refPath(String name2) {
        if (name2.startsWith("refs/")) {
            return name2.substring("refs/".length());
        }
        return ROOT_DOTDOT + name2;
    }

    private static String peeledPath(String name2) {
        return RefTree.refPath(name2) + PEELED_SUFFIX;
    }

    public ObjectId writeTree(ObjectInserter inserter) throws IOException {
        if (this.pendingBlobs != null) {
            for (String s : this.pendingBlobs.values()) {
                inserter.insert(3, Constants.encode(s));
            }
            this.pendingBlobs = null;
        }
        return this.contents.writeTree(inserter);
    }

    public RefTree copy() {
        RefTree r = new RefTree(DirCache.newInCore());
        DirCacheBuilder b = r.contents.builder();
        for (int i = 0; i < this.contents.getEntryCount(); ++i) {
            b.add(new DirCacheEntry(this.contents.getEntry(i)));
        }
        b.finish();
        if (this.pendingBlobs != null) {
            r.pendingBlobs = new HashMap<ObjectId, String>(this.pendingBlobs);
        }
        return r;
    }

    private static class LockFailureException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private LockFailureException() {
        }
    }
}

