/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Autoload;
import org.armedbear.lisp.Closure;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.Symbol;

public final class arglist {
    private static final Primitive ARGLIST = new Primitive("arglist", Lisp.PACKAGE_EXT, true, "extended-function-designator"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LispObject execute(LispObject arg) {
            Symbol value2;
            LispObject value1;
            LispThread thread = LispThread.currentThread();
            Operator operator = arglist.getOperator(arg);
            LispObject arglist2 = null;
            if (operator != null) {
                arglist2 = operator.getLambdaList();
            }
            if (arglist2 instanceof AbstractString) {
                String s = arglist2.getStringValue();
                s = "(" + s + ")";
                SpecialBindingsMark mark = thread.markSpecialBindings();
                thread.bindSpecial(Symbol._PACKAGE_, Lisp.PACKAGE_EXT);
                try {
                    arglist2 = Lisp.readObjectFromString(s);
                }
                finally {
                    thread.resetSpecialBindings(mark);
                }
                operator.setLambdaList(arglist2);
            }
            if (arglist2 != null) {
                value1 = arglist2;
                value2 = Lisp.T;
            } else {
                value1 = Lisp.NIL;
                value2 = Lisp.NIL;
            }
            return thread.setValues(value1, value2);
        }
    };
    private static final Primitive _SET_ARGLIST = new Primitive("%set-arglist", Lisp.PACKAGE_SYS, false){

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            LispObject function;
            Operator operator = null;
            if (first instanceof Operator) {
                operator = (Operator)first;
            } else if (first instanceof Symbol && (function = first.getSymbolFunction()) instanceof Operator) {
                operator = (Operator)function;
            }
            if (operator != null) {
                operator.setLambdaList(second);
            }
            return second;
        }
    };

    static final Operator getOperator(LispObject obj) {
        if (obj instanceof Operator) {
            return (Operator)obj;
        }
        if (obj instanceof Symbol) {
            LispObject function = obj.getSymbolFunction();
            if (function instanceof Autoload) {
                Autoload autoload = (Autoload)function;
                autoload.load();
                function = autoload.getSymbol().getSymbolFunction();
            }
            if (function instanceof Operator) {
                Operator operator = (Operator)function;
                if (operator.getLambdaList() != null) {
                    return operator;
                }
                LispObject other = Lisp.get(obj, Symbol.MACROEXPAND_MACRO, null);
                if (other != null) {
                    return arglist.getOperator(other);
                }
                return null;
            }
        } else if (obj instanceof Cons && obj.car() == Symbol.LAMBDA) {
            return new Closure(obj, new Environment());
        }
        return null;
    }
}

