/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class SviasProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("[").number("d{4},").number("d{4},").number("d+,").number("(d+),").number("d+,").number("(d+)(dd)(dd),").number("(d+)(dd)(dd),").number("(-?)(d+)(dd)(d{5}),").number("(-?)(d+)(dd)(d{5}),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d),").number("(d),").number("(d+),").number("(d+),").number("(d+),").any().compile();

    public SviasProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser;
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage("@", remoteAddress));
        }
        if (!(parser = new Parser(PATTERN, (String)msg)).matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN_MIN));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN_MIN));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble() * 0.01));
        position.setCourse(parser.nextDouble() * 0.01);
        position.set("odometer", parser.nextInt() * 100);
        int input = parser.nextInt();
        int output = parser.nextInt();
        position.set("alarm", BitUtil.check(input, 0) ? "sos" : null);
        position.set("ignition", BitUtil.check(input, 4));
        position.setValid(BitUtil.check(output, 0));
        position.set("power", (double)parser.nextInt().intValue() * 0.001);
        position.set("batteryLevel", parser.nextInt());
        position.set("rssi", parser.nextInt());
        return position;
    }
}

