/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import javax.json.JsonObject;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class GeocodeFarmGeocoder
extends JsonGeocoder {
    private static String formatUrl(String key, String language) {
        Object url = "https://www.geocode.farm/v3/json/reverse/";
        url = (String)url + "?lat=%f&lon=%f&country=us&count=1";
        if (key != null) {
            url = (String)url + "&key=" + key;
        }
        if (language != null) {
            url = (String)url + "&lang=" + language;
        }
        return url;
    }

    public GeocodeFarmGeocoder(String key, String language, int cacheSize, AddressFormat addressFormat) {
        super(GeocodeFarmGeocoder.formatUrl(key, language), cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        Address address = new Address();
        JsonObject result = json.getJsonObject("geocoding_results").getJsonArray("RESULTS").getJsonObject(0);
        JsonObject resultAddress = result.getJsonObject("ADDRESS");
        if (result.containsKey((Object)"formatted_address")) {
            address.setFormattedAddress(result.getString("formatted_address"));
        }
        if (resultAddress.containsKey((Object)"street_number")) {
            address.setStreet(resultAddress.getString("street_number"));
        }
        if (resultAddress.containsKey((Object)"street_name")) {
            address.setStreet(resultAddress.getString("street_name"));
        }
        if (resultAddress.containsKey((Object)"locality")) {
            address.setSettlement(resultAddress.getString("locality"));
        }
        if (resultAddress.containsKey((Object)"admin_1")) {
            address.setState(resultAddress.getString("admin_1"));
        }
        if (resultAddress.containsKey((Object)"country")) {
            address.setCountry(resultAddress.getString("country"));
        }
        return address;
    }
}

