/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl.drown;

import de.rub.nds.tlsattacker.attacks.impl.drown.CoprimePairGenerator;
import java.math.BigInteger;

class SievingCoprimePairGenerator
extends CoprimePairGenerator {
    private BigInteger uCandidate = BigInteger.valueOf(1L);
    private BigInteger tCandidate = BigInteger.valueOf(2L);
    private long maxQueryCount;

    public SievingCoprimePairGenerator(long maxQueryCount) {
        this.maxQueryCount = maxQueryCount;
    }

    @Override
    public BigInteger[] next() {
        this.ensureRange();
        while (this.uCandidate.gcd(this.tCandidate).compareTo(BigInteger.valueOf(1L)) != 0) {
            this.uCandidate = this.uCandidate.add(BigInteger.ONE);
            this.ensureRange();
        }
        BigInteger[] pair = new BigInteger[]{this.uCandidate, this.tCandidate};
        this.uCandidate = this.uCandidate.add(BigInteger.ONE);
        ++this.numberOfQueries;
        return pair;
    }

    private void ensureRange() {
        float quotient = this.uCandidate.floatValue() / this.tCandidate.floatValue();
        if (quotient >= 1.5f) {
            this.uCandidate = BigInteger.valueOf(1L);
            this.tCandidate = this.tCandidate.add(BigInteger.ONE);
            quotient = this.uCandidate.floatValue() / this.tCandidate.floatValue();
        }
        while (quotient <= 0.6666667f) {
            this.uCandidate = this.uCandidate.add(BigInteger.ONE);
            quotient = this.uCandidate.floatValue() / this.tCandidate.floatValue();
        }
    }

    @Override
    public boolean hasNext() {
        return this.numberOfQueries < this.maxQueryCount;
    }
}

