/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.compressor.compression;

import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.record.compressor.compression.CompressionAlgorithm;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class DeflateCompression
extends CompressionAlgorithm {
    private static final int MAX_COMPRESSION_TEXT_LENGTH = 17408;
    private static final int MAX_PLAIN_TEXT_LENGTH = 16384;
    private Boolean secondPacketFlagCompression = false;
    private Boolean secondPacketFlagDecompression = false;

    public DeflateCompression() {
        super(CompressionMethod.DEFLATE);
    }

    @Override
    public byte[] compress(byte[] data) {
        byte[] veryRealOutput;
        byte[] input = data;
        byte[] output = new byte[17408];
        Deflater compressor = new Deflater();
        compressor.setInput(input, 0, input.length);
        int compressedDataLength = compressor.deflate(output, 0, 17408, 2);
        byte[] realOutput = new byte[compressedDataLength];
        System.arraycopy(output, 0, realOutput, 0, compressedDataLength);
        if (this.secondPacketFlagCompression.booleanValue()) {
            veryRealOutput = Arrays.copyOfRange(realOutput, 2, realOutput.length);
        } else {
            veryRealOutput = Arrays.copyOfRange(realOutput, 0, realOutput.length);
            this.secondPacketFlagCompression = true;
        }
        return veryRealOutput;
    }

    @Override
    public byte[] decompress(byte[] data) {
        byte[] veryRealInput;
        byte[] input = data;
        byte[] output = new byte[16384];
        if (this.secondPacketFlagDecompression.booleanValue()) {
            veryRealInput = new byte[input.length + 2];
            veryRealInput[0] = 120;
            veryRealInput[1] = -100;
            System.arraycopy(input, 0, veryRealInput, 2, input.length);
        } else {
            veryRealInput = new byte[input.length];
            System.arraycopy(input, 0, veryRealInput, 0, input.length);
            this.secondPacketFlagDecompression = true;
        }
        Inflater decompressor = new Inflater();
        decompressor.setInput(veryRealInput, 0, veryRealInput.length);
        int decompressedDataLength = 0;
        try {
            decompressedDataLength = decompressor.inflate(output, 0, 16384);
        }
        catch (Exception e) {
            LOGGER.debug("Couldn't decompress the data");
            LOGGER.trace((Object)e);
        }
        byte[] realOutput = new byte[decompressedDataLength];
        System.arraycopy(output, 0, realOutput, 0, decompressedDataLength);
        return realOutput;
    }
}

