/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.cert;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.cert.CertificatePair;
import de.rub.nds.tlsattacker.core.protocol.serializer.Serializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificatePairSerializer
extends Serializer<CertificatePair> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CertificatePair pair;
    private final ProtocolVersion version;

    public CertificatePairSerializer(CertificatePair pair, ProtocolVersion version) {
        this.pair = pair;
        this.version = version;
    }

    @Override
    protected byte[] serializeBytes() {
        LOGGER.debug("Serializing CertificatePair");
        this.writeCertificateLength(this.pair);
        this.writeCertificate(this.pair);
        if (this.version.isTLS13()) {
            this.writeExtensionsLength(this.pair);
            if (this.pair.getExtensions() != null && this.pair.getExtensions().getValue() != null) {
                this.writeExtensions(this.pair);
            }
        }
        return this.getAlreadySerialized();
    }

    private void writeCertificateLength(CertificatePair pair) {
        this.appendInt((Integer)pair.getCertificateLength().getValue(), 3);
        LOGGER.debug("CertificateLength: " + pair.getCertificateLength().getValue());
    }

    private void writeCertificate(CertificatePair pair) {
        this.appendBytes((byte[])pair.getCertificate().getValue());
        LOGGER.debug("Certificate: " + ArrayConverter.bytesToHexString((byte[])((byte[])pair.getCertificate().getValue())));
    }

    private void writeExtensionsLength(CertificatePair pair) {
        this.appendInt((Integer)pair.getExtensionsLength().getValue(), 2);
        LOGGER.debug("ExtensionsLength: " + pair.getExtensionsLength().getValue());
    }

    private void writeExtensions(CertificatePair pair) {
        this.appendBytes((byte[])pair.getExtensions().getValue());
        LOGGER.debug("Extensions: " + ArrayConverter.bytesToHexString((byte[])((byte[])pair.getExtensions().getValue())));
    }
}

