/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.PublicKeyType;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.EmptyClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.BigIntegers;

public class EmptyClientKeyExchangePreparator<T extends EmptyClientKeyExchangeMessage>
extends ClientKeyExchangePreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected byte[] random;
    protected final T msg;
    protected byte[] premasterSecret;

    public EmptyClientKeyExchangePreparator(Chooser chooser, T msg) {
        super(chooser, (ClientKeyExchangeMessage)msg);
        this.msg = msg;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing EmptyClientKeyExchangeMessage");
        this.prepareAfterParse(true);
    }

    protected void prepareClientServerRandom(T msg) {
        this.random = ArrayConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()});
        ((EmptyClientKeyExchangeMessage)msg).getComputations().setClientServerRandom(this.random);
        this.random = (byte[])((EmptyClientKeyExchangeMessage)msg).getComputations().getClientServerRandom().getValue();
        LOGGER.debug("ClientServerRandom: " + ArrayConverter.bytesToHexString((byte[])((byte[])((EmptyClientKeyExchangeMessage)msg).getComputations().getClientServerRandom().getValue())));
    }

    protected byte[] calculatePremasterSecret(BigInteger modulus, BigInteger privateKey, BigInteger publicKey) {
        if (modulus.compareTo(BigInteger.ZERO) == 0) {
            LOGGER.warn("Modulus is ZERO. Returning empty premaster Secret");
            return new byte[0];
        }
        return BigIntegers.asUnsignedByteArray((BigInteger)publicKey.modPow(privateKey.abs(), modulus.abs()));
    }

    protected void preparePremasterSecret(T msg) {
        ((EmptyClientKeyExchangeMessage)msg).getComputations().setPremasterSecret(this.premasterSecret);
        this.premasterSecret = (byte[])((EmptyClientKeyExchangeMessage)msg).getComputations().getPremasterSecret().getValue();
        LOGGER.debug("PremasterSecret: " + ArrayConverter.bytesToHexString((byte[])((byte[])((EmptyClientKeyExchangeMessage)msg).getComputations().getPremasterSecret().getValue())));
    }

    protected byte[] computeECPremasterSecret(EllipticCurve curve, Point publicKey, BigInteger privateKey) {
        Point sharedPoint = curve.mult(privateKey, publicKey);
        int elementLenght = ArrayConverter.bigIntegerToByteArray((BigInteger)sharedPoint.getX().getModulus()).length;
        return ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)sharedPoint.getX().getData(), (int)elementLenght);
    }

    @Override
    public void prepareAfterParse(boolean clientMode) {
        ((EmptyClientKeyExchangeMessage)this.msg).prepareComputations();
        this.prepareClientServerRandom(this.msg);
        if (this.chooser.getContext().getClientCertificate() != null && !this.chooser.getContext().getClientCertificate().isEmpty()) {
            String algorithm = this.chooser.getContext().getClientCertificate().getCertificateAt(0).getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().toString();
            if (PublicKeyType.fromOid(algorithm) == PublicKeyType.DH) {
                this.premasterSecret = this.calculatePremasterSecret(this.chooser.getClientDhModulus(), this.chooser.getDhClientPrivateKey(), this.chooser.getDhClientPublicKey());
            } else if (PublicKeyType.fromOid(algorithm) == PublicKeyType.ECDSA) {
                if (clientMode) {
                    NamedGroup usedGroup = this.chooser.getSelectedNamedGroup();
                    LOGGER.debug("PMS used Group: " + usedGroup.name());
                    EllipticCurve curve = CurveFactory.getCurve(usedGroup);
                    Point publicKey = this.chooser.getServerEcPublicKey();
                    this.premasterSecret = this.computeECPremasterSecret(curve, publicKey, this.chooser.getClientEcPrivateKey());
                } else {
                    LOGGER.debug("Not Implemented.");
                }
            }
            this.preparePremasterSecret(this.msg);
        }
    }
}

