/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtendedRandomExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtendedRandomExtensionParser
extends ExtensionParser<ExtendedRandomExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ExtendedRandomExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(ExtendedRandomExtensionMessage msg) {
        this.parseExtendedRandomLength(msg);
        msg.setExtendedRandom(this.parseByteArrayField((Integer)msg.getExtendedRandomLength().getValue()));
        LOGGER.debug("The extended Random TLS parser parsed the value " + ArrayConverter.bytesToHexString((ModifiableByteArray)msg.getExtendedRandom()));
    }

    private void parseExtendedRandomLength(ExtendedRandomExtensionMessage msg) {
        msg.setExtendedRandomLength(this.parseIntField(2));
        LOGGER.debug("ExtendedRandomLength : " + msg.getExtendedRandomLength().getValue());
    }

    @Override
    protected ExtendedRandomExtensionMessage createExtensionMessage() {
        return new ExtendedRandomExtensionMessage();
    }
}

