/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.HelloVerifyRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelloVerifyRequestParser
extends HandshakeMessageParser<HelloVerifyRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public HelloVerifyRequestParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array, HandshakeMessageType.HELLO_VERIFY_REQUEST, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(HelloVerifyRequestMessage msg) {
        LOGGER.debug("Parsing HelloVerifyRequestMessage");
        this.parseProtocolVersion(msg);
        this.parseCookieLength(msg);
        this.parseCookie(msg);
    }

    @Override
    protected HelloVerifyRequestMessage createHandshakeMessage() {
        return new HelloVerifyRequestMessage();
    }

    private void parseProtocolVersion(HelloVerifyRequestMessage msg) {
        msg.setProtocolVersion(this.parseByteArrayField(2));
        LOGGER.debug("ProtcolVersion: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getProtocolVersion().getValue())));
    }

    private void parseCookieLength(HelloVerifyRequestMessage msg) {
        msg.setCookieLength(this.parseByteField(1));
        LOGGER.debug("CookieLength: " + msg.getCookieLength().getValue());
    }

    private void parseCookie(HelloVerifyRequestMessage msg) {
        msg.setCookie(this.parseByteArrayField(((Byte)msg.getCookieLength().getValue()).byteValue()));
        LOGGER.debug("Cookie: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCookie().getValue())));
    }
}

