/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.EllipticCurveType;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.protocol.handler.PWDServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.PWDComputations;
import de.rub.nds.tlsattacker.core.state.TlsContext;

public class PWDServerKeyExchangeMessage
extends ServerKeyExchangeMessage {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger saltLength;
    @ModifiableVariableProperty
    private ModifiableByteArray salt;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    protected ModifiableByte curveType;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    protected ModifiableByteArray namedGroup;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger elementLength;
    @ModifiableVariableProperty
    private ModifiableByteArray element;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger scalarLength;
    @ModifiableVariableProperty
    private ModifiableByteArray scalar;
    protected PWDComputations computations;

    public PWDServerKeyExchangeMessage() {
    }

    public PWDServerKeyExchangeMessage(Config tlsConfig) {
        super(tlsConfig, HandshakeMessageType.SERVER_KEY_EXCHANGE);
    }

    @Override
    public PWDComputations getComputations() {
        return this.computations;
    }

    @Override
    public void prepareComputations() {
        if (this.getComputations() == null) {
            this.computations = new PWDComputations();
        }
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new PWDServerKeyExchangeHandler(context);
    }

    public ModifiableInteger getSaltLength() {
        return this.saltLength;
    }

    public void setSaltLength(ModifiableInteger saltLength) {
        this.saltLength = saltLength;
    }

    public void setSaltLength(int saltLength) {
        this.saltLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.saltLength, (Integer)saltLength);
    }

    public ModifiableByteArray getSalt() {
        return this.salt;
    }

    public void setSalt(ModifiableByteArray salt) {
        this.salt = salt;
    }

    public void setSalt(byte[] salt) {
        this.salt = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.salt, (byte[])salt);
    }

    public void setCurveType(ModifiableByte curveType) {
        this.curveType = curveType;
    }

    public void setCurveType(byte curveType) {
        this.curveType = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.curveType, (Byte)curveType);
    }

    public ModifiableByte getGroupType() {
        return this.curveType;
    }

    public ModifiableByteArray getNamedGroup() {
        return this.namedGroup;
    }

    public void setNamedGroup(ModifiableByteArray namedGroup) {
        this.namedGroup = namedGroup;
    }

    public void setNamedGroup(byte[] namedGroup) {
        this.namedGroup = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.namedGroup, (byte[])namedGroup);
    }

    public ModifiableInteger getElementLength() {
        return this.elementLength;
    }

    public void setElementLength(ModifiableInteger elementLength) {
        this.elementLength = elementLength;
    }

    public void setElementLength(int elementLength) {
        this.elementLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.elementLength, (Integer)elementLength);
    }

    public ModifiableByteArray getElement() {
        return this.element;
    }

    public void setElement(ModifiableByteArray element) {
        this.element = element;
    }

    public void setElement(byte[] element) {
        this.element = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.element, (byte[])element);
    }

    public ModifiableInteger getScalarLength() {
        return this.scalarLength;
    }

    public void setScalarLength(ModifiableInteger scalarLength) {
        this.scalarLength = scalarLength;
    }

    public void setScalarLength(int scalarLength) {
        this.scalarLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.scalarLength, (Integer)scalarLength);
    }

    public ModifiableByteArray getScalar() {
        return this.scalar;
    }

    public void setScalar(ModifiableByteArray scalar) {
        this.scalar = scalar;
    }

    public void setScalar(byte[] scalar) {
        this.scalar = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.scalar, (byte[])scalar);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PWDServerKeyExchangeMessage:");
        sb.append("\n  Salt: ");
        if (this.getSalt() != null && this.getSalt().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getSalt().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Curve Type: ");
        if (this.curveType != null && this.curveType.getValue() != null) {
            sb.append((Object)EllipticCurveType.getCurveType((Byte)this.curveType.getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Named Curve: ");
        if (this.namedGroup != null && this.namedGroup.getValue() != null) {
            sb.append((Object)NamedGroup.getNamedGroup((byte[])this.namedGroup.getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Element: ");
        if (this.getElement() != null && this.getElement().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getElement().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Scalar: ");
        if (this.getScalar() != null && this.getScalar().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getScalar().getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        return "PWD_SERVER_KEY_EXCHANGE";
    }
}

