/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.dtls;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.dtls.FragmentCollector;
import de.rub.nds.tlsattacker.core.dtls.FragmentKey;
import de.rub.nds.tlsattacker.core.protocol.message.DtlsHandshakeMessageFragment;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FragmentManager {
    private static final Logger LOGGER = LogManager.getLogger(FragmentManager.class);
    private Map<FragmentKey, FragmentCollector> fragments = new HashMap<FragmentKey, FragmentCollector>();
    private Config config;

    public FragmentManager(Config config) {
        this.config = config;
    }

    public boolean addMessageFragment(DtlsHandshakeMessageFragment fragment) {
        FragmentKey key = new FragmentKey((Integer)fragment.getMessageSeq().getValue(), (Integer)fragment.getEpoch().getValue());
        FragmentCollector collector = this.fragments.get(key);
        if (collector == null) {
            collector = new FragmentCollector(this.config, (Byte)fragment.getType().getValue(), (Integer)fragment.getMessageSeq().getValue(), (Integer)fragment.getLength().getValue());
            this.fragments.put(key, collector);
        }
        if (collector.wouldAdd(fragment)) {
            collector.addFragment(fragment);
            return true;
        }
        return false;
    }

    public boolean isFragmentedMessageComplete(Integer messageSeq, Integer epoch) {
        FragmentKey key = new FragmentKey(messageSeq, epoch);
        FragmentCollector collector = this.fragments.get(key);
        if (collector == null) {
            return false;
        }
        return collector.isMessageComplete();
    }

    public List<DtlsHandshakeMessageFragment> getOrderedCombinedUninterpretedMessageFragments(boolean onlyIfComplete) {
        LinkedList<DtlsHandshakeMessageFragment> handshakeFragmentList = new LinkedList<DtlsHandshakeMessageFragment>();
        ArrayList<FragmentKey> orderedFragmentKeys = new ArrayList<FragmentKey>(this.fragments.keySet());
        orderedFragmentKeys.sort(new Comparator<FragmentKey>(){

            @Override
            public int compare(FragmentKey fragmentKey1, FragmentKey fragmentKey2) {
                if (fragmentKey1.getEpoch() > fragmentKey2.getEpoch()) {
                    return -1;
                }
                if (fragmentKey1.getEpoch() < fragmentKey2.getEpoch()) {
                    return 1;
                }
                return fragmentKey1.getMessageSeq().compareTo(fragmentKey2.getMessageSeq());
            }
        });
        for (FragmentKey key : orderedFragmentKeys) {
            FragmentCollector fragmentCollector = this.fragments.get(key);
            if (fragmentCollector.isInterpreted()) continue;
            if (fragmentCollector == null) {
                LOGGER.error("Trying to access unreceived message fragment");
                continue;
            }
            if (onlyIfComplete && !fragmentCollector.isMessageComplete()) {
                LOGGER.debug("Incomplete message. Not processing: msg_sqn: " + key.getMessageSeq() + " epoch: " + key.getEpoch());
                continue;
            }
            handshakeFragmentList.add(fragmentCollector.buildCombinedFragment());
            fragmentCollector.setInterpreted(true);
        }
        return handshakeFragmentList;
    }

    public boolean areAllMessageFragmentsComplete() {
        for (FragmentCollector collector : this.fragments.values()) {
            if (collector.isMessageComplete()) continue;
            return false;
        }
        return true;
    }

    public DtlsHandshakeMessageFragment getCombinedMessageFragment(Integer messageSeq, Integer epoch) {
        FragmentKey key = new FragmentKey(messageSeq, epoch);
        FragmentCollector collector = this.fragments.get(key);
        if (collector == null) {
            LOGGER.warn("Trying to access not received handshake fragment.");
            return null;
        }
        if (!collector.isMessageComplete()) {
            LOGGER.warn("Did not receive all fragments for msq_sqn:" + messageSeq + " epoch: " + epoch);
            return null;
        }
        return collector.buildCombinedFragment();
    }

    public void clearFragmentedMessage(Integer messageSeq, Integer epoch) {
        FragmentKey key = new FragmentKey(messageSeq, epoch);
        this.fragments.remove(key);
    }
}

