/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.keys;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.GOSTCurve;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomPublicKey;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class CustomEcPublicKey
extends CustomPublicKey
implements ECPublicKey {
    private static final Logger LOGGER = LogManager.getLogger();
    private Point point;
    private NamedGroup group;
    private GOSTCurve gostCurve;

    private CustomEcPublicKey() {
        this.point = null;
        this.group = null;
        this.gostCurve = null;
    }

    private CustomEcPublicKey(Point point, NamedGroup group) {
        this.point = point;
        this.group = group;
        this.gostCurve = null;
    }

    public CustomEcPublicKey(BigInteger x, BigInteger y, NamedGroup group) {
        this.group = group;
        this.gostCurve = null;
        this.point = CurveFactory.getCurve(group).getPoint(x, y);
    }

    public CustomEcPublicKey(BigInteger x, BigInteger y, GOSTCurve gostCurve) {
        this.group = null;
        this.gostCurve = gostCurve;
        this.point = CurveFactory.getCurve(gostCurve).getPoint(x, y);
    }

    public Point getPoint() {
        return this.point;
    }

    public NamedGroup getGroup() {
        return this.group;
    }

    public GOSTCurve getGostCurve() {
        return this.gostCurve;
    }

    @Override
    public void adjustInContext(TlsContext context, ConnectionEndType ownerOfKey) {
        LOGGER.debug("Adjusting EC public key in context");
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                context.setClientEcPublicKey(this.point);
                if (this.group == null) break;
                context.setEcCertificateCurve(this.group);
                break;
            }
            case SERVER: {
                context.setServerEcPublicKey(this.point);
                if (this.group == null) break;
                context.setEcCertificateCurve(this.group);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    @Override
    public ECPoint getW() {
        return new ECPoint(this.point.getX().getData(), this.point.getY().getData());
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public String getFormat() {
        return "None";
    }

    @Override
    public byte[] getEncoded() {
        try {
            ECParameterSpec ecParameters = this.getParams();
            ECPublicKeySpec pubKey = new ECPublicKeySpec(this.getW(), ecParameters);
            PublicKey publicKey = KeyFactory.getInstance("EC").generatePublic(pubKey);
            return publicKey.getEncoded();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new UnsupportedOperationException("Could not encode the private EC key", ex);
        }
    }

    @Override
    public ECParameterSpec getParams() {
        try {
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
            parameters.init(new ECGenParameterSpec(this.group.getJavaName()));
            ECParameterSpec ecParameters = parameters.getParameterSpec(ECParameterSpec.class);
            return ecParameters;
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException ex) {
            throw new UnsupportedOperationException("Could not generate ECParameterSpec", ex);
        }
    }

    @Override
    public void adjustInConfig(Config config, ConnectionEndType ownerOfKey) {
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                config.setDefaultClientEcPublicKey(this.point);
                if (this.group == null) break;
                config.setDefaultEcCertificateCurve(this.group);
                break;
            }
            case SERVER: {
                config.setDefaultServerEcPublicKey(this.point);
                if (this.group == null) break;
                config.setDefaultEcCertificateCurve(this.group);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.point);
        hash = 79 * hash + Objects.hashCode((Object)this.group);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomEcPublicKey other = (CustomEcPublicKey)obj;
        if (!Objects.equals(this.point, other.point)) {
            return false;
        }
        return this.group == other.group;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public void setGroup(NamedGroup group) {
        this.group = group;
    }

    public void setGostCurve(GOSTCurve gostCurve) {
        this.gostCurve = gostCurve;
    }

    @Override
    public int keysize() {
        if (this.group == null || this.group.getCoordinateSizeInBit() == null) {
            return 0;
        }
        return this.group.getCoordinateSizeInBit();
    }
}

