/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.keys;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomPublicKey;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class CustomDsaPublicKey
extends CustomPublicKey
implements DSAPublicKey {
    private static final Logger LOGGER = LogManager.getLogger();
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;
    private BigInteger publicKey;

    public CustomDsaPublicKey(BigInteger p, BigInteger q, BigInteger g, BigInteger publicKey) {
        this.p = p;
        this.q = q;
        this.g = g;
        this.publicKey = publicKey;
    }

    private CustomDsaPublicKey() {
        this.p = null;
        this.q = null;
        this.g = null;
        this.publicKey = null;
    }

    @Override
    public void adjustInContext(TlsContext context, ConnectionEndType ownerOfKey) {
        LOGGER.debug("Adjusting DSA public key in context");
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                context.setClientDsaGenerator(this.g);
                context.setClientDsaPrimeP(this.p);
                context.setClientDsaPrimeQ(this.q);
                context.setClientDsaPublicKey(this.publicKey);
                break;
            }
            case SERVER: {
                context.setServerDsaGenerator(this.g);
                context.setServerDsaPrimeP(this.p);
                context.setServerDsaPrimeQ(this.q);
                context.setServerDsaPublicKey(this.publicKey);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getG() {
        return this.g;
    }

    @Override
    public BigInteger getY() {
        return this.publicKey;
    }

    @Override
    public DSAParams getParams() {
        return new DSAParameterSpec(this.p, this.q, this.g);
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @Override
    public String getFormat() {
        return "None";
    }

    @Override
    public byte[] getEncoded() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void adjustInConfig(Config config, ConnectionEndType ownerOfKey) {
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                config.setDefaultClientDsaGenerator(this.g);
                config.setDefaultClientDsaPrimeP(this.p);
                config.setDefaultClientDsaPrimeQ(this.q);
                config.setDefaultClientDsaPublicKey(this.publicKey);
                break;
            }
            case SERVER: {
                config.setDefaultServerDsaGenerator(this.g);
                config.setDefaultServerDsaPrimeP(this.p);
                config.setDefaultServerDsaPrimeQ(this.q);
                config.setDefaultServerDsaPublicKey(this.publicKey);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Objects.hashCode(this.p);
        hash = 59 * hash + Objects.hashCode(this.q);
        hash = 59 * hash + Objects.hashCode(this.g);
        hash = 59 * hash + Objects.hashCode(this.publicKey);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomDsaPublicKey other = (CustomDsaPublicKey)obj;
        if (!Objects.equals(this.p, other.p)) {
            return false;
        }
        if (!Objects.equals(this.q, other.q)) {
            return false;
        }
        if (!Objects.equals(this.g, other.g)) {
            return false;
        }
        return Objects.equals(this.publicKey, other.publicKey);
    }

    public void setP(BigInteger p) {
        this.p = p;
    }

    public void setQ(BigInteger q) {
        this.q = q;
    }

    public void setG(BigInteger g) {
        this.g = g;
    }

    public void setPublicKey(BigInteger publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public int keysize() {
        return this.p.bitLength();
    }
}

