/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.cipher;

import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.crypto.cipher.ChaCha20Poly1305Cipher;
import de.rub.nds.tlsattacker.core.crypto.cipher.DecryptionCipher;
import de.rub.nds.tlsattacker.core.crypto.cipher.EncryptionCipher;
import de.rub.nds.tlsattacker.core.crypto.cipher.GOST28147Cipher;
import de.rub.nds.tlsattacker.core.crypto.cipher.JavaCipher;
import de.rub.nds.tlsattacker.core.crypto.cipher.NullCipher;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.core.util.GOSTUtils;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CipherWrapper {
    private static final Logger LOGGER = LogManager.getLogger();

    public static EncryptionCipher getEncryptionCipher(CipherSuite cipherSuite, ConnectionEndType connectionEndType, KeySet keySet) {
        CipherAlgorithm cipherAlg = AlgorithmResolver.getCipher(cipherSuite);
        if (cipherAlg == CipherAlgorithm.GOST_28147_CNT) {
            return new GOST28147Cipher(GOSTUtils.getGostSpec(cipherSuite), keySet.getWriteKey(connectionEndType), keySet.getWriteIv(connectionEndType));
        }
        if (cipherAlg == CipherAlgorithm.ChaCha20Poly1305) {
            return new ChaCha20Poly1305Cipher(keySet.getWriteKey(connectionEndType));
        }
        if (cipherAlg.getJavaName() != null) {
            return new JavaCipher(cipherAlg, keySet.getWriteKey(connectionEndType));
        }
        if (cipherAlg == CipherAlgorithm.NULL) {
            return new NullCipher();
        }
        LOGGER.warn("Cipher:" + (Object)((Object)cipherAlg) + " is not supported - Using NullCipher!");
        return new NullCipher();
    }

    public static DecryptionCipher getDecryptionCipher(CipherSuite cipherSuite, ConnectionEndType connectionEndType, KeySet keySet) {
        CipherAlgorithm cipherAlg = AlgorithmResolver.getCipher(cipherSuite);
        if (cipherAlg == CipherAlgorithm.GOST_28147_CNT) {
            return new GOST28147Cipher(GOSTUtils.getGostSpec(cipherSuite), keySet.getReadKey(connectionEndType), keySet.getReadIv(connectionEndType));
        }
        if (cipherAlg == CipherAlgorithm.ChaCha20Poly1305) {
            return new ChaCha20Poly1305Cipher(keySet.getReadKey(connectionEndType));
        }
        if (cipherAlg.getJavaName() != null) {
            return new JavaCipher(cipherAlg, keySet.getReadKey(connectionEndType));
        }
        if (cipherAlg == CipherAlgorithm.NULL) {
            return new NullCipher();
        }
        LOGGER.warn("Cipher:" + (Object)((Object)cipherAlg) + " is not supported - Using NullCipher!");
        return new NullCipher();
    }

    private CipherWrapper() {
    }
}

