/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.utils;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.openide.util.Lookup;

public class FileChangedManager
extends SecurityManager {
    private static FileChangedManager INSTANCE;
    private static final int CREATE_HINT = 2;
    private static final int DELETE_HINT = 1;
    private static final int AMBIGOUS_HINT = 3;
    private final ConcurrentHashMap<Integer, Integer> hints = new ConcurrentHashMap();
    private long shrinkTime = System.currentTimeMillis();

    public FileChangedManager() {
        INSTANCE = this;
    }

    public static FileChangedManager getInstance() {
        if (INSTANCE == null) {
            Lookup.getDefault().lookup(SecurityManager.class);
            assert (INSTANCE != null);
        }
        return INSTANCE;
    }

    public void checkDelete(String string) {
        this.put(string, false);
    }

    public void checkWrite(String string) {
        this.put(string, true);
    }

    public boolean impeachExistence(File file, boolean bl) {
        boolean bl2;
        Integer n = this.remove(FileChangedManager.getKey(file));
        boolean bl3 = bl2 = n != null;
        if (bl2) {
            if (n == 3) {
                return true;
            }
            bl2 = bl != this.toState(n);
        }
        return bl2;
    }

    public boolean exists(File file) {
        boolean bl = file.exists();
        this.remove(FileChangedManager.getKey(file));
        this.put(file, bl);
        return bl;
    }

    private Integer put(int n, boolean bl) {
        this.shrinkTime = System.currentTimeMillis();
        int n2 = this.toValue(bl);
        Integer n3 = this.hints.putIfAbsent(n, n2);
        if (n3 != null && n3 != 3 && n3 != n2) {
            this.hints.put(n, 3);
        }
        return n3;
    }

    private int toValue(boolean bl) {
        return bl ? 2 : 1;
    }

    private boolean toState(int n) {
        switch (n) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    private Integer get(int n) {
        long l = System.currentTimeMillis();
        if (l - this.shrinkTime > 5000L) {
            int n2 = this.hints.size();
            if (n2 > 1500) {
                this.shrink();
            }
            this.shrinkTime = l;
        }
        return this.hints.get(n);
    }

    private void shrink() {
        this.hints.keySet().clear();
    }

    private Integer remove(int n) {
        return this.hints.remove(n);
    }

    private static int getKey(File file) {
        return NamingFactory.createID(file);
    }

    private static int getKey(String string) {
        return FileChangedManager.getKey(new File(string));
    }

    private Integer put(String string, boolean bl) {
        return this.put(FileChangedManager.getKey(string), bl);
    }

    private Integer put(File file, boolean bl) {
        return this.put(FileChangedManager.getKey(file), bl);
    }

    private Integer get(String string) {
        return this.get(FileChangedManager.getKey(string));
    }

    private Integer get(File file) {
        return this.get(FileChangedManager.getKey(file));
    }
}

