/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.router;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OrthogonalSearchRouterRegion
extends Rectangle {
    public static final int MIN_INT_REGION = -20000;
    public static final int MAX_INT_REGION = 20000;
    private Anchor.Direction direction;
    private boolean horizontal;
    private int depth;

    public OrthogonalSearchRouterRegion(int n, int n2, int n3, int n4, Anchor.Direction direction, int n5) {
        super(n, n2, n3, n4);
        this.direction = direction;
        switch (direction) {
            case LEFT: 
            case RIGHT: {
                this.horizontal = true;
                break;
            }
            case TOP: 
            case BOTTOM: {
                this.horizontal = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.depth = n5;
    }

    public Anchor.Direction getDirection() {
        return this.direction;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public int getDepth() {
        return this.depth;
    }

    public void extendToInfinity() {
        switch (this.direction) {
            case LEFT: {
                this.width = this.x - -20000;
                this.x = -20000;
                break;
            }
            case RIGHT: {
                this.width = 20000 - this.x;
                break;
            }
            case TOP: {
                this.height = this.y - -20000;
                this.y = -20000;
                break;
            }
            case BOTTOM: {
                this.height = 20000 - this.y;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int compareImportant(Rectangle rectangle, Rectangle rectangle2) {
        if (!this.intersectsZero(rectangle)) {
            return Integer.MAX_VALUE;
        }
        if (rectangle2 == null) {
            return Integer.MIN_VALUE;
        }
        switch (this.direction) {
            case LEFT: {
                return rectangle2.x + rectangle2.width - (rectangle.x + rectangle.width);
            }
            case RIGHT: {
                return rectangle.x - rectangle2.x;
            }
            case TOP: {
                return rectangle2.y + rectangle2.height - (rectangle.y + rectangle.height);
            }
            case BOTTOM: {
                return rectangle.y - rectangle2.y;
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean intersectsZero(Rectangle rectangle) {
        int n = this.x;
        int n2 = this.y;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = this.width + n;
        int n6 = this.height + n2;
        int n7 = rectangle.width + n3;
        int n8 = rectangle.height + n4;
        return n7 > n && n8 > n2 && n5 > n3 && n6 > n4;
    }

    private void parseIntervalsBy(ArrayList<OrthogonalSearchRouterRegion> arrayList, Rectangle rectangle) {
        int n;
        int n2;
        if (this.horizontal) {
            n2 = rectangle.y;
            n = rectangle.y + rectangle.height;
        } else {
            n2 = rectangle.x;
            n = rectangle.x + rectangle.width;
        }
        int n3 = 0;
        while (n3 < arrayList.size()) {
            int n4;
            int n5;
            int n6;
            OrthogonalSearchRouterRegion orthogonalSearchRouterRegion = arrayList.get(n3);
            if (this.horizontal) {
                n6 = orthogonalSearchRouterRegion.y;
                n5 = orthogonalSearchRouterRegion.y + orthogonalSearchRouterRegion.height;
            } else {
                n6 = orthogonalSearchRouterRegion.x;
                n5 = orthogonalSearchRouterRegion.x + orthogonalSearchRouterRegion.width;
            }
            if (n <= n6 || n2 >= n5) {
                ++n3;
                continue;
            }
            if (n2 <= n6 && n >= n5) {
                arrayList.remove(n3);
                continue;
            }
            if (n2 > n6 && n < n5) {
                OrthogonalSearchRouterRegion orthogonalSearchRouterRegion2 = orthogonalSearchRouterRegion.cloneExactly();
                int n7 = n2 - n6;
                int n8 = n5 - n;
                if (this.horizontal) {
                    orthogonalSearchRouterRegion.height = n7;
                    orthogonalSearchRouterRegion2.y = n5 - n8;
                    orthogonalSearchRouterRegion2.height = n8;
                    arrayList.add(n3 + 1, orthogonalSearchRouterRegion2);
                } else {
                    orthogonalSearchRouterRegion.width = n7;
                    orthogonalSearchRouterRegion2.x = n5 - n8;
                    orthogonalSearchRouterRegion2.width = n8;
                    arrayList.add(n3 + 1, orthogonalSearchRouterRegion2);
                }
                return;
            }
            if (n2 <= n6 && n > n6 && n < n5) {
                n4 = n - n6;
                if (this.horizontal) {
                    orthogonalSearchRouterRegion.y += n4;
                    orthogonalSearchRouterRegion.height -= n4;
                } else {
                    orthogonalSearchRouterRegion.x += n4;
                    orthogonalSearchRouterRegion.width -= n4;
                }
                ++n3;
                continue;
            }
            if (n >= n5 && n2 > n6 && n2 < n5) {
                n4 = n5 - n2;
                if (this.horizontal) {
                    orthogonalSearchRouterRegion.height -= n4;
                } else {
                    orthogonalSearchRouterRegion.width -= n4;
                }
                ++n3;
                continue;
            }
            throw new IllegalStateException();
        }
    }

    public OrthogonalSearchRouterRegion cloneExactly() {
        return new OrthogonalSearchRouterRegion(this.x, this.y, this.width, this.height, this.direction, this.depth);
    }

    public ArrayList<OrthogonalSearchRouterRegion> parseSubRegions(List<Rectangle> list) {
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        Rectangle rectangle = null;
        for (Rectangle object : list) {
            int rectangle2 = this.compareImportant(object, rectangle);
            if (rectangle2 > 0) continue;
            if (rectangle2 < 0) {
                arrayList.clear();
                rectangle = object;
            }
            arrayList.add(object);
        }
        ArrayList arrayList2 = new ArrayList();
        if (arrayList.size() > 0) {
            this.cutLengthBy(rectangle);
            arrayList2.add(this.cloneWithForwardEdge());
            for (Rectangle rectangle2 : arrayList) {
                this.parseIntervalsBy(arrayList2, rectangle2);
            }
        }
        return arrayList2;
    }

    public OrthogonalSearchRouterRegion cloneWithForwardEdge() {
        return this.cloneWithEdge(this.direction, this.depth);
    }

    public OrthogonalSearchRouterRegion cloneWithCounterClockwiseEdge() {
        return this.cloneWithEdge(OrthogonalSearchRouterRegion.getCounterClockWiseDirection(this.direction), this.depth + 1);
    }

    public OrthogonalSearchRouterRegion cloneWithClockwiseEdge() {
        return this.cloneWithEdge(OrthogonalSearchRouterRegion.getClockWiseDirection(this.direction), this.depth + 1);
    }

    private OrthogonalSearchRouterRegion cloneWithEdge(Anchor.Direction direction, int n) {
        switch (direction) {
            case LEFT: {
                return new OrthogonalSearchRouterRegion(this.x, this.y, 0, this.height, direction, n);
            }
            case RIGHT: {
                return new OrthogonalSearchRouterRegion(this.x + this.width, this.y, 0, this.height, direction, n);
            }
            case TOP: {
                return new OrthogonalSearchRouterRegion(this.x, this.y, this.width, 0, direction, n);
            }
            case BOTTOM: {
                return new OrthogonalSearchRouterRegion(this.x, this.y + this.height, this.width, 0, direction, n);
            }
        }
        throw new IllegalArgumentException();
    }

    private void cutLengthBy(Rectangle rectangle) {
        switch (this.direction) {
            case LEFT: {
                int n = rectangle.x + rectangle.width;
                int n2 = this.x;
                if (n > this.x + this.width) {
                    this.x += this.width;
                    this.width = 0;
                    break;
                }
                if (n <= n2) break;
                this.width = this.x + this.width - n;
                this.x = n;
                break;
            }
            case RIGHT: {
                int n = rectangle.x;
                int n3 = this.x + this.width;
                if (n < this.x) {
                    this.width = 0;
                    break;
                }
                if (n >= n3) break;
                this.width = n - this.x;
                break;
            }
            case TOP: {
                int n = rectangle.y + rectangle.height;
                int n4 = this.y;
                if (n > this.y + this.height) {
                    this.y += this.height;
                    this.height = 0;
                    break;
                }
                if (n <= n4) break;
                this.height = this.y + this.height - n;
                this.y = n;
                break;
            }
            case BOTTOM: {
                int n = rectangle.y;
                int n5 = this.y + this.height;
                if (n < this.y) {
                    this.height = 0;
                    break;
                }
                if (n >= n5) break;
                this.height = n - this.y;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getLength() {
        return this.horizontal ? this.width : this.height;
    }

    public int getDistance(Point point) {
        return this.horizontal ? Math.abs(point.y - this.y) : Math.abs(point.x - this.x);
    }

    public boolean containsInsideEdges(Point point) {
        return point.x >= this.x && point.x <= this.x + this.width && point.y >= this.y && point.y <= this.y + this.height;
    }

    @Override
    public String toString() {
        return "pos: " + this.x + "," + this.y + " size: " + this.width + "," + this.height + " dir: " + (Object)((Object)this.direction) + " depth: " + this.depth;
    }

    public static Anchor.Direction getCounterClockWiseDirection(Anchor.Direction direction) {
        switch (direction) {
            case LEFT: {
                return Anchor.Direction.BOTTOM;
            }
            case RIGHT: {
                return Anchor.Direction.TOP;
            }
            case TOP: {
                return Anchor.Direction.LEFT;
            }
            case BOTTOM: {
                return Anchor.Direction.RIGHT;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Anchor.Direction getClockWiseDirection(Anchor.Direction direction) {
        switch (direction) {
            case LEFT: {
                return Anchor.Direction.TOP;
            }
            case RIGHT: {
                return Anchor.Direction.BOTTOM;
            }
            case TOP: {
                return Anchor.Direction.RIGHT;
            }
            case BOTTOM: {
                return Anchor.Direction.LEFT;
            }
        }
        throw new IllegalArgumentException();
    }
}

