/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.pkg;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.pkg.PackageAPI;
import org.apache.solr.pkg.PackageListeners;
import org.apache.solr.pkg.PackageLoader;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackagePluginHolder<T>
extends PluginBag.PluginHolder<T> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String LATEST = "$LATEST";
    private final SolrCore core;
    private final SolrConfig.SolrPluginInfo pluginMeta;
    private PackageLoader.Package.Version pkgVersion;
    private PluginInfo info;

    public PackagePluginHolder(final PluginInfo info, SolrCore core, SolrConfig.SolrPluginInfo pluginMeta) {
        super(info);
        this.core = core;
        this.pluginMeta = pluginMeta;
        this.info = info;
        this.reload(core.getCoreContainer().getPackageLoader().getPackage(info.pkgName));
        core.getPackageListeners().addListener(new PackageListeners.Listener(){

            @Override
            public String packageName() {
                return info.pkgName;
            }

            @Override
            public Map<String, PackageAPI.PkgVersion> packageDetails() {
                return Collections.singletonMap(info.cName.original, PackagePluginHolder.this.pkgVersion.getPkgVersion());
            }

            @Override
            public void changed(PackageLoader.Package pkg, PackageListeners.Listener.Ctx ctx) {
                PackagePluginHolder.this.reload(pkg);
            }

            @Override
            public MapWriter getPackageVersion(PluginInfo.ClassName cName) {
                return PackagePluginHolder.this.pkgVersion == null ? null : ew -> PackagePluginHolder.this.pkgVersion.writeMap(ew);
            }
        });
    }

    public static <T> PluginBag.PluginHolder<T> createHolder(T inst, Class<T> type) {
        SolrConfig.SolrPluginInfo plugin = SolrConfig.classVsSolrPluginInfo.get(type.getName());
        PluginInfo info = new PluginInfo(plugin.tag, Collections.singletonMap("class", inst.getClass().getName()));
        return new PluginBag.PluginHolder<T>(info, inst);
    }

    public static <T> PluginBag.PluginHolder<T> createHolder(PluginInfo info, SolrCore core, Class<T> type, String msg) {
        if (info.cName.pkg == null) {
            return new PluginBag.PluginHolder<T>(info, core.createInitInstance(info, type, msg, null));
        }
        return new PackagePluginHolder<T>(info, core, SolrConfig.classVsSolrPluginInfo.get(type.getName()));
    }

    private synchronized void reload(PackageLoader.Package pkg) {
        PackageLoader.Package.Version pkgLatest;
        String lessThan = this.core.getSolrConfig().maxPackageVersion(this.info.pkgName);
        PackageLoader.Package.Version newest = pkg.getLatest(lessThan);
        if (newest == null) {
            log.error("No latest version available for package : {}", (Object)pkg.name());
            return;
        }
        if (lessThan != null && (pkgLatest = pkg.getLatest()) != newest && log.isInfoEnabled()) {
            log.info("Using version :{}. latest is {},  params.json has config {} : {}", new Object[]{newest.getVersion(), pkgLatest.getVersion(), pkg.name(), lessThan});
        }
        if (this.pkgVersion != null && newest == this.pkgVersion) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("loading plugin: {} -> {} using  package {}:{}", new Object[]{this.pluginInfo.type, this.pluginInfo.name, pkg.name(), newest.getVersion()});
        }
        this.initNewInstance(newest);
        this.pkgVersion = newest;
    }

    protected Object initNewInstance(PackageLoader.Package.Version newest) {
        Object instance = SolrCore.createInstance(this.pluginInfo.className, this.pluginMeta.clazz, this.pluginMeta.getCleanTag(), this.core, newest.getLoader());
        PluginBag.initInstance(instance, this.pluginInfo);
        this.handleAwareCallbacks(newest.getLoader(), instance);
        Object old = this.inst;
        this.inst = instance;
        if (old instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)old;
            try {
                closeable.close();
            }
            catch (Exception e) {
                log.error("error closing plugin", (Throwable)e);
            }
        }
        return this.inst;
    }

    private void handleAwareCallbacks(SolrResourceLoader loader, Object instance) {
        if (instance instanceof SolrCoreAware) {
            SolrCoreAware coreAware = (SolrCoreAware)instance;
            if (!this.core.getResourceLoader().addToCoreAware(coreAware)) {
                coreAware.inform(this.core);
            }
        }
        if (instance instanceof ResourceLoaderAware) {
            SolrResourceLoader.assertAwareCompatibility(ResourceLoaderAware.class, instance);
            try {
                ((ResourceLoaderAware)instance).inform((ResourceLoader)loader);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        if (instance instanceof SolrInfoBean) {
            this.core.getResourceLoader().addToInfoBeans(instance);
        }
    }
}

