/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.singlesourcefile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class CompileProcess {
    private static final Logger LOG = Logger.getLogger(CompileProcess.class.getName());

    CompileProcess() {
    }

    public Process setupProcess(FileObject fileObject) {
        String vmOptions;
        FileObject javac = JavaPlatformManager.getDefault().getDefaultPlatform().findTool("javac");
        File javacFile = FileUtil.toFile((FileObject)javac);
        String javacPath = javacFile.getAbsolutePath();
        ArrayList<String> compileCommandList = new ArrayList<String>();
        Object compilerVmOptionsObj = fileObject.getAttribute("single_file_vm_options");
        compileCommandList.add(javacPath);
        compileCommandList.add("-g");
        String string = vmOptions = compilerVmOptionsObj != null ? ((String)compilerVmOptionsObj).trim() : "";
        if (!vmOptions.isEmpty()) {
            compileCommandList.addAll(Arrays.asList(vmOptions.split(" ")));
        }
        compileCommandList.add(fileObject.getPath());
        ProcessBuilder compileProcessBuilder = new ProcessBuilder(compileCommandList);
        compileProcessBuilder.directory(new File(fileObject.getParent().getPath()));
        compileProcessBuilder.redirectErrorStream(true);
        compileProcessBuilder.redirectOutput();
        try {
            return compileProcessBuilder.start();
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Could not get InputStream of Compile Process");
            return null;
        }
    }
}

