/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.dd.spi.MetadataUnit;
import org.netbeans.modules.j2ee.dd.spi.ejb.EjbJarMetadataModelFactory;
import org.netbeans.modules.j2ee.dd.spi.webservices.WebservicesMetadataModelFactory;
import org.netbeans.modules.j2ee.deployment.common.api.EjbChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ResourceChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation2;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ResourceChangeReporterFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ResourceChangeReporterImplementation;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.EjbJarProjectProperties;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.java.api.common.classpath.ClassPathProviderImpl;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class EjbJarProvider
extends J2eeModuleProvider
implements J2eeModuleImplementation2,
ModuleChangeReporter,
EjbChangeDescriptor,
PropertyChangeListener {
    public static final String FILE_DD = "ejb-jar.xml";
    private final ResourceChangeReporter rcr = ResourceChangeReporterFactory.createResourceChangeReporter((ResourceChangeReporterImplementation)new EjbJarResourceChangeReporter());
    private final EjbJarProject project;
    private final AntProjectHelper helper;
    private MetadataModel<EjbJarMetadata> ejbJarMetadataModel;
    private MetadataModel<WebservicesMetadata> webservicesMetadataModel;
    private PropertyChangeSupport propertyChangeSupport;
    private J2eeModule j2eeModule;
    private ClassPathProviderImpl cpProvider;
    private long notificationTimeout = 0L;

    EjbJarProvider(EjbJarProject project, AntProjectHelper helper, ClassPathProviderImpl cpProvider) {
        this.project = project;
        this.helper = helper;
        this.cpProvider = cpProvider;
    }

    public FileObject getDeploymentDescriptor() {
        FileObject ddFO = null;
        FileObject metaInfFo = this.getMetaInf();
        if (metaInfFo != null) {
            ddFO = metaInfFo.getFileObject(FILE_DD);
        }
        if (ddFO != null || !Profile.JAVA_EE_5.equals(this.getJ2eeProfile())) {
            // empty if block
        }
        return ddFO;
    }

    public ClassPath getClassPath() {
        ClassPathProviderImpl cpp = this.project.getClassPathProvider();
        if (cpp != null) {
            return cpp.findClassPath(this.getFileObject("src.dir"), "classpath/source");
        }
        return null;
    }

    public FileObject[] getJavaSources() {
        return this.project.getSourceRoots().getRoots();
    }

    public FileObject getMetaInf() {
        String value = this.helper.getStandardPropertyEvaluator().getProperty("meta.inf");
        return this.resolveMetaInf(value);
    }

    FileObject resolveMetaInf(String value) {
        Profile version;
        FileObject metaInf;
        FileObject fileObject = metaInf = value != null ? this.helper.resolveFileObject(value) : null;
        if (metaInf == null && EjbJarProvider.needConfigurationFolder(version = this.project.getAPIEjbJar().getJ2eeProfile())) {
            String path = value != null ? this.helper.resolvePath(value) : "";
            this.showErrorMessage(NbBundle.getMessage(EjbJarProvider.class, (String)"MSG_MetaInfCorrupted", (Object)this.project.getName(), (Object)path));
        }
        return metaInf;
    }

    static boolean needConfigurationFolder(Profile version) {
        return Profile.J2EE_13.equals(version) || Profile.J2EE_14.equals(version);
    }

    public File getMetaInfAsFile() {
        return this.getFile("meta.inf");
    }

    public File getResourceDirectory() {
        File f = this.getFile("resource.dir");
        if (f == null) {
            f = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "setup");
        }
        return f;
    }

    public File getDeploymentConfigurationFile(String name) {
        String path = this.getConfigSupport().getContentRelativePath(name);
        if (path == null) {
            path = name;
        }
        if (path.startsWith("META-INF/")) {
            path = path.substring(8);
        }
        return FileUtil.normalizeFile((File)new File(this.getMetaInfAsFile(), path));
    }

    public ClassPathProvider getClassPathProvider() {
        return this.project.getClassPathProvider();
    }

    public FileObject getArchive() {
        return this.getFileObject("dist.jar");
    }

    private FileObject getFileObject(String propname) {
        String prop = this.helper.getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return this.helper.resolveFileObject(prop);
        }
        return null;
    }

    private File getFile(String propname) {
        String prop = this.helper.getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return this.helper.resolveFile(prop);
        }
        return null;
    }

    public synchronized J2eeModule getJ2eeModule() {
        if (this.j2eeModule == null) {
            this.j2eeModule = J2eeModuleFactory.createJ2eeModule((J2eeModuleImplementation2)this);
        }
        return this.j2eeModule;
    }

    public ModuleChangeReporter getModuleChangeReporter() {
        return this;
    }

    public ResourceChangeReporter getResourceChangeReporter() {
        return this.rcr;
    }

    public J2eeModuleProvider.DeployOnSaveSupport getDeployOnSaveSupport() {
        return this.project.getDeployOnSaveSupport();
    }

    public boolean isOnlyCompileOnSaveEnabled() {
        return Boolean.parseBoolean(this.project.evaluator().getProperty("j2ee.compile.on.save")) && !Boolean.parseBoolean(this.project.evaluator().getProperty("j2ee.deploy.on.save"));
    }

    public String getServerID() {
        return this.helper.getStandardPropertyEvaluator().getProperty("j2ee.server.type");
    }

    public String getServerInstanceID() {
        return this.helper.getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
    }

    public void setServerInstanceID(String serverInstanceID) {
        assert (serverInstanceID != null) : "passed serverInstanceID cannot be null";
        EjbJarProjectProperties.setServerInstance(this.project, this.helper, serverInstanceID);
    }

    public Iterator<J2eeModule.RootedEntry> getArchiveContents() throws IOException {
        FileObject content = this.getContentDirectory();
        content.refresh();
        return new IT(content);
    }

    public FileObject getContentDirectory() {
        return this.getFileObject("build.classes.dir");
    }

    public FileObject getBuildDirectory() {
        return this.getFileObject("build.dir");
    }

    public File getContentDirectoryAsFile() {
        return this.getFile("build.classes.dir");
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> type) {
        if (type == EjbJarMetadata.class) {
            MetadataModel<EjbJarMetadata> model = this.getMetadataModel();
            return model;
        }
        if (type == WebservicesMetadata.class) {
            MetadataModel<WebservicesMetadata> model = this.getWebservicesMetadataModel();
            return model;
        }
        return null;
    }

    public FileObject getDD() {
        FileObject metaInfFo = this.getMetaInf();
        if (metaInfFo == null) {
            return null;
        }
        return metaInfFo.getFileObject("webservices", "xml");
    }

    public EjbChangeDescriptor getEjbChanges(long timestamp) {
        return this;
    }

    public J2eeModule.Type getModuleType() {
        return J2eeModule.Type.EJB;
    }

    public String getModuleVersion() {
        Profile platformVersion = this.getJ2eeProfile();
        if (platformVersion == null) {
            platformVersion = Profile.JAVA_EE_7_FULL;
        }
        if (platformVersion.isAtLeast(Profile.JAVA_EE_7_WEB)) {
            return "3.2";
        }
        if (platformVersion.isAtLeast(Profile.JAVA_EE_6_WEB)) {
            return "3.1";
        }
        if (Profile.JAVA_EE_5.equals(platformVersion)) {
            return "3.0";
        }
        return "2.1";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dd_version")) {
            String oldVersion = (String)evt.getOldValue();
            String newVersion = (String)evt.getNewValue();
            this.getPropertyChangeSupport().firePropertyChange("moduleVersion", oldVersion, newVersion);
        } else if (evt.getPropertyName().equals("j2ee.server.instance")) {
            Deployment d = Deployment.getDefault();
            String oldServerID = evt.getOldValue() == null ? null : d.getServerID((String)evt.getOldValue());
            String newServerID = evt.getNewValue() == null ? null : d.getServerID((String)evt.getNewValue());
            this.fireServerChange(oldServerID, newServerID);
        } else if ("resource.dir".equals(evt.getPropertyName())) {
            String oldValue = (String)evt.getOldValue();
            String newValue = (String)evt.getNewValue();
            this.getPropertyChangeSupport().firePropertyChange("resourceDir", oldValue == null ? null : new File(oldValue), newValue == null ? null : new File(newValue));
        }
    }

    public String getUrl() {
        EditableProperties ep = this.helper.getProperties("nbproject/project.properties");
        String name = ep.getProperty("jar.name");
        return name == null ? "" : '/' + name;
    }

    public boolean isManifestChanged(long timestamp) {
        return false;
    }

    public void setUrl(String url) {
        throw new UnsupportedOperationException("Cannot customize URL of EJB module");
    }

    public boolean ejbsChanged() {
        return false;
    }

    public String[] getChangedEjbs() {
        return new String[0];
    }

    public Profile getJ2eeProfile() {
        return Profile.fromPropertiesString((String)this.helper.getStandardPropertyEvaluator().getProperty("j2ee.platform"));
    }

    public synchronized MetadataModel<EjbJarMetadata> getMetadataModel() {
        if (this.ejbJarMetadataModel == null) {
            FileObject ddFO = this.getDeploymentDescriptor();
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.ejbJarMetadataModel = EjbJarMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit);
        }
        return this.ejbJarMetadataModel;
    }

    public synchronized MetadataModel<WebservicesMetadata> getWebservicesMetadataModel() {
        if (this.webservicesMetadataModel == null) {
            FileObject ddFO = this.getDD();
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.webservicesMetadataModel = WebservicesMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit);
        }
        return this.webservicesMetadataModel;
    }

    public FileObject[] getSourceRoots() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        LinkedList<FileObject> roots = new LinkedList<FileObject>();
        FileObject metaInf = this.getMetaInf();
        if (metaInf != null) {
            roots.add(metaInf);
        }
        for (int i = 0; i < groups.length; ++i) {
            roots.add(groups[i].getRootFolder());
        }
        FileObject[] rootArray = new FileObject[roots.size()];
        return roots.toArray(rootArray);
    }

    private void showErrorMessage(final String message) {
        if (new Date().getTime() > this.notificationTimeout && this.isProjectOpen()) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                    }
                }
            };
            r.run();
            this.notificationTimeout = new Date().getTime() + 20000L;
        }
    }

    private boolean isProjectOpen() {
        if (OpenProjects.getDefault() != null) {
            Project[] projects = OpenProjects.getDefault().getOpenProjects();
            for (int i = 0; i < projects.length; ++i) {
                if (!projects[i].equals(this.project)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyChangeSupport getPropertyChangeSupport() {
        EjbJarProvider ejbJarProvider = this;
        synchronized (ejbJarProvider) {
            if (this.propertyChangeSupport == null) {
                this.propertyChangeSupport = new PropertyChangeSupport(this);
            }
            return this.propertyChangeSupport;
        }
    }

    public File[] getRequiredLibraries() {
        ClassPath cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (PropertyEvaluator)this.project.evaluator(), (String[])new String[]{"javac.classpath"}));
        ArrayList<File> files = new ArrayList<File>();
        for (FileObject fo : cp.getRoots()) {
            if (FileUtil.getArchiveFile((FileObject)fo) == null) continue;
            files.add(FileUtil.toFile((FileObject)FileUtil.getArchiveFile((FileObject)fo)));
        }
        return files.toArray(new File[files.size()]);
    }

    private static final class FSRootRE
    implements J2eeModule.RootedEntry {
        FileObject f;
        FileObject root;

        FSRootRE(FileObject root, FileObject f) {
            this.f = f;
            this.root = root;
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public String getRelativePath() {
            return FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.f);
        }
    }

    private static class IT
    implements Iterator<J2eeModule.RootedEntry> {
        Enumeration ch;
        FileObject root;

        private IT(FileObject f) {
            this.ch = f.getChildren(true);
            this.root = f;
        }

        @Override
        public boolean hasNext() {
            return this.ch.hasMoreElements();
        }

        @Override
        public J2eeModule.RootedEntry next() {
            FileObject f = (FileObject)this.ch.nextElement();
            return new FSRootRE(this.root, f);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EjbJarResourceChangeReporter
    implements ResourceChangeReporterImplementation {
        private EjbJarResourceChangeReporter() {
        }

        public boolean isServerResourceChanged(long lastDeploy) {
            File[] children;
            File resDir = EjbJarProvider.this.getResourceDirectory();
            if (resDir != null && resDir.exists() && resDir.isDirectory() && (children = resDir.listFiles()) != null) {
                for (File file : children) {
                    if (file.lastModified() <= lastDeploy) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

