/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import io.foojay.api.discoclient.pkg.ApiFeature;
import java.util.Arrays;
import java.util.List;

public enum ReleaseStatus implements ApiFeature
{
    GA("General Access", "ga", ""),
    EA("Early Access", "ea", "-ea"),
    NONE("-", "", ""),
    NOT_FOUND("", "", "");

    private final String uiString;
    private final String apiString;
    private final String preReleaseId;

    private ReleaseStatus(String uiString, String apiString, String preReleaseId) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.preReleaseId = preReleaseId;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public ReleaseStatus getDefault() {
        return NONE;
    }

    @Override
    public ReleaseStatus getNotFound() {
        return NOT_FOUND;
    }

    public ReleaseStatus[] getAll() {
        return ReleaseStatus.values();
    }

    public static ReleaseStatus fromText(String text) {
        switch (text) {
            case "-ea": 
            case "-EA": 
            case "_ea": 
            case "_EA": 
            case "ea": 
            case "EA": 
            case "ea_": 
            case "EA_": {
                return EA;
            }
            case "-ga": 
            case "-GA": 
            case "_ga": 
            case "_GA": 
            case "ga": 
            case "GA": 
            case "ga_": 
            case "GA_": {
                return GA;
            }
        }
        return NOT_FOUND;
    }

    public String getPreReleaseId() {
        return this.preReleaseId;
    }

    public static List<ReleaseStatus> getAsList() {
        return Arrays.asList(ReleaseStatus.values());
    }
}

