/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes.visitors;

import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.FileElementQuery;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.NamespaceElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;

public class PhpElementVisitor
extends DefaultTreePathVisitor {
    private final FileElementQuery elementQuery;

    protected PhpElementVisitor(PHPParseResult result) {
        this.elementQuery = FileElementQuery.getInstance(result);
    }

    public static ElementQuery.File createElementQuery(PHPParseResult result) {
        PhpElementVisitor instance = new PhpElementVisitor(result);
        instance.scan(instance.elementQuery.getResult().getProgram());
        return instance.toElementQuery();
    }

    @Override
    public void visit(ClassDeclaration node) {
        NamespaceElement namespace = this.elementQuery.getLast(NamespaceElement.class);
        this.elementQuery.create(namespace, node);
        super.visit(node);
    }

    @Override
    public void visit(InterfaceDeclaration node) {
        NamespaceElement namespace = this.elementQuery.getLast(NamespaceElement.class);
        this.elementQuery.create(namespace, node);
        super.visit(node);
    }

    @Override
    public void visit(TraitDeclaration node) {
        NamespaceElement namespace = this.elementQuery.getLast(NamespaceElement.class);
        this.elementQuery.create(namespace, node);
        super.visit(node);
    }

    @Override
    public void visit(ConstantDeclaration node) {
        PhpElement last = this.elementQuery.getAnyLast(NamespaceElement.class, TypeElement.class);
        if (last instanceof TypeElement) {
            this.elementQuery.createTypeConstant((TypeElement)last, node);
        } else {
            this.elementQuery.createConstant((NamespaceElement)last, node);
        }
        super.visit(node);
    }

    @Override
    public void visit(FunctionDeclaration node) {
        NamespaceElement namespace = this.elementQuery.getLast(NamespaceElement.class);
        this.elementQuery.create(namespace, node);
        super.visit(node);
    }

    @Override
    public void visit(FieldsDeclaration node) {
        TypeElement type = this.elementQuery.getLast(TypeElement.class);
        this.elementQuery.create(type, node);
        super.visit(node);
    }

    @Override
    public void visit(FieldAccess node) {
        TypeElement type = this.elementQuery.getLast(TypeElement.class);
        this.elementQuery.create(type, node);
        super.visit(node);
    }

    @Override
    public void visit(MethodDeclaration node) {
        TypeElement type = this.elementQuery.getLast(TypeElement.class);
        this.elementQuery.create(type, node);
        FunctionDeclaration function = node.getFunction();
        this.addToPath(node);
        this.scan(function.getFunctionName());
        this.scan(function.getFormalParameters());
        this.scan(function.getBody());
        this.removeFromPath();
    }

    @Override
    public void visit(NamespaceDeclaration node) {
        this.elementQuery.create(node);
        super.visit(node);
    }

    @Override
    public void visit(Variable node) {
        String extractVariableName = CodeUtils.extractVariableName(node);
        if (extractVariableName != null && !extractVariableName.startsWith("$")) {
            super.visit(node);
            return;
        }
        boolean isMethodDeclaration = false;
        boolean isFunctionDeclaration = false;
        boolean isTopLevelVariable = true;
        for (ASTNode scopeNode : this.getPath()) {
            if (scopeNode instanceof MethodDeclaration) {
                isMethodDeclaration = true;
                break;
            }
            if (scopeNode instanceof FunctionDeclaration) {
                isFunctionDeclaration = true;
                break;
            }
            if (!(scopeNode instanceof TypeDeclaration) && !(scopeNode instanceof SingleFieldDeclaration) && !(scopeNode instanceof StaticFieldAccess) && !(scopeNode instanceof FieldsDeclaration)) continue;
            isTopLevelVariable = false;
            break;
        }
        if (isMethodDeclaration) {
            MethodElement method = this.elementQuery.getLast(MethodElement.class);
            assert (method != null);
            this.elementQuery.createMethodVariable(method, node);
        } else if (isFunctionDeclaration) {
            FunctionElement function = this.elementQuery.getLast(FunctionElement.class);
            assert (function != null);
            this.elementQuery.createFunctionVariable(function, node);
        } else if (isTopLevelVariable) {
            this.elementQuery.createTopLevelVariable(node);
        }
        super.visit(node);
    }

    public final ElementQuery.File toElementQuery() {
        return this.elementQuery;
    }

    public FileElementQuery getElementQuery() {
        return this.elementQuery;
    }
}

