/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.url;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Parser {
    private static final Pattern URL_PATTERN = Pattern.compile("(ht|f)(tp(s?)|ile)://[0-9a-zA-Z/.?%+_~=\\\\&@$\\-#,:!/(/)]*");
    private static final Pattern CHARSET = Pattern.compile("charset=([^;]+)(;|$)", 8);

    private Parser() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Iterable<int[]> recognizeURLs(CharSequence text) {
        LinkedList<int[]> result = new LinkedList<int[]>();
        STATE state = STATE.START;
        int lastURLStart = -1;
        block15: for (int cntr = 0; cntr < text.length(); ++cntr) {
            char ch = text.charAt(cntr);
            if (state == STATE.END) {
                if (Character.isLetterOrDigit(ch)) continue;
                switch (ch) {
                    case '!': 
                    case '#': 
                    case '$': 
                    case '%': 
                    case '&': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case ';': 
                    case '=': 
                    case '?': 
                    case '@': 
                    case '\\': 
                    case '_': 
                    case '~': {
                        break;
                    }
                    default: {
                        assert (lastURLStart != -1);
                        result.add(new int[]{lastURLStart, cntr});
                        lastURLStart = -1;
                        state = STATE.START;
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case 'h': {
                    if (state != STATE.START) break;
                    lastURLStart = cntr;
                    state = STATE.H;
                    continue block15;
                }
                case 't': {
                    if (state == STATE.H) {
                        state = STATE.HT;
                        continue block15;
                    }
                    if (state == STATE.HT) {
                        state = STATE.HTT_FT;
                        continue block15;
                    }
                    if (state != STATE.F) break;
                    state = STATE.HTT_FT;
                    continue block15;
                }
                case 'f': {
                    if (state != STATE.START) break;
                    lastURLStart = cntr;
                    state = STATE.F;
                    continue block15;
                }
                case 'i': {
                    if (state == STATE.F) {
                        state = STATE.FI;
                        continue block15;
                    }
                }
                case 'l': {
                    if (state == STATE.FI) {
                        state = STATE.FIL;
                        continue block15;
                    }
                }
                case 'e': {
                    if (state == STATE.FIL) {
                        state = STATE.FILE;
                        continue block15;
                    }
                }
                case 'p': {
                    if (state != STATE.HTT_FT) break;
                    state = STATE.HTTP_FTP;
                    continue block15;
                }
                case 's': {
                    if (state != STATE.HTTP_FTP) break;
                    state = STATE.HTTPS;
                    continue block15;
                }
                case ':': {
                    if (state != STATE.HTTP_FTP && state != STATE.HTTPS && state != STATE.FILE) break;
                    state = STATE.HTTPC;
                    continue block15;
                }
                case '/': {
                    if (state == STATE.HTTPC) {
                        state = STATE.HTTPCS;
                        continue block15;
                    }
                    if (state != STATE.HTTPCS) break;
                    state = STATE.END;
                    continue block15;
                }
            }
            state = STATE.START;
            lastURLStart = -1;
        }
        if (lastURLStart != -1 && state == STATE.END) {
            result.add(new int[]{lastURLStart, text.length()});
        }
        return result;
    }

    public static Iterable<int[]> recognizeURLsREBased(CharSequence text) {
        Matcher m = URL_PATTERN.matcher(text);
        LinkedList<int[]> result = new LinkedList<int[]>();
        while (m.find()) {
            result.add(new int[]{m.start(), m.start() + m.group(0).length()});
        }
        return result;
    }

    public static String decodeContentType(String contentType) {
        Matcher m;
        if (contentType == null) {
            return null;
        }
        if (contentType != null && (m = CHARSET.matcher(contentType)).find()) {
            return m.group(1);
        }
        return null;
    }

    private static enum STATE {
        START,
        H,
        HT,
        F,
        HTT_FT,
        HTTP_FTP,
        HTTPS,
        HTTPC,
        HTTPCS,
        FI,
        FIL,
        FILE,
        END;

    }
}

