/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.access.FrameSlotNode;
import com.oracle.truffle.js.nodes.access.LocalVarPostfixIncNodeGen;
import com.oracle.truffle.js.nodes.access.LocalVarPrefixIncNodeGen;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;

public abstract class LocalVarIncNode
extends FrameSlotNode {
    protected final LocalVarOp op;
    protected final boolean hasTemporalDeadZone;
    @Node.Child
    @Executed
    protected ScopeFrameNode scopeFrameNode;

    protected LocalVarIncNode(LocalVarOp op, FrameSlot frameSlot, boolean hasTemporalDeadZone, ScopeFrameNode scopeFrameNode) {
        super(frameSlot);
        this.op = op;
        this.hasTemporalDeadZone = hasTemporalDeadZone;
        this.scopeFrameNode = scopeFrameNode;
    }

    public static LocalVarIncNode createPrefix(Op op, FrameSlotNode frameSlotNode) {
        return LocalVarPrefixIncNodeGen.create(op.op, frameSlotNode.getFrameSlot(), frameSlotNode.hasTemporalDeadZone(), frameSlotNode.getLevelFrameNode());
    }

    public static LocalVarIncNode createPostfix(Op op, FrameSlotNode frameSlotNode) {
        return LocalVarPostfixIncNodeGen.create(op.op, frameSlotNode.getFrameSlot(), frameSlotNode.hasTemporalDeadZone(), frameSlotNode.getLevelFrameNode());
    }

    @Override
    public boolean hasTemporalDeadZone() {
        return this.hasTemporalDeadZone;
    }

    @Override
    public final ScopeFrameNode getLevelFrameNode() {
        return this.scopeFrameNode;
    }

    protected static class DecOp
    extends LocalVarOp {
        protected DecOp() {
        }

        @Override
        public int doInt(int value) {
            return Math.subtractExact(value, 1);
        }

        @Override
        public double doDouble(double value) {
            return value - 1.0;
        }

        @Override
        public Number doNumber(Number numValue, ConditionProfile isIntegerProfile, ConditionProfile isBoundaryValue) {
            if (isIntegerProfile.profile(numValue instanceof Integer)) {
                int intValue = (Integer)numValue;
                if (isBoundaryValue.profile(intValue != Integer.MIN_VALUE)) {
                    return intValue - 1;
                }
                return (double)intValue - 1.0;
            }
            double doubleValue = JSRuntime.doubleValue(numValue);
            return doubleValue - 1.0;
        }

        @Override
        public BigInt doBigInt(BigInt value) {
            return value.subtract(BigInt.ONE);
        }

        @Override
        public SafeInteger doSafeInteger(SafeInteger value) {
            return value.decrementExact();
        }
    }

    protected static class IncOp
    extends LocalVarOp {
        protected IncOp() {
        }

        @Override
        public int doInt(int value) {
            return Math.addExact(value, 1);
        }

        @Override
        public double doDouble(double value) {
            return value + 1.0;
        }

        @Override
        public Number doNumber(Number numValue, ConditionProfile isIntegerProfile, ConditionProfile isBoundaryValue) {
            if (isIntegerProfile.profile(numValue instanceof Integer)) {
                int intValue = (Integer)numValue;
                if (isBoundaryValue.profile(intValue != Integer.MAX_VALUE)) {
                    return intValue + 1;
                }
                return (double)intValue + 1.0;
            }
            double doubleValue = JSRuntime.doubleValue(numValue);
            return doubleValue + 1.0;
        }

        @Override
        public BigInt doBigInt(BigInt value) {
            return value.add(BigInt.ONE);
        }

        @Override
        public SafeInteger doSafeInteger(SafeInteger value) {
            return value.incrementExact();
        }
    }

    static abstract class LocalVarOp {
        LocalVarOp() {
        }

        public abstract int doInt(int var1);

        public abstract double doDouble(double var1);

        public abstract Number doNumber(Number var1, ConditionProfile var2, ConditionProfile var3);

        public abstract BigInt doBigInt(BigInt var1);

        public abstract SafeInteger doSafeInteger(SafeInteger var1);
    }

    public static enum Op {
        Inc(new IncOp()),
        Dec(new DecOp());

        public final LocalVarOp op;

        private Op(LocalVarOp op) {
            this.op = op;
        }
    }
}

