/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsArrayNode;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=IsArrayNode.class)
public final class IsArrayNodeGen
extends IsArrayNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private IsArrayShapeData isArrayShape_cache;
    @CompilerDirectives.CompilationFinal
    private IsArrayJSClassData isArrayJSClass_cache;

    private IsArrayNodeGen(boolean onlyArray, boolean fastArray, boolean fastAndTypedArray) {
        super(onlyArray, fastArray, fastAndTypedArray);
    }

    @Override
    @ExplodeLoop
    public boolean execute(Object arg0Value) {
        int state = this.state_;
        if ((state & 7) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject)arg0Value;
            if ((state & 1) != 0) {
                IsArrayShapeData s1_ = this.isArrayShape_cache;
                while (s1_ != null) {
                    if (s1_.cachedShape_.check(arg0Value_)) {
                        return IsArrayNode.doIsArrayShape(arg0Value_, s1_.cachedShape_, s1_.cachedResult_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                IsArrayJSClassData s2_ = this.isArrayJSClass_cache;
                while (s2_ != null) {
                    assert (s2_.cachedClass_ != null);
                    if (s2_.cachedClass_.isInstance(arg0Value_)) {
                        return IsArrayNode.doIsArrayJSClass(arg0Value_, s2_.cachedResult_, s2_.cachedClass_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 4) != 0) {
                return this.isArray(arg0Value_);
            }
        }
        if ((state & 8) != 0 && !JSGuards.isDynamicObject(arg0Value)) {
            return IsArrayNode.isNotDynamicObject(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private boolean executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if ((exclude & 1) == 0) {
                    Shape cachedShape__2;
                    int count1_ = 0;
                    IsArrayShapeData s1_ = this.isArrayShape_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && !s1_.cachedShape_.check(arg0Value_)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && (cachedShape__2 = arg0Value_.getShape()).check(arg0Value_) && count1_ < 1) {
                        s1_ = new IsArrayShapeData(this.isArrayShape_cache);
                        s1_.cachedShape_ = cachedShape__2;
                        s1_.cachedResult_ = this.isArray(arg0Value_);
                        this.isArrayShape_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean cachedShape__2 = IsArrayNode.doIsArrayShape(arg0Value_, s1_.cachedShape_, s1_.cachedResult_);
                        return cachedShape__2;
                    }
                }
                if ((exclude & 2) == 0) {
                    JSClass cachedClass__;
                    int count2_ = 0;
                    IsArrayJSClassData s2_ = this.isArrayJSClass_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null) {
                            assert (s2_.cachedClass_ != null);
                            if (s2_.cachedClass_.isInstance(arg0Value_)) break;
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && (cachedClass__ = JSGuards.getJSClassChecked(arg0Value_)) != null && cachedClass__.isInstance(arg0Value_) && count2_ < 1) {
                        s2_ = new IsArrayJSClassData(this.isArrayJSClass_cache);
                        s2_.cachedResult_ = this.isArray(arg0Value_);
                        s2_.cachedClass_ = cachedClass__;
                        this.isArrayJSClass_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        this.isArrayShape_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl = IsArrayNode.doIsArrayJSClass(arg0Value_, s2_.cachedResult_, s2_.cachedClass_);
                        return bl;
                    }
                }
                this.exclude_ = exclude |= 3;
                this.isArrayShape_cache = null;
                this.isArrayJSClass_cache = null;
                state &= 0xFFFFFFFC;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                boolean bl = this.isArray(arg0Value_);
                return bl;
            }
            if (!JSGuards.isDynamicObject(arg0Value)) {
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                boolean bl = IsArrayNode.isNotDynamicObject(arg0Value);
                return bl;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            IsArrayShapeData s1_ = this.isArrayShape_cache;
            IsArrayJSClassData s2_ = this.isArrayJSClass_cache;
            if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[5];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doIsArrayShape";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            IsArrayShapeData s1_ = this.isArrayShape_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedShape_, s1_.cachedResult_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doIsArrayJSClass";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            IsArrayJSClassData s2_ = this.isArrayJSClass_cache;
            while (s2_ != null) {
                cached.add(Arrays.asList(new Object[]{s2_.cachedResult_, s2_.cachedClass_}));
                s2_ = s2_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "isArray";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "isNotDynamicObject";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static IsArrayNode create(boolean onlyArray, boolean fastArray, boolean fastAndTypedArray) {
        return new IsArrayNodeGen(onlyArray, fastArray, fastAndTypedArray);
    }

    @GeneratedBy(value=IsArrayNode.IsArrayWrappedNode.class)
    public static final class IsArrayWrappedNodeGen
    extends IsArrayNode.IsArrayWrappedNode
    implements Introspection.Provider {
        private IsArrayWrappedNodeGen(JavaScriptNode operandNode, IsArrayNode isArrayNode) {
            super(operandNode, isArrayNode);
        }

        @Override
        public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
            return this.doObject(operandNodeValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object operandNodeValue_ = this.operandNode.execute(frameValue);
            return this.doObject(operandNodeValue_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            Object operandNodeValue_ = this.operandNode.execute(frameValue);
            return this.doObject(operandNodeValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "doObject";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static IsArrayNode.IsArrayWrappedNode create(JavaScriptNode operandNode, IsArrayNode isArrayNode) {
            return new IsArrayWrappedNodeGen(operandNode, isArrayNode);
        }
    }

    @GeneratedBy(value=IsArrayNode.class)
    private static final class IsArrayJSClassData {
        @CompilerDirectives.CompilationFinal
        IsArrayJSClassData next_;
        @CompilerDirectives.CompilationFinal
        boolean cachedResult_;
        @CompilerDirectives.CompilationFinal
        JSClass cachedClass_;

        IsArrayJSClassData(IsArrayJSClassData next_) {
            this.next_ = next_;
        }
    }

    @GeneratedBy(value=IsArrayNode.class)
    private static final class IsArrayShapeData {
        @CompilerDirectives.CompilationFinal
        IsArrayShapeData next_;
        @CompilerDirectives.CompilationFinal
        Shape cachedShape_;
        @CompilerDirectives.CompilationFinal
        boolean cachedResult_;

        IsArrayShapeData(IsArrayShapeData next_) {
            this.next_ = next_;
        }
    }
}

