/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.support;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.tools.StandardJavaFileManager;
import jdk.jshell.JShell;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.SourceCodeAnalysis;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.ExecutionControlProvider;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.nbjshell.JShellAccessor;
import org.netbeans.lib.nbjshell.NbExecutionControl;
import org.netbeans.lib.nbjshell.RemoteJShellService;
import org.netbeans.modules.jshell.env.JShellEnvironment;
import org.netbeans.modules.jshell.model.ConsoleContents;
import org.netbeans.modules.jshell.model.ConsoleEvent;
import org.netbeans.modules.jshell.model.ConsoleListener;
import org.netbeans.modules.jshell.model.ConsoleModel;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.jshell.model.Rng;
import org.netbeans.modules.jshell.model.SnippetHandle;
import org.netbeans.modules.jshell.parsing.LexerEmbeddingAdapter;
import org.netbeans.modules.jshell.parsing.ModelAccessor;
import org.netbeans.modules.jshell.parsing.ShellAccessBridge;
import org.netbeans.modules.jshell.parsing.SnippetRegistry;
import org.netbeans.modules.jshell.project.ShellProjectUtils;
import org.netbeans.modules.jshell.support.Bundle;
import org.netbeans.modules.jshell.support.ShellHistory;
import org.netbeans.modules.jshell.support.SwitchingJavaFileManger;
import org.netbeans.modules.jshell.tool.JShellLauncher;
import org.netbeans.modules.jshell.tool.JShellTool;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.spi.editor.guards.GuardedEditorSupport;
import org.netbeans.spi.editor.guards.support.AbstractGuardedSectionsProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public class ShellSession {
    private static final Logger LOG = Logger.getLogger(ShellSession.class.getName());
    public static final String PROP_ACTIVE = "active";
    public static final String PROP_ENGINE = "active";
    private final FileObject workRoot;
    private final Document consoleDocument;
    private final JavaPlatform platform;
    private final ClasspathInfo projectInfo;
    private ClasspathInfo cpInfo;
    private JShell shell;
    private ConsoleModel model;
    private PrintStream shellControlOutput;
    private String displayName;
    private volatile boolean ignoreClose;
    private FileObject consoleFile;
    private JShellEnvironment env;
    private final FileSystem editorSnippetsFileSystem;
    private final FileObject editorWorkRoot;
    private volatile Set<Snippet> initialSetupSnippets = Collections.emptySet();
    private volatile boolean detached;
    private static final RequestProcessor FORCE_CLOSE_RP = new RequestProcessor("JShell socket closer");
    private final Map<Snippet, Long> snippetTimeStamps = new WeakHashMap<Snippet, Long>();
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private SnippetRegistry snippetRegistry;
    private volatile Launcher launcher;
    private Writer documentWriter = new DocumentOutput();
    private RemoteJShellService exec;
    private boolean initializing;
    private SwitchingJavaFileManger fileman;
    private final ShellAccessBridge bridgeImpl = new ShellAccessBridge(){

        @Override
        public <T> T execute(Callable<T> xcode) throws Exception {
            if (ShellSession.this.fileman == null || ShellSession.this.evaluator.isRequestProcessorThread()) {
                return xcode.call();
            }
            return ShellSession.this.fileman.withLocalManager(xcode);
        }

        @Override
        public SourceCodeAnalysis.CompletionInfo analyzeInput(String input) {
            try {
                return this.execute(() -> ShellSession.this.ensureShell().sourceCodeAnalysis().analyzeCompletion(input));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public boolean isInitialized() {
            return ShellSession.this.shell != null;
        }
    };
    private final Set<Snippet> excludedSnippets = new HashSet<Snippet>();
    private AbstractGuardedSectionsProvider gsProvider;
    private GuardedSectionManager gsm;
    private boolean recordNoSave = false;
    private String executionLabel;
    private static final Map<Document, Reference<ShellSession>> allSessions = new WeakHashMap<Document, Reference<ShellSession>>();
    private RequestProcessor evaluator;

    public ShellSession(JShellEnvironment env) {
        this(env.getDisplayName(), env.getConsoleDocument(), env.getClasspathInfo(), env.getPlatform(), env.getWorkRoot(), env.getConsoleFile());
        this.env = env;
    }

    public JShellEnvironment getEnv() {
        return this.env;
    }

    private ShellSession(String displayName, Document doc, ClasspathInfo cpInfo, JavaPlatform platform, FileObject workRoot, FileObject consoleFile) {
        this.consoleDocument = doc;
        this.projectInfo = cpInfo;
        this.displayName = displayName;
        this.platform = platform;
        this.consoleFile = consoleFile;
        this.workRoot = workRoot;
        this.editorSnippetsFileSystem = FileUtil.createMemoryFileSystem();
        this.editorWorkRoot = this.editorSnippetsFileSystem.getRoot();
        this.shellControlOutput = new PrintStream(new WriterOutputStream(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                ShellSession.this.documentWriter.write(cbuf, off, len);
            }

            @Override
            public void flush() throws IOException {
                ShellSession.this.documentWriter.flush();
            }

            @Override
            public void close() throws IOException {
                ShellSession.this.documentWriter.close();
            }
        }));
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.propSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.propSupport.removePropertyChangeListener(pcl);
    }

    public boolean isActive() {
        return !this.detached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task detach() {
        Map<Document, Reference<ShellSession>> map = allSessions;
        synchronized (map) {
            Reference<ShellSession> refS = allSessions.get(this.consoleDocument);
            if (refS == null || refS.get() != this) {
                return Task.EMPTY;
            }
            allSessions.remove(this.consoleDocument);
            this.detached = true;
        }
        this.model.detach();
        this.closed();
        if (this.exec != null) {
            FORCE_CLOSE_RP.post(this::forceCloseStreams, 300);
        }
        this.gsm.getGuardedSections().forEach(gs -> gs.removeSection());
        return this.sendJShellClose();
    }

    private synchronized void forceCloseStreams() {
        if (this.exec != null) {
            this.exec.closeStreams();
        }
    }

    JShell getJShell() {
        assert (this.evaluator.isRequestProcessorThread());
        if (this.shell == null) {
            this.initJShell();
        }
        return this.shell;
    }

    public FileObject getConsoleFile() {
        return this.consoleFile;
    }

    public boolean isValid() {
        Launcher l = this.launcher;
        return l != null && l.isLive() && !this.detached;
    }

    public FileObject snippetFile(SnippetHandle snippet, int editedSnippetIndex) {
        if (this.launcher == null) {
            return null;
        }
        return this.snippetRegistry.snippetFile(snippet, editedSnippetIndex);
    }

    public synchronized JShellTool getJShellTool() {
        return this.launcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<ShellSession, Task> start() {
        ShellSession previous = null;
        Map<Document, Reference<ShellSession>> map = allSessions;
        synchronized (map) {
            Reference<ShellSession> sr = allSessions.get(this.env.getConsoleDocument());
            Object s = null;
            if (sr != null) {
                previous = sr.get();
            }
        }
        if (previous != null) {
            previous.detach();
            AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.asRequired((Document)this.consoleDocument, AtomicLockDocument.class);
            ald.runAtomic(() -> {
                try {
                    this.consoleDocument.remove(0, this.consoleDocument.getLength());
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
        }
        this.init(previous);
        try {
            this.refreshGuardedSection();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        map = allSessions;
        synchronized (map) {
            allSessions.put(this.consoleDocument, new WeakReference<ShellSession>(this));
        }
        GlobalPathRegistry.getDefault().register("classpath/source", new ClassPath[]{this.env.getSnippetClassPath()});
        GlobalPathRegistry.getDefault().register("classpath/compile", new ClassPath[]{this.env.getUserLibraryPath()});
        return Pair.of((Object)previous, (Object)this.evaluator.post(() -> ModelAccessor.INSTANCE.execute(this.model, false, () -> {
            try {
                URL url = URLMapper.findURL((FileObject)this.workRoot, (int)0);
                IndexingManager.getDefault().refreshIndexAndWait(url, null, true);
                this.getJShell();
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "Thrown error: ", ex);
                this.reportErrorMessage(ex);
            }
            finally {
                this.ensureInputSectionAvailable();
            }
        }, this::getPromptAfterError)));
    }

    public Writer getDocumentWriter() {
        return this.documentWriter;
    }

    private String addRoots(String prev, ClassPath cp) {
        if (cp == null) {
            return prev;
        }
        FileObject[] roots = cp.getRoots();
        StringBuilder sb = new StringBuilder(prev);
        for (FileObject r : roots) {
            File f;
            FileObject ar = FileUtil.getArchiveFile((FileObject)r);
            if (ar == null) {
                ar = r;
            }
            if ((f = FileUtil.toFile((FileObject)ar)) == null) continue;
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(f.getPath());
        }
        return sb.toString();
    }

    private void setupJShellClasspath(JShell jshell) throws ExecutionControl.ExecutionControlException {
        ClassPath compile = this.getEnv().getCompilerClasspath();
        String cp = this.addRoots("", compile);
        JShellAccessor.resetCompileClasspath(jshell, cp);
    }

    private String createProjectClasspath() {
        ClassPath compile = this.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
        ClassPath source = this.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
        String cp = this.addRoots("", compile);
        return cp;
    }

    private SpecificationVersion findSourceVersion() {
        return this.env.getSourceLevel();
    }

    private SpecificationVersion findTargetVersion() {
        return this.env.getTargetLevel();
    }

    private Preferences createShellPreferences() {
        Project p = this.env.getProject();
        if (p != null) {
            return ProjectUtils.getPreferences((Project)p, ShellSession.class, (boolean)false).node("jshell");
        }
        return NbPreferences.forModule(ShellSession.class).node("jshell");
    }

    private JShell.Builder customizeBuilder(JShell.Builder b) {
        SpecificationVersion v = this.findSourceVersion();
        if (v != null) {
            b.compilerOptions("-source", v.toString());
        }
        if ((v = this.findTargetVersion()) != null) {
            b.compilerOptions("-target", v.toString());
        }
        b.remoteVMOptions("-classpath", JShellLauncher.quote(this.createClasspathString()));
        ClasspathInfo cpI = this.getClasspathInfo();
        if (LOG.isLoggable(Level.FINEST)) {
            StringBuilder sb = new StringBuilder("Starting jshell with ClasspathInfo:");
            for (ClasspathInfo.PathKind kind : ClasspathInfo.PathKind.values()) {
                ClassPath cp;
                if (kind == ClasspathInfo.PathKind.OUTPUT) continue;
                sb.append(kind);
                sb.append(": ");
                try {
                    cp = cpI.getClassPath(kind);
                }
                catch (IllegalArgumentException ex) {
                    sb.append("<not supported>\n");
                    continue;
                }
                if (cp == null) {
                    sb.append("<null>\n");
                    continue;
                }
                sb.append("\n");
                for (ClassPath.Entry e : cp.entries()) {
                    sb.append("\t");
                    sb.append(e.getURL());
                    sb.append("\n");
                }
                sb.append("---------------\n");
                LOG.log(Level.FINEST, sb.toString());
            }
        }
        this.customizeBuilderOnJDK9(b);
        b.fileManager(this::createJShellFileManager);
        return this.getEnv().customizeJShell(b);
    }

    private Object createJShellFileManager(Object original) {
        if (original instanceof StandardJavaFileManager) {
            this.fileman = new SwitchingJavaFileManger(this.getClasspathInfo());
            return this.fileman;
        }
        return original;
    }

    private void customizeBuilderOnJDK9(JShell.Builder builder) {
        String classpath;
        try {
            Class<StandardJavaFileManager> c = JShell.Builder.class.getClassLoader().loadClass("javax.tools.StandardJavaFileManager");
            if (c.isAssignableFrom(StandardJavaFileManager.class)) {
                return;
            }
        }
        catch (ClassNotFoundException c) {
            // empty catch block
        }
        this.fileman = null;
        Project p = this.env.getProject();
        String systemHome = (String)this.platform.getSystemProperties().get("java.home");
        if (systemHome != null) {
            if (ShellProjectUtils.isModularJDK(this.platform)) {
                builder.compilerOptions("--system", systemHome);
            } else {
                builder.compilerOptions("--boot-class-path", this.getClasspathAsString(ClasspathInfo.PathKind.BOOT));
            }
        }
        JavaPlatform platform = ShellProjectUtils.findPlatform(p);
        String modulepath = "";
        if (p != null && ShellProjectUtils.isModularProject(p)) {
            List<String[]> opts = ShellProjectUtils.compilerPathOptions(p);
            for (String[] o : opts) {
                if (o[1] != null) {
                    builder.compilerOptions(o[0], o[1]);
                    continue;
                }
                builder.compilerOptions(o[0]);
            }
            modulepath = this.getClasspathAsString(ClasspathInfo.PathKind.MODULE_COMPILE);
            classpath = this.getClasspathAsString(ClasspathInfo.PathKind.MODULE_CLASS);
        } else {
            classpath = this.getClasspathAsString(ClasspathInfo.PathKind.COMPILE);
        }
        if (!classpath.isEmpty()) {
            builder.compilerOptions("-classpath", classpath);
        }
        if (!modulepath.isEmpty()) {
            builder.compilerOptions("--module-path", modulepath);
        }
    }

    private synchronized Launcher initShellLauncher() throws IOException {
        if (this.launcher != null) {
            return this.launcher;
        }
        try {
            this.launcher = new Launcher(this.env.createExecutionEnv());
        }
        catch (IOException | Error | RuntimeException e) {
            LOG.log(Level.INFO, null, e);
        }
        return this.launcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJShell() {
        if (this.shell != null) {
            return;
        }
        Launcher l = null;
        JShell shell = null;
        Object sub = null;
        try {
            this.initializing = true;
            l = this.initShellLauncher();
            shell = this.launcher.getJShell();
            this.launcher.start();
            this.initialSetupSnippets = new HashSet<Snippet>(shell.snippets().collect(Collectors.toList()));
        }
        catch (IOException | InternalError err) {
            Throwable t = err.getCause();
            if (t == null) {
                t = err;
            }
            this.reportErrorMessage(t);
            this.closed();
            this.env.notifyDisconnected(this, false);
            return;
        }
        finally {
            this.initializing = false;
            if (l != null && l.subscription != null && shell != null) {
                shell.unsubscribe(l.subscription);
            }
        }
    }

    public synchronized SnippetRegistry getSnippetRegistry() {
        return this.snippetRegistry;
    }

    private String buildErrorMessage(Throwable t) {
        String locMessage = t.getLocalizedMessage();
        if (locMessage == null) {
            locMessage = t.getClass().getName();
        }
        if (t.getCause() == t) {
            return Bundle.ERR_CannotInitializeShell(locMessage);
        }
        StringBuilder sb = new StringBuilder(Bundle.ERR_CannotInitializeShell(locMessage));
        while (t.getCause() != t && (t = t.getCause()) != null) {
            locMessage = t.getLocalizedMessage();
            if (locMessage == null) {
                locMessage = t.getClass().getName();
            }
            sb.append(Bundle.ERR_CannotInitializeBecause(t.getLocalizedMessage()));
        }
        return sb.toString();
    }

    private void ensureInputSectionAvailable() {
        ConsoleSection s = this.model.processInputSection(false);
        if (s != null) {
            return;
        }
        String promptText = "\n" + this.launcher.prompt(false);
        this.writeToShellDocument(promptText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClosed(JShellEnvironment env, boolean remote) {
        String s;
        ShellSession shellSession = this;
        synchronized (shellSession) {
            if (this.ignoreClose) {
                return;
            }
            this.ignoreClose = true;
        }
        if (this.initializing) {
            s = Bundle.MSG_JShellCannotStart();
        } else {
            if (!remote) {
                return;
            }
            s = env.isClosed() ? Bundle.MSG_JShellClosed() : Bundle.MSG_JShellDisconnected();
        }
        this.reportShellMessage(s);
    }

    public void reportErrorMessage(Throwable t) {
        LOG.log(Level.INFO, "Error in JSHell", t);
        this.reportShellMessage(this.buildErrorMessage(t));
    }

    private void reportShellMessage(String msg) {
        if (!this.isActive()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (!this.scrollbackEndsWithNewline()) {
            sb.append("\n");
        }
        sb.append("|  ");
        if (msg.endsWith("\n")) {
            msg = msg.substring(0, msg.length() - 1);
        }
        sb.append(msg.replace("\n", "\n|  "));
        sb.append("\n");
        this.writeToShellDocument(sb.toString());
    }

    private boolean scrollbackEndsWithNewline() {
        boolean[] ret = new boolean[1];
        ConsoleSection s = this.model.getInputSection();
        int end = s == null ? -1 : s.getStart();
        this.consoleDocument.render(() -> {
            int l = this.consoleDocument.getLength();
            if (l == 0) {
                ret[0] = true;
            } else {
                int e = end == -1 ? this.consoleDocument.getLength() : end;
                try {
                    ret[0] = this.consoleDocument.getText(e - 1, 1).charAt(0) == '\n';
                }
                catch (BadLocationException ex) {
                    ret[0] = false;
                }
            }
        });
        return ret[0];
    }

    private void writeToShellDocument(String text) {
        this.model.writeToShellDocument(text);
    }

    private String getClasspathAsString(ClasspathInfo.PathKind pk) {
        return this.addRoots("", this.getClasspathInfo().getClassPath(pk));
    }

    private String createClasspathString() {
        String sep = System.getProperty("path.separator");
        boolean modular = ShellProjectUtils.isModularJDK(this.platform);
        String agentJar = modular ? "modules/ext/nb-mod-jshell-probe.jar" : "modules/ext/nb-custom-jshell-probe.jar";
        File remoteProbeJar = InstalledFileLocator.getDefault().locate(agentJar, "org.netbeans.lib.jshell.agent", false);
        StringBuilder sb = new StringBuilder(remoteProbeJar.getAbsolutePath());
        if (!modular) {
            File toolsJar = null;
            for (FileObject jdkInstallDir : this.platform.getInstallFolders()) {
                FileObject toolsJarFO = jdkInstallDir.getFileObject("lib/tools.jar");
                if (toolsJarFO == null) {
                    toolsJarFO = jdkInstallDir.getFileObject("../lib/tools.jar");
                }
                if (toolsJarFO == null) continue;
                toolsJar = FileUtil.toFile((FileObject)toolsJarFO);
                break;
            }
            if (toolsJar != null) {
                sb.append(sep).append(toolsJar);
            }
        }
        ClassPath compile = this.getEnv().getVMClassPath();
        String projectCp = this.addRoots("", compile);
        sb.append(sep).append(projectCp);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closed() {
        ShellSession shellSession = this;
        synchronized (shellSession) {
            if (this.ignoreClose) {
                return;
            }
        }
        this.env.notifyDisconnected(this, false);
        this.propSupport.firePropertyChange("active", true, false);
        ShellHistory h = (ShellHistory)this.env.getLookup().lookup(ShellHistory.class);
        if (h != null) {
            this.saveInputSections(h);
        }
    }

    private void saveInputSections(ShellHistory history) {
        history.pushItems(this.historyItems());
    }

    private void closedDelayed() {
        FORCE_CLOSE_RP.post(() -> this.closed(), 300);
    }

    private synchronized void init(ShellSession prev) {
        ConsoleModel.initModel();
        this.evaluator = new RequestProcessor("Evaluator for " + this.displayName);
        this.initClasspath();
        this.model = ModelAccessor.INSTANCE.createModel((LineDocument)this.consoleDocument, this.evaluator, this.bridgeImpl);
        this.model.addConsoleListener(new LexerEmbeddingAdapter());
        this.model.addConsoleListener(new GuardedSectionUpdater());
        AbstractGuardedSectionsProvider hack = new AbstractGuardedSectionsProvider(new GuardedEditorSupport(){

            public StyledDocument getDocument() {
                return (StyledDocument)ShellSession.this.consoleDocument;
            }
        }){

            public char[] writeSections(List<GuardedSection> sections, char[] content) {
                return null;
            }

            public AbstractGuardedSectionsProvider.Result readSections(char[] content) {
                return null;
            }
        };
        hack.createGuardedReader((InputStream)new ByteArrayInputStream(new byte[0]), Charset.defaultCharset());
        this.gsm = GuardedSectionManager.getInstance((StyledDocument)((StyledDocument)this.consoleDocument));
        this.gsProvider = hack;
    }

    private void initClasspath() {
        ClasspathInfo.Builder bld = new ClasspathInfo.Builder(this.projectInfo.getClassPath(ClasspathInfo.PathKind.BOOT));
        ClassPath snippetSource = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.projectInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), ClassPathSupport.createClassPath((FileObject[])new FileObject[]{this.editorWorkRoot}), ClassPathSupport.createClassPath((FileObject[])new FileObject[]{this.workRoot})});
        ClassPath compileClasspath = this.projectInfo.getClassPath(ClasspathInfo.PathKind.COMPILE);
        ClassPath modBoot = this.projectInfo.getClassPath(ClasspathInfo.PathKind.MODULE_BOOT);
        ClassPath modClass = this.projectInfo.getClassPath(ClasspathInfo.PathKind.MODULE_CLASS);
        ClassPath modCompile = this.projectInfo.getClassPath(ClasspathInfo.PathKind.MODULE_COMPILE);
        bld.setClassPath(compileClasspath).setSourcePath(snippetSource).setModuleBootPath(modBoot).setModuleClassPath(modClass).setModuleCompilePath(modCompile);
        this.cpInfo = bld.build();
        this.consoleDocument.putProperty("java.classpathInfo", this.cpInfo);
    }

    public Document getConsoleDocument() {
        return this.consoleDocument;
    }

    public ClasspathInfo getClasspathInfo() {
        return this.cpInfo;
    }

    public JShell ensureShell() {
        this.initJShell();
        return this.shell;
    }

    public JShell getShell() {
        return this.shell;
    }

    public static ShellSession createSession(JShellEnvironment env) {
        return new ShellSession(env);
    }

    public static ShellSession get(FileObject f) {
        EditorCookie cake = (EditorCookie)f.getLookup().lookup(EditorCookie.class);
        if (cake == null) {
            return null;
        }
        StyledDocument d = cake.getDocument();
        if (d == null) {
            return null;
        }
        return ShellSession.get(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShellSession get(Document d) {
        if (d == null) {
            return null;
        }
        Map<Document, Reference<ShellSession>> map = allSessions;
        synchronized (map) {
            Reference<ShellSession> sr = allSessions.get(d);
            return sr == null ? null : sr.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ShellSession> allSessions() {
        Collection<Reference<ShellSession>> ll;
        Map<Document, Reference<ShellSession>> map = allSessions;
        synchronized (map) {
            ll = allSessions.values();
        }
        ArrayList<ShellSession> res = new ArrayList<ShellSession>(ll.size());
        for (Reference<ShellSession> sr : ll) {
            ShellSession s = sr.get();
            if (s == null) continue;
            res.add(s);
        }
        return res;
    }

    private void addNewline(int offset) {
        AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.asRequired((Document)this.consoleDocument, AtomicLockDocument.class);
        ald.runAtomic(() -> {
            try {
                DocumentUtilities.setTypingModification((Document)this.consoleDocument, (boolean)false);
                this.consoleDocument.insertString(offset, "\n", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        });
    }

    private void clearAndAddNewline(int offset) {
        AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.asRequired((Document)this.consoleDocument, AtomicLockDocument.class);
        ald.runAtomic(() -> {
            try {
                DocumentUtilities.setTypingModification((Document)this.consoleDocument, (boolean)false);
                this.consoleDocument.remove(offset, this.consoleDocument.getLength() - offset);
                this.consoleDocument.insertString(offset, "\n", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        });
    }

    public String getExecutionLabel() {
        return this.executionLabel;
    }

    public void evaluate(String command) throws IOException {
        this.evaluate(command, false, null);
    }

    public void clearInputAndEvaluateExternal(String command, String label) throws IOException {
        this.post(() -> {
            ConsoleSection s = this.model.processInputSection(true);
            if (s == null) {
                return;
            }
            this.clearAndAddNewline(s.getPartBegin());
            boolean saveSave = this.recordNoSave;
            try {
                this.recordNoSave = true;
                this.executionLabel = label;
                this.doExecuteCommands(command);
            }
            finally {
                this.executionLabel = null;
                this.recordNoSave = saveSave;
            }
        });
    }

    public void evaluate(String command, boolean excludeFromSave, String label) throws IOException {
        this.post(() -> {
            ConsoleSection s = this.model.processInputSection(true);
            if (s == null) {
                return;
            }
            String c = s.getContents(this.consoleDocument);
            if (!c.endsWith("\n")) {
                this.addNewline(s.getEnd());
            }
            boolean saveSave = this.recordNoSave;
            try {
                this.recordNoSave = excludeFromSave;
                this.executionLabel = label;
                this.doExecuteCommands(command);
            }
            finally {
                this.executionLabel = null;
                this.recordNoSave = saveSave;
            }
        });
    }

    private void doExecuteCommands(String cmd) {
        ConsoleSection sec = this.model.processInputSection(true);
        if (sec == null) {
            return;
        }
        ModelAccessor.INSTANCE.execute(this.model, cmd != null, () -> {
            Executor executor = new Executor(cmd, this.model.getExecutingSection());
            executor.execute();
        }, this::getPromptAfterError);
    }

    private String getPromptAfterError() {
        return this.launcher.prompt(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Task sendJShellClose() {
        RemoteJShellService e;
        ShellSession shellSession = this;
        synchronized (shellSession) {
            if (this.launcher == null) {
                return Task.EMPTY;
            }
            e = this.exec;
        }
        if (e != null) {
            e.requestShutdown();
        }
        return this.evaluator.post(() -> {
            try {
                this.launcher.closeState();
            }
            catch (InternalError internalError) {
                // empty catch block
            }
            this.forceCloseStreams();
        });
    }

    public Task closeSession() {
        return this.detach();
    }

    public ConsoleModel getModel() {
        return this.model;
    }

    private void refreshGuardedSection() throws BadLocationException {
        if (!this.isActive()) {
            return;
        }
        this.gsm.getGuardedSections().forEach(gs -> gs.removeSection());
        ConsoleSection s = this.model.getInputSection();
        LineDocument ld = (LineDocument)LineDocumentUtils.asRequired((Document)this.consoleDocument, LineDocument.class);
        if (s == null) {
            int l = this.consoleDocument.getLength() + 1;
            this.gsm.protectSimpleRegion(ld.createPosition(0, Position.Bias.Forward), ld.createPosition(l, Position.Bias.Forward), "scrollback");
        } else {
            int wr = s.getPartBegin() - 1;
            this.gsm.protectSimpleRegion(ld.createPosition(0, Position.Bias.Forward), ld.createPosition(wr, Position.Bias.Backward), "scrollback");
        }
    }

    public Task post(Runnable r) {
        return this.evaluator.post(r);
    }

    public List<Snippet> getSnippets(boolean onlyUser, boolean onlyValid) {
        Set<Snippet> initial = this.initialSetupSnippets;
        JShell sh = this.shell;
        if (sh == null) {
            return Collections.emptyList();
        }
        ArrayList<Snippet> snips = new ArrayList<Snippet>(sh.snippets().collect(Collectors.toList()));
        if (onlyUser) {
            snips.removeAll(initial);
            snips.removeAll(this.excludedSnippets);
        }
        if (onlyValid) {
            Iterator it = snips.iterator();
            while (it.hasNext()) {
                Snippet s = (Snippet)it.next();
                if (this.validSnippet(s)) continue;
                it.remove();
            }
        }
        return snips;
    }

    private boolean validSnippet(Snippet s) {
        Snippet.Status status = this.shell.status(s);
        return status != Snippet.Status.DROPPED && status != Snippet.Status.OVERWRITTEN && status != Snippet.Status.REJECTED;
    }

    public void stopExecutingCode() {
        JShell shell = this.shell;
        if (shell == null || !this.model.isExecute()) {
            return;
        }
        shell.stop();
    }

    public List<ShellHistory.Item> historyItems() {
        final ArrayList<ShellHistory.Item> historyLines = new ArrayList<ShellHistory.Item>();
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)this.getConsoleDocument())), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    ConsoleContents console = ConsoleContents.get(resultIterator);
                    ConsoleSection input = console.getInputSection();
                    ConsoleSection exec = console.getSectionModel().getExecutingSection();
                    for (ConsoleSection s : console.getSectionModel().getSections()) {
                        Snippet.Kind sectionKind;
                        boolean command;
                        String contents;
                        if (!s.getType().input || s == input || s == exec || (contents = s.getContents(ShellSession.this.consoleDocument)).startsWith("/") && contents.length() > 2 && (contents.charAt(1) == '-' || Character.isDigit(contents.charAt(1)))) continue;
                        List<SnippetHandle> handles = console.getHandles(s);
                        if (s.getType() == ConsoleSection.Type.COMMAND) {
                            command = true;
                            sectionKind = null;
                        } else {
                            command = false;
                            sectionKind = handles.isEmpty() ? Snippet.Kind.ERRONEOUS : handles.get(0).getKind();
                        }
                        contents = contents.trim();
                        if (contents.isEmpty()) continue;
                        historyLines.add(new ShellHistory.Item(sectionKind, command, contents));
                    }
                }
            });
        }
        catch (ParseException ex) {
            return Collections.emptyList();
        }
        return historyLines;
    }

    public Path resolvePath(String s) {
        return this.launcher == null ? Paths.get(s, new String[0]) : this.launcher.toPathResolvingUserHome(s);
    }

    private class GuardedSectionUpdater
    implements ConsoleListener {
        private GuardedSectionUpdater() {
        }

        @Override
        public void sectionCreated(ConsoleEvent e) {
            List<ConsoleSection> aff = e.getAffectedSections();
            for (ConsoleSection s : aff) {
                if (s != ShellSession.this.model.getLastInputSection()) continue;
                this.refresh();
            }
        }

        private void refresh() {
            try {
                ShellSession.this.refreshGuardedSection();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void sectionUpdated(ConsoleEvent e) {
            for (ConsoleSection s : e.getAffectedSections()) {
                if (s != ShellSession.this.model.getLastInputSection()) continue;
                this.refresh();
                break;
            }
        }

        @Override
        public void executing(ConsoleEvent e) {
        }

        @Override
        public void closed(ConsoleEvent e) {
        }
    }

    private class Executor
    implements Runnable,
    Consumer<SnippetEvent> {
        private final String cmd;
        private final ConsoleSection exec;
        private final List<String> toExec = new ArrayList<String>();
        private boolean erroneous;
        private int execOffset;

        public Executor(String cmd, ConsoleSection exec) {
            this.cmd = cmd;
            this.exec = exec;
        }

        private boolean isExternal() {
            return this.cmd != null;
        }

        @Override
        public void accept(SnippetEvent e) {
            switch (e.status()) {
                case REJECTED: {
                    this.erroneous = true;
                }
                case VALID: 
                case RECOVERABLE_DEFINED: 
                case RECOVERABLE_NOT_DEFINED: 
                case NONEXISTENT: {
                    if (ShellSession.this.recordNoSave) {
                        ShellSession.this.excludedSnippets.add(e.snippet());
                    }
                    SnippetHandle handle = this.isExternal() ? ShellSession.this.snippetRegistry.installSnippet(e.snippet(), null, 0, true) : ShellSession.this.snippetRegistry.installSnippet(e.snippet(), this.exec, this.execOffset, false);
                    ShellSession.this.snippetRegistry.snippetFile(handle, 0);
                }
            }
        }

        @Override
        public void run() {
            if (this.exec.getType() == ConsoleSection.Type.COMMAND) {
                this.toExec.add(this.exec.getContents(ShellSession.this.consoleDocument));
            } else {
                for (Rng r : this.exec.getAllSnippetBounds()) {
                    this.toExec.add(this.exec.getRangeContents(ShellSession.this.consoleDocument, r));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute() {
            if (this.cmd != null) {
                this.toExec.add(this.cmd);
            } else {
                ShellSession.this.consoleDocument.render(this);
            }
            if (this.toExec.isEmpty()) {
                return;
            }
            Rng[] ranges = this.cmd == null ? this.exec.getAllSnippetBounds() : null;
            int index = 0;
            this.execOffset = 0;
            JShell.Subscription sub = null;
            JShell sh = null;
            try {
                for (String s : this.toExec) {
                    String t;
                    ShellSession.this.launcher.ensureLive();
                    if (!ShellSession.this.launcher.isLive()) {
                        ExecutionControl.ExecutionControlException ee;
                        RemoteJShellService ec = ShellSession.this.exec;
                        if (ec != null && (ee = ec.getBrokenException()) != null) {
                            throw ee;
                        }
                        break;
                    }
                    sh = ShellSession.this.launcher.getJShell();
                    if (sub == null && !(t = s.trim()).isEmpty() && t.charAt(0) != '/') {
                        sub = sh.onSnippetEvent(this);
                    }
                    if (ranges != null) {
                        this.execOffset = this.exec.offsetToContents(ranges[index].start, true);
                    }
                    ShellSession.this.launcher.evaluate(s, index == this.toExec.size() - 1);
                    if (this.erroneous) {
                        break;
                    }
                    ++index;
                }
            }
            catch (IllegalStateException | ExecutionControl.ExecutionControlException ex) {
                ShellSession.this.reportShellMessage(Bundle.MSG_JShellCannotExecute());
            }
            catch (IOException | RuntimeException ex) {
                ShellSession.this.reportErrorMessage(ex);
                ShellSession.this.reportShellMessage(Bundle.MSG_ErrorExecutingCommand());
            }
            finally {
                if (sh != null && sub != null) {
                    sh.unsubscribe(sub);
                }
                ShellSession.this.ensureInputSectionAvailable();
            }
        }
    }

    private class Launcher
    extends JShellLauncher
    implements Consumer<SnippetEvent> {
        JShell.Subscription subscription;

        public Launcher(ExecutionControlProvider execEnv) throws IOException {
            super(ShellSession.this.createShellPreferences(), ShellSession.this.shellControlOutput, ShellSession.this.shellControlOutput, ShellSession.this.env.getInputStream(), ShellSession.this.env.getOutputStream(), ShellSession.this.env.getErrorStream(), execEnv);
        }

        @Override
        protected List<String> historyItems() {
            return ShellSession.this.historyItems().stream().map(i -> i.getContents()).collect(Collectors.toList());
        }

        @Override
        protected JShell.Builder makeBuilder() {
            return ShellSession.this.customizeBuilder(super.makeBuilder());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected JShell createJShellInstance() {
            JShell shell = super.createJShellInstance();
            try {
                ShellSession.this.setupJShellClasspath(shell);
            }
            catch (ExecutionControl.ExecutionControlException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            ShellSession shellSession = ShellSession.this;
            synchronized (shellSession) {
                ShellSession.this.snippetRegistry = new SnippetRegistry(shell, ShellSession.this.bridgeImpl, ShellSession.this.workRoot, ShellSession.this.editorWorkRoot, ShellSession.this.snippetRegistry);
                JShell oldShell = ShellSession.this.shell;
                ShellSession.this.shell = shell;
                if (oldShell != null) {
                    FORCE_CLOSE_RP.post(() -> ShellSession.this.propSupport.firePropertyChange("active", oldShell, shell));
                }
            }
            this.subscription = shell.onSnippetEvent(this);
            if (!ShellSession.this.detached) {
                shell.onShutdown(sh -> ShellSession.this.closedDelayed());
                ShellSession.this.ignoreClose = false;
            }
            return shell;
        }

        @Override
        public void accept(SnippetEvent e) {
            SnippetHandle handle = ShellSession.this.snippetRegistry.installSnippet(e.snippet(), null, 0, true);
            ShellSession.this.snippetRegistry.snippetFile(handle, 0);
        }

        @Override
        protected void classpathAdded(String arg) {
            super.classpathAdded(arg);
            File f = new File(arg);
            FileObject fob = FileUtil.toFileObject((File)f);
            if (fob != null) {
                ShellSession.this.env.appendClassPath(fob);
            }
        }

        @Override
        protected Path toPathResolvingUserHome(String pathString) {
            Project p;
            Path homeResolvedPath = super.toPathResolvingUserHome(pathString);
            if (!homeResolvedPath.isAbsolute() && (p = ShellSession.this.env.getProject()) != null) {
                File f = FileUtil.toFile((FileObject)p.getProjectDirectory());
                if (f == null) {
                    return homeResolvedPath;
                }
                Path projectPath = f.toPath();
                return projectPath.resolve(homeResolvedPath);
            }
            return homeResolvedPath;
        }

        @Override
        protected NbExecutionControl execControlCreated(NbExecutionControl ctrl) {
            if (ctrl instanceof RemoteJShellService) {
                ShellSession.this.exec = (RemoteJShellService)((Object)ctrl);
            }
            return super.execControlCreated(ctrl);
        }
    }

    private static class WriterOutputStream
    extends OutputStream {
        private boolean writeImmediately = true;
        private final CharsetDecoder decoder;
        private final ByteBuffer decoderIn = ByteBuffer.allocate(128);
        private final CharBuffer decoderOut;
        private final Writer writer;

        public WriterOutputStream(Writer out) {
            this.writer = out;
            this.decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?");
            this.decoderOut = CharBuffer.allocate(2048);
        }

        @Override
        public void write(int b) throws IOException {
            this.decoderIn.put((byte)b);
            this.processInput(false);
            if (this.writeImmediately) {
                this.flushOutput();
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            while (len > 0) {
                int c = Math.min(len, this.decoderIn.remaining());
                this.decoderIn.put(b, off, c);
                this.processInput(false);
                len -= c;
                off += c;
            }
            if (this.writeImmediately) {
                this.flushOutput();
            }
        }

        private void flushOutput() throws IOException {
            if (this.decoderOut.position() > 0) {
                this.writer.write(this.decoderOut.array(), 0, this.decoderOut.position());
                this.decoderOut.rewind();
            }
        }

        @Override
        public void close() throws IOException {
            this.processInput(true);
            this.flushOutput();
            this.writer.close();
        }

        @Override
        public void flush() throws IOException {
            this.flushOutput();
            this.writer.flush();
        }

        private void processInput(boolean endOfInput) throws IOException {
            CoderResult coderResult;
            this.decoderIn.flip();
            while ((coderResult = this.decoder.decode(this.decoderIn, this.decoderOut, endOfInput)).isOverflow()) {
                this.flushOutput();
            }
            if (!coderResult.isUnderflow()) {
                throw new IOException("Unexpected coder result");
            }
            this.decoderIn.compact();
        }
    }

    private class DocumentOutput
    extends Writer {
        private Throwable exception;

        private DocumentOutput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (!ShellSession.this.isActive()) {
                return;
            }
            AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.asRequired((Document)ShellSession.this.consoleDocument, AtomicLockDocument.class);
            try {
                ald.runAtomic(() -> {
                    try {
                        int offset = ShellSession.this.consoleDocument.getLength();
                        ShellSession.this.model.insertResponseString(offset, String.copyValueOf(cbuf, off, len), null);
                    }
                    catch (BadLocationException ex) {
                        this.exception = ex;
                    }
                });
                if (this.exception != null) {
                    throw new IOException(this.exception);
                }
            }
            finally {
                this.exception = null;
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

