/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.parsing;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.modules.jshell.model.ConsoleContents;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.jshell.model.SnippetHandle;
import org.netbeans.modules.jshell.parsing.ModelAccessor;
import org.netbeans.modules.jshell.parsing.SnippetRegistry;
import org.netbeans.modules.jshell.support.ShellSession;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserFactory;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;

public final class ConsoleMainParser
extends Parser {
    private static final Reference<ConsoleContents> NONE = new WeakReference<Object>(null);
    private volatile Reference<ConsoleContents> result = NONE;

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        Document d = snapshot.getSource().getDocument(false);
        if (d == null) {
            return;
        }
        ShellSession ss = ShellSession.get(d);
        if (ss == null) {
            return;
        }
        ConsoleContents cc = this.buildConsoleContents(ss, snapshot);
        if (cc != null) {
            this.result = new SoftReference<ConsoleContents>(cc);
        }
    }

    public void cancel(Parser.CancelReason reason, SourceModificationEvent event) {
        if (event == null || event.sourceChanged()) {
            this.result = NONE;
        }
    }

    public Parser.Result getResult(Task task) throws ParseException {
        return this.result.get();
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private void installSectionSnippets(SnippetRegistry reg, ConsoleContents contents, ConsoleSection s, Snapshot snapshot, boolean terminated) {
        if (s == null) {
            return;
        }
        if (!s.getType().java) {
            return;
        }
        List<SnippetHandle> handles = reg.createSnippets(s, snapshot.getText(), !terminated);
        ModelAccessor.INSTANCE.installSnippets(contents, s, handles);
    }

    private ConsoleContents buildConsoleContents(ShellSession session, Snapshot snapshot) {
        ConsoleContents c = ModelAccessor.INSTANCE.copyModel(session, session.getModel(), snapshot);
        Document doc = snapshot.getSource().getDocument(false);
        if (doc == null) {
            return null;
        }
        SnippetRegistry reg = session.getSnippetRegistry();
        if (reg == null) {
            return null;
        }
        ConsoleSection input = c.getSectionModel().getInputSection();
        ConsoleSection executing = c.getSectionModel().getExecutingSection();
        for (ConsoleSection s : c.getSectionModel().getSections()) {
            if (s == executing || s == input) continue;
            this.installSectionSnippets(reg, c, s, snapshot, true);
        }
        this.installSectionSnippets(reg, c, executing, snapshot, true);
        if (input != executing) {
            this.installSectionSnippets(reg, c, input, snapshot, false);
        }
        return c;
    }

    public static class F
    extends ParserFactory {
        public Parser createParser(Collection<Snapshot> snapshots) {
            return new ConsoleMainParser();
        }
    }
}

