/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.Tree;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import javax.lang.model.element.ElementKind;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.java.source.CompilationInfo;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.Places;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class Utils {
    public static SymbolKind elementKind2SymbolKind(ElementKind kind) {
        switch (kind) {
            case PACKAGE: {
                return SymbolKind.Package;
            }
            case ENUM: {
                return SymbolKind.Enum;
            }
            case CLASS: {
                return SymbolKind.Class;
            }
            case ANNOTATION_TYPE: {
                return SymbolKind.Interface;
            }
            case INTERFACE: {
                return SymbolKind.Interface;
            }
            case ENUM_CONSTANT: {
                return SymbolKind.EnumMember;
            }
            case FIELD: {
                return SymbolKind.Field;
            }
            case PARAMETER: {
                return SymbolKind.Variable;
            }
            case LOCAL_VARIABLE: {
                return SymbolKind.Variable;
            }
            case EXCEPTION_PARAMETER: {
                return SymbolKind.Variable;
            }
            case METHOD: {
                return SymbolKind.Method;
            }
            case CONSTRUCTOR: {
                return SymbolKind.Constructor;
            }
            case TYPE_PARAMETER: {
                return SymbolKind.TypeParameter;
            }
            case RESOURCE_VARIABLE: {
                return SymbolKind.Variable;
            }
            case MODULE: {
                return SymbolKind.Module;
            }
        }
        return SymbolKind.File;
    }

    public static Range treeRange(CompilationInfo info, Tree tree) {
        long start = info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), tree);
        long end = info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), tree);
        if (end == -1L) {
            end = start;
        }
        return new Range(Utils.createPosition(info.getCompilationUnit(), (int)start), Utils.createPosition(info.getCompilationUnit(), (int)end));
    }

    public static Position createPosition(CompilationUnitTree cut, int offset) {
        return Utils.createPosition(cut.getLineMap(), offset);
    }

    public static Position createPosition(LineMap lm, int offset) {
        return new Position((int)lm.getLineNumber(offset) - 1, (int)lm.getColumnNumber(offset) - 1);
    }

    public static Position createPosition(FileObject file, int offset) {
        try {
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
            int column = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
            return new Position(line, column);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static int getOffset(Document doc, Position pos) {
        return LineDocumentUtils.getLineStartFromIndex((LineDocument)((LineDocument)doc), (int)pos.getLine()) + pos.getCharacter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized String toUri(FileObject file) {
        Throwable throwable;
        if (!FileUtil.isArchiveArtifact((FileObject)file)) return file.toURI().toString();
        File cacheDir = Utils.getCacheDir();
        cacheDir.mkdirs();
        File segments = new File(cacheDir, "segments");
        Properties props = new Properties();
        try (FileInputStream in2222 = new FileInputStream(segments);){
            props.load(in2222);
        }
        catch (IOException in2222) {
            // empty catch block
        }
        FileObject archive = FileUtil.getArchiveFile((FileObject)file);
        String archiveString = archive.toURL().toString();
        File foundSegment = null;
        for (String segment : props.stringPropertyNames()) {
            if (!archiveString.equals(props.getProperty(segment))) continue;
            foundSegment = new File(cacheDir, segment);
            break;
        }
        if (foundSegment == null) {
            int i = 0;
            while (props.getProperty("s" + i) != null) {
                ++i;
            }
            foundSegment = new File(cacheDir, "s" + i);
            props.put("s" + i, archiveString);
            try {
                throwable = null;
                try (FileOutputStream in = new FileOutputStream(segments);){
                    props.store(in, "");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        File cache = new File(foundSegment, FileUtil.getRelativePath((FileObject)FileUtil.getArchiveRoot((FileObject)archive), (FileObject)file));
        cache.getParentFile().mkdirs();
        try {
            throwable = null;
            try (FileOutputStream out = new FileOutputStream(cache);){
                ((OutputStream)out).write(file.asBytes());
                String string = cache.toURI().toString();
                return string;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return file.toURI().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized FileObject fromUri(String uri) throws MalformedURLException {
        File cacheDir = Utils.getCacheDir();
        URI uriUri = URI.create(uri);
        URI relative = cacheDir.toURI().relativize(uriUri);
        if (relative == null) return URLMapper.findFileObject((URL)URI.create(uri).toURL());
        if (!new File(cacheDir, relative.toString()).canRead()) return URLMapper.findFileObject((URL)URI.create(uri).toURL());
        String segmentAndPath = relative.toString();
        int slash = segmentAndPath.indexOf(47);
        String segment = segmentAndPath.substring(0, slash);
        String path = segmentAndPath.substring(slash + 1);
        File segments = new File(cacheDir, "segments");
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(segments);){
            props.load(in);
            String archiveUri = props.getProperty(segment);
            FileObject archive = URLMapper.findFileObject((URL)URI.create(archiveUri).toURL());
            archive = archive != null ? FileUtil.getArchiveRoot((FileObject)archive) : null;
            FileObject file = archive != null ? archive.getFileObject(path) : null;
            if (file == null) return URLMapper.findFileObject((URL)URI.create(uri).toURL());
            FileObject fileObject = file;
            return fileObject;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return URLMapper.findFileObject((URL)URI.create(uri).toURL());
    }

    private static File getCacheDir() {
        return Places.getCacheSubfile((String)"java-server");
    }
}

