/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.hints;

import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.ClassNode;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.PropertyNode;
import com.oracle.js.parser.ir.UnaryNode;
import com.oracle.js.parser.ir.VarNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.javascript2.editor.JsPreferences;
import org.netbeans.modules.javascript2.editor.JsVersion;
import org.netbeans.modules.javascript2.editor.hints.Bundle;
import org.netbeans.modules.javascript2.editor.hints.EcmaLevelRule;
import org.netbeans.modules.javascript2.editor.hints.JsHintsProvider;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.model.spi.PathNodeVisitor;
import org.netbeans.modules.javascript2.types.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class Ecma6Rule
extends EcmaLevelRule {
    private static final List<JsTokenId> ECMA6LIST = Arrays.asList(JsTokenId.TEMPLATE_BEGIN, JsTokenId.TEMPLATE, JsTokenId.TEMPLATE_END, JsTokenId.TEMPLATE_EXP_BEGIN, JsTokenId.TEMPLATE_EXP_END, JsTokenId.KEYWORD_EXPORT, JsTokenId.KEYWORD_IMPORT);

    @Override
    void computeHints(JsHintsProvider.JsRuleContext context, List<Hint> hints, int offset, HintsProvider.HintsManager manager) throws BadLocationException {
        if (JsPreferences.isPreECMAScript6(FileOwnerQuery.getOwner((FileObject)context.getJsParserResult().getSnapshot().getSource().getFileObject()))) {
            Snapshot snapshot = context.getJsParserResult().getSnapshot();
            TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)snapshot, (int)context.lexOffset);
            if (ts != null) {
                while (ts.moveNext()) {
                    Token token = LexUtilities.findNextIncluding((TokenSequence)ts, ECMA6LIST);
                    if (token == null || token.length() < 1 || !ECMA6LIST.contains(token.id())) continue;
                    OffsetRange returnOffsetRange = new OffsetRange(ts.offset(), ts.offset() + token.length());
                    this.addHint(context, hints, returnOffsetRange);
                }
            }
            Ecma6Visitor visitor = new Ecma6Visitor();
            visitor.process(context, hints);
        }
    }

    private void addHint(JsHintsProvider.JsRuleContext context, List<Hint> hints, OffsetRange range) {
        this.addDocumenHint(context, hints, ModelUtils.documentOffsetRange((ParserResult)context.getJsParserResult(), (int)range.getStart(), (int)range.getEnd()));
    }

    private void addDocumenHint(JsHintsProvider.JsRuleContext context, List<Hint> hints, OffsetRange range) {
        hints.add(new Hint((Rule)this, Bundle.Ecma6Desc(), context.getJsParserResult().getSnapshot().getSource().getFileObject(), range, Collections.singletonList(new SwitchToEcma6Fix(context.getJsParserResult().getSnapshot())), 600));
    }

    public Set<?> getKinds() {
        return Collections.singleton("js.other.hints");
    }

    public String getId() {
        return "ecma6.hint";
    }

    public String getDescription() {
        return Bundle.Ecma6Desc();
    }

    public String getDisplayName() {
        return Bundle.Ecma6DisplayName();
    }

    private static final class SwitchToEcma6Fix
    implements HintFix {
        private final FileObject fo;

        public SwitchToEcma6Fix(Snapshot snapshot) {
            this.fo = snapshot.getSource().getFileObject();
        }

        public String getDescription() {
            return Bundle.MSG_SwitchToEcma6();
        }

        public void implement() throws Exception {
            if (this.fo == null) {
                return;
            }
            Project p = FileOwnerQuery.getOwner((FileObject)this.fo);
            if (p != null) {
                JsPreferences.putECMAScriptVersion(p, JsVersion.ECMA6);
            }
            EcmaLevelRule.refresh(this.fo);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private class Ecma6Visitor
    extends PathNodeVisitor {
        private List<Hint> hints;
        private JsHintsProvider.JsRuleContext context;

        private Ecma6Visitor() {
        }

        public void process(JsHintsProvider.JsRuleContext context, List<Hint> hints) {
            this.hints = hints;
            this.context = context;
            FunctionNode root = context.getJsParserResult().getRoot();
            if (root != null) {
                context.getJsParserResult().getRoot().accept((NodeVisitor)this);
            }
        }

        public boolean enterFunctionNode(FunctionNode functionNode) {
            if (functionNode.getKind() == FunctionNode.Kind.ARROW) {
                Ecma6Rule.this.addHint(this.context, this.hints, new OffsetRange(com.oracle.js.parser.Token.descPosition((long)functionNode.getFirstToken()), functionNode.getFinish()));
            }
            if (functionNode.getKind() == FunctionNode.Kind.NORMAL) {
                for (IdentNode param : functionNode.getParameters()) {
                    if (!param.isDefaultParameter() && !param.isRestParameter()) continue;
                    Ecma6Rule.this.addHint(this.context, this.hints, new OffsetRange(param.getStart(), param.getFinish()));
                }
            }
            return super.enterFunctionNode(functionNode);
        }

        public boolean enterClassNode(ClassNode classNode) {
            int headEnd = this.findToken(classNode.getStart(), JsTokenId.BRACKET_LEFT_CURLY);
            Ecma6Rule.this.addHint(this.context, this.hints, new OffsetRange(classNode.getStart(), headEnd));
            return super.enterClassNode(classNode);
        }

        public boolean enterVarNode(VarNode varNode) {
            long token = varNode.getToken();
            TokenType type = com.oracle.js.parser.Token.descType((long)token);
            if (TokenType.LET == type || TokenType.CONST == type) {
                Ecma6Rule.this.addHint(this.context, this.hints, new OffsetRange(varNode.getStart(), varNode.getFinish()));
            }
            return super.enterVarNode(varNode);
        }

        public boolean enterLiteralNode(LiteralNode literalNode) {
            if (literalNode instanceof LiteralNode.ArrayLiteralNode && ((LiteralNode.ArrayLiteralNode)literalNode).hasSpread()) {
                Ecma6Rule.this.addHint(this.context, this.hints, new OffsetRange(literalNode.getStart(), literalNode.getFinish()));
            }
            return super.enterLiteralNode(literalNode);
        }

        public boolean enterPropertyNode(PropertyNode propertyNode) {
            if (propertyNode.isComputed()) {
                Ecma6Rule.this.addHint(this.context, this.hints, new OffsetRange(propertyNode.getStart(), propertyNode.getFinish()));
            }
            return super.enterPropertyNode(propertyNode);
        }

        public boolean enterUnaryNode(UnaryNode unaryNode) {
            if (unaryNode.isTokenType(TokenType.AWAIT) || unaryNode.isTokenType(TokenType.YIELD)) {
                long token = unaryNode.getToken();
                int position = com.oracle.js.parser.Token.descPosition((long)token);
                Ecma6Rule.this.addHint(this.context, this.hints, new OffsetRange(position, position + com.oracle.js.parser.Token.descLength((long)token)));
            }
            return super.enterUnaryNode(unaryNode);
        }

        private int findToken(int offset, JsTokenId tokenId) {
            TokenSequence ts;
            int fileOffset = this.context.parserResult.getSnapshot().getOriginalOffset(offset);
            if (fileOffset >= 0 && (ts = LexUtilities.getPositionedSequence((Snapshot)this.context.parserResult.getSnapshot(), (int)offset, (Language)JsTokenId.javascriptLanguage())) != null) {
                while (ts.moveNext()) {
                    Token prev;
                    Token next = LexUtilities.findNextNonWsNonComment((TokenSequence)ts);
                    if (next == null || next.id() != tokenId || (prev = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT, JsTokenId.DOC_COMMENT, tokenId))) == null) continue;
                    return ts.offset() + prev.length();
                }
            }
            return -1;
        }
    }
}

