/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.LocationFactory;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.Debug;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.ObjectStorageOptions;
import com.oracle.truffle.object.PropertyMap;
import com.oracle.truffle.object.ShapeImpl;
import java.util.Iterator;

@ExportLibrary(value=DynamicDispatchLibrary.class)
public abstract class DynamicObjectImpl
extends DynamicObject
implements Cloneable {
    protected DynamicObjectImpl(Shape shape) {
        super(shape.getRoot(), LayoutImpl.ACCESS);
        this.initialize(shape);
        this.setShapeImpl(shape);
        if (ObjectStorageOptions.Profile) {
            Debug.trackObject(this);
        }
    }

    final ShapeImpl getShapeImpl() {
        return (ShapeImpl)this.getShape();
    }

    private void setShapeImpl(Shape shape) {
        assert (shape instanceof ShapeImpl);
        LayoutImpl.ACCESS.setShape(this, shape);
    }

    protected abstract void initialize(Shape var1);

    public final void setShapeAndResize(Shape newShape) {
        this.setShapeAndResize(this.getShape(), newShape);
    }

    @Override
    public final void setShapeAndResize(Shape oldShape, Shape newShape) {
        assert (this.getShape() == oldShape) : "wrong old shape";
        assert (!oldShape.isShared());
        if (oldShape != newShape) {
            this.resizeStore(oldShape, newShape);
            this.setShapeImpl(newShape);
            assert (this.checkExtensionArrayInvariants(newShape));
        }
    }

    @Override
    public final void setShapeAndGrow(Shape oldShape, Shape newShape) {
        assert (this.getShape() == oldShape) : "wrong old shape";
        if (oldShape != newShape) {
            assert (this.checkSetShape(oldShape, newShape));
            this.growStore(oldShape, newShape);
            this.setShapeImpl(newShape);
            assert (this.checkExtensionArrayInvariants(newShape));
        }
    }

    private void growStore(Shape oldShape, Shape newShape) {
        this.growObjectStore(oldShape, newShape);
        if (((ShapeImpl)newShape).hasPrimitiveArray) {
            this.growPrimitiveStore(oldShape, newShape);
        }
    }

    protected abstract void growObjectStore(Shape var1, Shape var2);

    protected abstract void growPrimitiveStore(Shape var1, Shape var2);

    protected void resizeStore(Shape oldShape, Shape newShape) {
        this.resizeObjectStore(oldShape, newShape);
        if (((ShapeImpl)newShape).hasPrimitiveArray) {
            this.resizePrimitiveStore(oldShape, newShape);
        }
    }

    protected abstract void resizePrimitiveStore(Shape var1, Shape var2);

    protected abstract void resizeObjectStore(Shape var1, Shape var2);

    private boolean checkSetShape(Shape oldShape, Shape newShape) {
        Shape currentShape = this.getShape();
        assert (oldShape != newShape) : "Wrong old shape assumption?";
        assert (newShape != currentShape) : "Redundant shape change? shape=" + currentShape;
        return true;
    }

    protected abstract boolean checkExtensionArrayInvariants(Shape var1);

    @Override
    protected final DynamicObject clone() {
        return LayoutImpl.ACCESS.objectClone(this);
    }

    protected abstract DynamicObject cloneWithShape(Shape var1);

    protected abstract void reshape(ShapeImpl var1);

    public final void copyProperties(DynamicObject fromObject, Shape ancestor) {
        this.copyProperties(fromObject);
    }

    private void copyProperties(DynamicObject fromObject) {
        ShapeImpl fromShape = (ShapeImpl)fromObject.getShape();
        ShapeImpl toShape = this.getShapeImpl();
        assert (toShape.isRelated(fromShape));
        assert (toShape.isValid());
        assert (!fromShape.isShared());
        PropertyMap fromMap = fromShape.getPropertyMap();
        Iterator<Property> toMapIt = toShape.getPropertyMap().reverseOrderedValueIterator();
        while (toMapIt.hasNext()) {
            Property toProperty = toMapIt.next();
            Property fromProperty = (Property)fromMap.get(toProperty.getKey());
            if (toProperty.getLocation().isValue() || toProperty.getLocation().equals(fromProperty.getLocation())) continue;
            toProperty.setInternal(this, fromProperty.get(fromObject, false));
            assert (toShape.isValid());
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean changeFlags(Object key, int newFlags) {
        Shape oldShape = this.getShape();
        Property existing = oldShape.getProperty(key);
        if (existing != null) {
            if (existing.getFlags() != newFlags) {
                Property newProperty = existing.copyWithFlags(newFlags);
                Shape newShape = oldShape.replaceProperty(existing, newProperty);
                this.setShapeImpl(newShape);
            }
            return true;
        }
        return false;
    }

    public String debugDump(int level) {
        return this.debugDump(0, level);
    }

    public String debugDump(int level, int levelStop) {
        return Debug.dumpObject(this, level, levelStop);
    }

    public String toString() {
        return this.getShape().getObjectType().toString(this);
    }

    public boolean equals(Object obj) {
        return this.getShape().getObjectType().equals(this, obj);
    }

    public int hashCode() {
        return this.getShape().getObjectType().hashCode(this);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object get(Object key, Object defaultValue) {
        Property existing = this.getShape().getProperty(key);
        if (existing != null) {
            return existing.get((DynamicObject)this, false);
        }
        return defaultValue;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(Object key, Object value) {
        Property existing = this.getShape().getProperty(key);
        if (existing != null) {
            existing.setGeneric(this, value, null);
            return true;
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void define(Object key, Object value, int flags) {
        this.define(key, value, flags, this.getShapeImpl().getLayout().getStrategy().getDefaultLocationFactory());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void define(Object key, Object value, int flags, LocationFactory locationFactory) {
        ShapeImpl oldShape = this.getShapeImpl();
        oldShape.getLayout().getStrategy().objectDefineProperty(this, key, value, flags, locationFactory, oldShape);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(Object key) {
        ShapeImpl oldShape = this.getShapeImpl();
        Property existing = oldShape.getProperty(key);
        if (existing != null) {
            oldShape.getLayout().getStrategy().objectRemoveProperty(this, existing, oldShape);
            return true;
        }
        return false;
    }

    @Override
    public final boolean updateShape() {
        return this.getShapeImpl().getLayout().getStrategy().updateShape(this);
    }

    @Override
    public final DynamicObject copy(Shape currentShape) {
        return this.cloneWithShape(currentShape);
    }

    @ExportMessage
    static class Dispatch {
        Dispatch() {
        }

        @Specialization(limit="1", guards={"cachedShape == receiver.getShape()"})
        static Class<?> doCachedShape(DynamicObjectImpl receiver, @Cached.Shared(value="cachedShape") @Cached(value="receiver.getShape()") Shape cachedShape, @Cached.Shared(value="cachedTypeClass") @Cached(value="receiver.getShape().getObjectType().getClass()", allowUncached=true) Class<? extends ObjectType> typeClass) {
            return cachedShape.getObjectType().dispatch();
        }

        @Specialization(replaces={"doCachedShape"})
        static Class<?> doCachedTypeClass(DynamicObjectImpl receiver, @Cached.Shared(value="cachedTypeClass") @Cached(value="receiver.getShape().getObjectType().getClass()", allowUncached=true) Class<? extends ObjectType> typeClass) {
            ObjectType objectType = CompilerDirectives.castExact(receiver.getShape().getObjectType(), typeClass);
            return objectType.dispatch();
        }
    }

    @ExportMessage
    static class Accepts {
        Accepts() {
        }

        @Specialization(limit="1", guards={"cachedShape == receiver.getShape()"})
        static boolean doCachedShape(DynamicObjectImpl receiver, @Cached.Shared(value="cachedShape") @Cached(value="receiver.getShape()") Shape cachedShape, @Cached.Shared(value="cachedTypeClass") @Cached(value="receiver.getShape().getObjectType().getClass()", allowUncached=true) Class<? extends ObjectType> typeClass) {
            return true;
        }

        @Specialization(replaces={"doCachedShape"})
        static boolean doCachedTypeClass(DynamicObjectImpl receiver, @Cached.Shared(value="cachedTypeClass") @Cached(value="receiver.getShape().getObjectType().getClass()", allowUncached=true) Class<? extends ObjectType> typeClass) {
            return typeClass == receiver.getShape().getObjectType().getClass();
        }
    }
}

