/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaStatInfo;

public class VmaStats
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MEMORYTYPE;
    public static final int MEMORYHEAP;
    public static final int TOTAL;

    public VmaStats(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaStats.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VmaStatInfo[32]")
    public VmaStatInfo.Buffer memoryType() {
        return VmaStats.nmemoryType(this.address());
    }

    public VmaStatInfo memoryType(int index) {
        return VmaStats.nmemoryType(this.address(), index);
    }

    @NativeType(value="VmaStatInfo[16]")
    public VmaStatInfo.Buffer memoryHeap() {
        return VmaStats.nmemoryHeap(this.address());
    }

    public VmaStatInfo memoryHeap(int index) {
        return VmaStats.nmemoryHeap(this.address(), index);
    }

    public VmaStatInfo total() {
        return VmaStats.ntotal(this.address());
    }

    public static VmaStats malloc() {
        return (VmaStats)VmaStats.wrap(VmaStats.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VmaStats calloc() {
        return (VmaStats)VmaStats.wrap(VmaStats.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VmaStats create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VmaStats)VmaStats.wrap(VmaStats.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VmaStats create(long address) {
        return (VmaStats)VmaStats.wrap(VmaStats.class, (long)address);
    }

    @Nullable
    public static VmaStats createSafe(long address) {
        return address == 0L ? null : (VmaStats)VmaStats.wrap(VmaStats.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VmaStats.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VmaStats.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VmaStats.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaStats.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VmaStats.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VmaStats.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VmaStats.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VmaStats mallocStack() {
        return VmaStats.mallocStack(MemoryStack.stackGet());
    }

    public static VmaStats callocStack() {
        return VmaStats.callocStack(MemoryStack.stackGet());
    }

    public static VmaStats mallocStack(MemoryStack stack) {
        return (VmaStats)VmaStats.wrap(VmaStats.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaStats callocStack(MemoryStack stack) {
        return (VmaStats)VmaStats.wrap(VmaStats.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VmaStats.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VmaStats.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VmaStats.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VmaStats.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static VmaStatInfo.Buffer nmemoryType(long struct) {
        return VmaStatInfo.create(struct + (long)MEMORYTYPE, 32);
    }

    public static VmaStatInfo nmemoryType(long struct, int index) {
        return VmaStatInfo.create(struct + (long)MEMORYTYPE + Checks.check((int)index, (int)32) * (long)VmaStatInfo.SIZEOF);
    }

    public static VmaStatInfo.Buffer nmemoryHeap(long struct) {
        return VmaStatInfo.create(struct + (long)MEMORYHEAP, 16);
    }

    public static VmaStatInfo nmemoryHeap(long struct, int index) {
        return VmaStatInfo.create(struct + (long)MEMORYHEAP + Checks.check((int)index, (int)16) * (long)VmaStatInfo.SIZEOF);
    }

    public static VmaStatInfo ntotal(long struct) {
        return VmaStatInfo.create(struct + (long)TOTAL);
    }

    static {
        Struct.Layout layout = VmaStats.__struct((Struct.Member[])new Struct.Member[]{VmaStats.__array((int)VmaStatInfo.SIZEOF, (int)VmaStatInfo.ALIGNOF, (int)32), VmaStats.__array((int)VmaStatInfo.SIZEOF, (int)VmaStatInfo.ALIGNOF, (int)16), VmaStats.__member((int)VmaStatInfo.SIZEOF, (int)VmaStatInfo.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MEMORYTYPE = layout.offsetof(0);
        MEMORYHEAP = layout.offsetof(1);
        TOTAL = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaStats, Buffer>
    implements NativeResource {
        private static final VmaStats ELEMENT_FACTORY = VmaStats.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VmaStats getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VmaStatInfo[32]")
        public VmaStatInfo.Buffer memoryType() {
            return VmaStats.nmemoryType(this.address());
        }

        public VmaStatInfo memoryType(int index) {
            return VmaStats.nmemoryType(this.address(), index);
        }

        @NativeType(value="VmaStatInfo[16]")
        public VmaStatInfo.Buffer memoryHeap() {
            return VmaStats.nmemoryHeap(this.address());
        }

        public VmaStatInfo memoryHeap(int index) {
            return VmaStats.nmemoryHeap(this.address(), index);
        }

        public VmaStatInfo total() {
            return VmaStats.ntotal(this.address());
        }
    }
}

