/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryDedicatedRequirements
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PREFERSDEDICATEDALLOCATION;
    public static final int REQUIRESDEDICATEDALLOCATION;

    public VkMemoryDedicatedRequirements(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryDedicatedRequirements.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryDedicatedRequirements.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkMemoryDedicatedRequirements.npNext(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean prefersDedicatedAllocation() {
        return VkMemoryDedicatedRequirements.nprefersDedicatedAllocation(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean requiresDedicatedAllocation() {
        return VkMemoryDedicatedRequirements.nrequiresDedicatedAllocation(this.address()) != 0;
    }

    public VkMemoryDedicatedRequirements sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryDedicatedRequirements.nsType(this.address(), value);
        return this;
    }

    public VkMemoryDedicatedRequirements pNext(@NativeType(value="void *") long value) {
        VkMemoryDedicatedRequirements.npNext(this.address(), value);
        return this;
    }

    public VkMemoryDedicatedRequirements set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkMemoryDedicatedRequirements set(VkMemoryDedicatedRequirements src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryDedicatedRequirements malloc() {
        return (VkMemoryDedicatedRequirements)VkMemoryDedicatedRequirements.wrap(VkMemoryDedicatedRequirements.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkMemoryDedicatedRequirements calloc() {
        return (VkMemoryDedicatedRequirements)VkMemoryDedicatedRequirements.wrap(VkMemoryDedicatedRequirements.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkMemoryDedicatedRequirements create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkMemoryDedicatedRequirements)VkMemoryDedicatedRequirements.wrap(VkMemoryDedicatedRequirements.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkMemoryDedicatedRequirements create(long address) {
        return (VkMemoryDedicatedRequirements)VkMemoryDedicatedRequirements.wrap(VkMemoryDedicatedRequirements.class, (long)address);
    }

    @Nullable
    public static VkMemoryDedicatedRequirements createSafe(long address) {
        return address == 0L ? null : (VkMemoryDedicatedRequirements)VkMemoryDedicatedRequirements.wrap(VkMemoryDedicatedRequirements.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkMemoryDedicatedRequirements.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkMemoryDedicatedRequirements.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkMemoryDedicatedRequirements.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryDedicatedRequirements.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkMemoryDedicatedRequirements.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkMemoryDedicatedRequirements.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkMemoryDedicatedRequirements.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkMemoryDedicatedRequirements mallocStack() {
        return VkMemoryDedicatedRequirements.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryDedicatedRequirements callocStack() {
        return VkMemoryDedicatedRequirements.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryDedicatedRequirements mallocStack(MemoryStack stack) {
        return (VkMemoryDedicatedRequirements)VkMemoryDedicatedRequirements.wrap(VkMemoryDedicatedRequirements.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryDedicatedRequirements callocStack(MemoryStack stack) {
        return (VkMemoryDedicatedRequirements)VkMemoryDedicatedRequirements.wrap(VkMemoryDedicatedRequirements.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryDedicatedRequirements.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryDedicatedRequirements.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryDedicatedRequirements.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryDedicatedRequirements.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nprefersDedicatedAllocation(long struct) {
        return UNSAFE.getInt(null, struct + (long)PREFERSDEDICATEDALLOCATION);
    }

    public static int nrequiresDedicatedAllocation(long struct) {
        return UNSAFE.getInt(null, struct + (long)REQUIRESDEDICATEDALLOCATION);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkMemoryDedicatedRequirements.__struct((Struct.Member[])new Struct.Member[]{VkMemoryDedicatedRequirements.__member((int)4), VkMemoryDedicatedRequirements.__member((int)POINTER_SIZE), VkMemoryDedicatedRequirements.__member((int)4), VkMemoryDedicatedRequirements.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PREFERSDEDICATEDALLOCATION = layout.offsetof(2);
        REQUIRESDEDICATEDALLOCATION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryDedicatedRequirements, Buffer>
    implements NativeResource {
        private static final VkMemoryDedicatedRequirements ELEMENT_FACTORY = VkMemoryDedicatedRequirements.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkMemoryDedicatedRequirements getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryDedicatedRequirements.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkMemoryDedicatedRequirements.npNext(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean prefersDedicatedAllocation() {
            return VkMemoryDedicatedRequirements.nprefersDedicatedAllocation(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean requiresDedicatedAllocation() {
            return VkMemoryDedicatedRequirements.nrequiresDedicatedAllocation(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryDedicatedRequirements.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkMemoryDedicatedRequirements.npNext(this.address(), value);
            return this;
        }
    }
}

